/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmBlockContext;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmBackend;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCompilationResult;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmVariableAllocation;
import com.oracle.svm.hosted.webimage.wasmgc.FunctionTemplateHolder;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableControlSinkNode;
import jdk.vm.ci.meta.JavaMethod;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageWasmGCPlatform.class})
public class WasmGCFunctionTemplateFeature
implements InternalFeature {
    public void afterAnalysis(Feature.AfterAnalysisAccess a) {
        FeatureImpl.AfterAnalysisAccessImpl access = (FeatureImpl.AfterAnalysisAccessImpl)a;
        FunctionTemplateHolder.singleton().functionTemplatesPlaceholder = access.getMetaAccess().lookupJavaMethod((Executable)ReflectionUtil.lookupMethod(FunctionTemplateHolder.class, (String)"placeHolderMethod", (Class[])new Class[0]));
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.BeforeCompilationAccessImpl access = (FeatureImpl.BeforeCompilationAccessImpl)a;
        HostedMethod placeholder = access.getUniverse().lookup((JavaMethod)WasmGCFunctionTemplateFeature.getFunctionTemplatesPlaceholder());
        placeholder.compilationInfo.setCustomCompileFunction((debug, method, identifier, reason, config) -> {
            throw GraalError.shouldNotReachHere((String)("Function templates must not be created yet. This method has been scheduled for compilation too early, it must only be scheduled once all compilation finish:" + String.valueOf(method)));
        });
    }

    public static AnalysisMethod getFunctionTemplatesPlaceholder() {
        return FunctionTemplateHolder.singleton().functionTemplatesPlaceholder;
    }

    public static CompilationResult createFunctionTemplates(DebugContext debug, HostedMethod method, CompilationIdentifier identifier, CompileQueue.CompileReason reason, RuntimeConfiguration config) {
        StructuredGraph graph = new StructuredGraph.Builder(debug.getOptions(), debug).build();
        graph.addAfterFixed((FixedWithNextNode)graph.start(), (FixedNode)graph.add((Node)new UnreachableControlSinkNode()));
        WebImageWasmBackend backend = (WebImageWasmBackend)config.getBackendForNormalMethod();
        WebImageWasmCompilationResult result = backend.newCompilationResult(identifier, "WasmGC Function Templates");
        result.setGraph(graph);
        WebImageWasmVariableAllocation variableAllocation = new WebImageWasmVariableAllocation();
        WasmBlockContext topLevel = WasmBlockContext.getTopLevel(Instructions.asInstructions(new Instruction[0]));
        WasmCodeGenTool codeGenTool = backend.createCodeGenTool(variableAllocation, result, topLevel, graph);
        List<WasmFunctionTemplate<?>> templates = backend.getWasmProviders().knownIds().getFunctionTemplates();
        List<Function> functionTemplates = WasmGCFunctionTemplateFeature.createFunctionTemplates(templates, (t, f) -> t.createFunctionForId(codeGenTool, (WasmId.Func)f));
        functionTemplates.forEach(result::addExtraFunction);
        return result;
    }

    public static List<Function> createFunctionTemplates(List<WasmFunctionTemplate<?>> templates, BiFunction<WasmFunctionTemplate<?>, WasmId.Func, Function> generator) {
        boolean hasWork;
        ArrayList<Function> functions = new ArrayList<Function>();
        do {
            for (WasmFunctionTemplate<?> t2 : templates) {
                for (WasmId.Func f : t2.getNotYetGenerated()) {
                    functions.add(generator.apply(t2, f));
                }
            }
        } while (hasWork = templates.stream().anyMatch(t -> !t.allFunctionsGenerated()));
        templates.forEach(WasmFunctionTemplate::freeze);
        return functions;
    }
}

