/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.WasmImports;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.wasmgc.WasmExtern;
import com.oracle.svm.webimage.wasmgc.annotation.WasmExport;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

@Platforms(value={WebImageWasmGCPlatform.class})
public class WasmGCConversion {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor PROXY_OBJECT = SnippetRuntime.findForeignCall(WasmGCConversion.class, (String)"proxyObject", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{PROXY_OBJECT});
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static WasmExtern proxyObject(Object o) {
        if (o instanceof WasmExtern) {
            WasmExtern extern = (WasmExtern)o;
            return extern;
        }
        if (o instanceof char[]) {
            char[] chars = (char[])o;
            return WasmGCConversion.proxyCharArray(WasmImports.PROXY_CHAR_ARRAY, chars);
        }
        throw VMError.shouldNotReachHere((String)("Tried to proxy unsupported object type: " + String.valueOf(o.getClass())));
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native WasmExtern proxyCharArray(@Node.ConstantNodeParameter ForeignCallDescriptor var0, char[] var1);

    @WasmExport(value="string.fromchars", comment="Create Java String from Java char array")
    public static String stringFromCharArray(char[] chars) {
        return new String(chars);
    }
}

