/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.ArrayUtil;
import com.oracle.svm.webimage.wasm.WasmForeignCallDescriptor;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.ForeignCallWithExceptionNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public class WasmGCArrayCopySupport {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAYCOPY = SnippetRuntime.findForeignCall(WasmGCArrayCopySupport.class, (String)"doArraycopy", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ARRAYCOPY};
    public static final Map<WasmForeignCallDescriptor, JavaKind> COPY_FOREIGN_CALLS = new HashMap<WasmForeignCallDescriptor, JavaKind>();
    public static final WasmForeignCallDescriptor COPY_BYTE = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Byte);
    public static final WasmForeignCallDescriptor COPY_BOOLEAN = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Boolean);
    public static final WasmForeignCallDescriptor COPY_SHORT = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Short);
    public static final WasmForeignCallDescriptor COPY_CHAR = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Char);
    public static final WasmForeignCallDescriptor COPY_INT = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Int);
    public static final WasmForeignCallDescriptor COPY_LONG = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Long);
    public static final WasmForeignCallDescriptor COPY_FLOAT = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Float);
    public static final WasmForeignCallDescriptor COPY_DOUBLE = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Double);
    public static final WasmForeignCallDescriptor COPY_OBJECT = WasmGCArrayCopySupport.createCopyForeignCall(JavaKind.Object);

    private static WasmForeignCallDescriptor createCopyForeignCall(JavaKind componentKind) {
        WasmForeignCallDescriptor descriptor = new WasmForeignCallDescriptor("arraycopy." + String.valueOf(componentKind), Void.TYPE, new Class[]{Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE});
        COPY_FOREIGN_CALLS.put(descriptor, componentKind);
        return descriptor;
    }

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    public static void registerLowering(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        lowerings.put(ArrayCopyNode.class, new ArrayCopyLowering());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void doArraycopy(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        if (fromArray == null || toArray == null) {
            throw new NullPointerException();
        }
        DynamicHub fromHub = KnownIntrinsics.readHub((Object)fromArray);
        Class fromClass = DynamicHub.toClass((DynamicHub)fromHub);
        DynamicHub toHub = KnownIntrinsics.readHub((Object)toArray);
        int fromLayoutEncoding = fromHub.getLayoutEncoding();
        if (LayoutEncoding.isArray((int)fromLayoutEncoding)) {
            if (fromHub == toHub) {
                ArrayUtil.boundsCheckInSnippet((Object)fromArray, (int)fromIndex, (Object)toArray, (int)toIndex, (int)length);
                if (fromClass == byte[].class) {
                    WasmGCArrayCopySupport.copy(COPY_BYTE, fromArray, fromIndex, toArray, toIndex, length);
                } else if (fromClass == boolean[].class) {
                    WasmGCArrayCopySupport.copy(COPY_BOOLEAN, fromArray, fromIndex, toArray, toIndex, length);
                } else if (fromClass == short[].class) {
                    WasmGCArrayCopySupport.copy(COPY_SHORT, fromArray, fromIndex, toArray, toIndex, length);
                } else if (fromClass == char[].class) {
                    WasmGCArrayCopySupport.copy(COPY_CHAR, fromArray, fromIndex, toArray, toIndex, length);
                } else if (fromClass == int[].class) {
                    WasmGCArrayCopySupport.copy(COPY_INT, fromArray, fromIndex, toArray, toIndex, length);
                } else if (fromClass == long[].class) {
                    WasmGCArrayCopySupport.copy(COPY_LONG, fromArray, fromIndex, toArray, toIndex, length);
                } else if (fromClass == float[].class) {
                    WasmGCArrayCopySupport.copy(COPY_FLOAT, fromArray, fromIndex, toArray, toIndex, length);
                } else if (fromClass == double[].class) {
                    WasmGCArrayCopySupport.copy(COPY_DOUBLE, fromArray, fromIndex, toArray, toIndex, length);
                } else {
                    assert (LayoutEncoding.isObjectArray((int)fromLayoutEncoding));
                    WasmGCArrayCopySupport.copy(COPY_OBJECT, fromArray, fromIndex, toArray, toIndex, length);
                }
                return;
            }
            if (LayoutEncoding.isObjectArray((int)fromLayoutEncoding) && LayoutEncoding.isObjectArray((int)toHub.getLayoutEncoding())) {
                ArrayUtil.boundsCheckInSnippet((Object)fromArray, (int)fromIndex, (Object)toArray, (int)toIndex, (int)length);
                if (DynamicHub.toClass((DynamicHub)toHub).isAssignableFrom(DynamicHub.toClass((DynamicHub)fromHub))) {
                    WasmGCArrayCopySupport.copy(COPY_OBJECT, fromArray, fromIndex, toArray, toIndex, length);
                } else {
                    JavaMemoryUtil.copyObjectArrayForwardWithStoreCheck((Object)fromArray, (int)fromIndex, (Object)toArray, (int)toIndex, (int)length);
                }
                return;
            }
        }
        throw new ArrayStoreException();
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void copy(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, int var2, Object var3, int var4, int var5);

    static final class ArrayCopyLowering
    implements NodeLoweringProvider<ArrayCopyNode> {
        ArrayCopyLowering() {
        }

        public void lower(ArrayCopyNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)ARRAYCOPY, new ValueNode[]{node.getSource(), node.getSourcePosition(), node.getDestination(), node.getDestinationPosition(), node.getLength()}));
            call.setStateAfter(node.stateAfter());
            call.setStateDuring(node.stateDuring());
            call.setBci(node.bci());
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }
}

