/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasmgc;

import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.MissingReflectionRegistrationUtils;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.webimage.wasmgc.codegen.WebImageWasmGCProviders;
import java.lang.reflect.Array;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.word.LocationIdentity;

public class WasmGCAllocationSupport {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor DYNAMIC_NEW_ARRAY = SnippetRuntime.findForeignCall(WasmGCAllocationSupport.class, (String)"dynamicNewArray", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor NEW_MULTI_ARRAY = SnippetRuntime.findForeignCall(WasmGCAllocationSupport.class, (String)"newMultiArray", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{DYNAMIC_NEW_ARRAY, NEW_MULTI_ARRAY};

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static Object dynamicNewArray(DynamicHub componentHub, int length) {
        Class<?> checkedComponentClass = WasmGCAllocationSupport.getCheckedComponentClass(componentHub);
        return WasmGCAllocationSupport.dynamicNewArrayImpl(checkedComponentClass, length);
    }

    private static Object dynamicNewArrayImpl(Class<?> componentType, int length) {
        throw VMError.shouldNotReachHere((String)"This method should have been intrinsified");
    }

    private static Class<?> getCheckedComponentClass(DynamicHub componentType) {
        DynamicHub arrayHub;
        if (BranchProbabilityNode.probability((double)0.999999, (componentType != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (componentType != DynamicHub.fromClass(Void.TYPE) ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, ((arrayHub = componentType.getArrayHub()) != null ? 1 : 0) != 0) && BranchProbabilityNode.probability((double)0.999999, (boolean)arrayHub.isInstantiated())) {
            return DynamicHub.toClass((DynamicHub)componentType);
        }
        throw WasmGCAllocationSupport.arrayHubErrorStub(componentType);
    }

    private static RuntimeException arrayHubErrorStub(DynamicHub componentType) {
        if (componentType == null) {
            throw new NullPointerException("Allocation type is null.");
        }
        if (componentType == DynamicHub.fromClass(Void.TYPE)) {
            throw new IllegalArgumentException("Cannot allocate void array.");
        }
        if (componentType.getArrayHub() == null || !componentType.getArrayHub().isInstantiated()) {
            throw MissingReflectionRegistrationUtils.reportArrayInstantiation((Class)DynamicHub.toClass((DynamicHub)componentType), (int)1);
        }
        throw VMError.shouldNotReachHereUnexpectedInput((Object)componentType);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static Object newMultiArray(Class<?> clazz, int[] dimensions) {
        return WasmGCAllocationSupport.newMultiArrayRecursion(clazz, 0, dimensions);
    }

    private static Object newMultiArrayRecursion(Class<?> clazz, int idx, int[] dimensions) {
        int length = dimensions[idx];
        Object result = Array.newInstance(clazz.componentType(), length);
        if (idx < dimensions.length - 1) {
            Object[] objectArray = (Object[])result;
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = WasmGCAllocationSupport.newMultiArrayRecursion(clazz.getComponentType(), idx + 1, dimensions);
            }
        }
        return result;
    }

    public static void preRegisterAllocationTemplates(WebImageWasmGCProviders providers) {
        for (HostedType type : ((HostedMetaAccess)providers.getMetaAccess()).getUniverse().getTypes()) {
            if (!WasmGCAllocationSupport.needsDynamicAllocationTemplate(type)) continue;
            providers.knownIds().instanceCreateTemplate.requestFunctionId(type.getJavaClass());
        }
    }

    public static boolean needsDynamicAllocationTemplate(HostedType type) {
        return type.isInstanceClass() && type.getWrapped().isUnsafeAllocated();
    }
}

