/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.substitute;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmTrapNode;
import com.oracle.svm.webimage.substitute.system.Target_java_lang_Throwable_Web;
import jdk.graal.compiler.nodes.UnreachableNode;

public class VMErrorSubstitutions {
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in fatal error handling.")
    static RuntimeException shouldNotReachHere(String msg, Throwable ex) {
        VMErrorSubstitutions.shutdown(msg, ex);
        throw UnreachableNode.unreachable();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
    static void shutdown(String msg, Throwable ex) {
        Log log = Log.log();
        if (log != null) {
            try {
                log.string("Fatal error");
                if (msg != null) {
                    log.string(": ").string(msg);
                }
                if (ex != null) {
                    log.string(": ").string(ex.getClass().getName()).string(": ").string(((Target_java_lang_Throwable_Web)SubstrateUtil.cast((Object)ex, Target_java_lang_Throwable_Web.class)).detailMessage);
                }
                log.newline();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        WasmTrapNode.trap();
    }
}

