/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.stack;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.hosted.webimage.wasm.gc.MemoryLayout;
import com.oracle.svm.hosted.webimage.wasm.stack.WebImageWasmStackFrameVisitor;
import com.oracle.svm.hosted.webimage.wasm.stack.WebImageWasmStackWalk;
import com.oracle.svm.webimage.wasm.code.FrameData;
import com.oracle.svm.webimage.wasm.code.WasmCodeInfoHolder;
import com.oracle.svm.webimage.wasm.code.WasmCodeInfoQueryResult;
import com.oracle.svm.webimage.wasm.code.WasmSimpleCodeInfoQueryResult;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class WebImageWasmStackWalker {
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    private static void initialize(WebImageWasmStackWalk walk, Pointer startSP, CodePointer startIP) {
        assert (startIP.isNonNull());
        walk.setSP(startSP);
        walk.setIP(startIP);
        walk.setEndSP(MemoryLayout.getStackBase());
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean walkCurrentThread(Pointer startSP, WebImageWasmStackFrameVisitor visitor) {
        CodePointer startIP = FrameAccess.singleton().readReturnAddress(CurrentIsolate.getCurrentThread(), startSP);
        WebImageWasmStackWalk walk = (WebImageWasmStackWalk)StackValue.get(WebImageWasmStackWalk.class);
        WebImageWasmStackWalker.initialize(walk, startSP, startIP);
        return WebImageWasmStackWalker.doWalk(walk, CurrentIsolate.getCurrentThread(), visitor);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    private static boolean doWalk(WebImageWasmStackWalk walk, IsolateThread thread, WebImageWasmStackFrameVisitor visitor) {
        do {
            if (WebImageWasmStackWalker.callVisitor(walk, visitor)) continue;
            return false;
        } while (WebImageWasmStackWalker.continueWalk(walk, thread));
        return true;
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean continueWalk(WebImageWasmStackWalk walk, IsolateThread thread) {
        if (walk.getSP().isNull() || walk.getIP().isNull()) {
            return false;
        }
        WasmSimpleCodeInfoQueryResult queryResult = (WasmSimpleCodeInfoQueryResult)StackValue.get(WasmSimpleCodeInfoQueryResult.class);
        WebImageWasmStackWalker.getCodeInfo(walk.getIP(), queryResult);
        return WebImageWasmStackWalker.continueWalk(walk, thread, queryResult);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean continueWalk(WebImageWasmStackWalk walk, IsolateThread thread, WasmSimpleCodeInfoQueryResult queryResult) {
        Pointer sp = walk.getSP();
        FrameData frameData = queryResult.getFrameData();
        long totalFrameSize = frameData.getFrameSize();
        sp = sp.add(Word.unsigned((long)totalFrameSize));
        CodePointer ip = FrameAccess.singleton().readReturnAddress(thread, sp);
        walk.setSP(sp);
        walk.setIP(ip);
        return !walk.getEndSP().isNonNull() || !walk.getSP().aboveOrEqual((UnsignedWord)walk.getEndSP());
    }

    @Uninterruptible(reason="Wraps the now safe call to the possibly interruptible visitor.", callerMustBe=true, calleeMustBe=false)
    @RestrictHeapAccess(reason="Whitelisted because some StackFrameVisitor implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED)
    private static boolean callVisitor(WebImageWasmStackWalk walk, WebImageWasmStackFrameVisitor visitor) {
        return visitor.visitFrame(walk.getSP(), walk.getIP());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void getCodeInfo(CodePointer ip, WasmSimpleCodeInfoQueryResult queryResult) {
        WasmCodeInfoQueryResult result = WasmCodeInfoHolder.getCodeInfo(ip);
        assert (result != null);
        queryResult.setFrameData(result.getFrameData());
        queryResult.setOffsets(result.getReferenceOffsets());
    }
}

