/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.snippets;

import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import com.oracle.svm.webimage.wasmgc.WasmExtern;
import java.util.Arrays;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.word.LocationIdentity;

public class WasmImportForeignCallDescriptor
extends ForeignCallDescriptor {
    private final String module;
    private final String name;
    private final String comment;

    public WasmImportForeignCallDescriptor(String module, String name, Class<?> resultType, Class<?>[] argumentTypes, String comment) {
        super(module + "." + name, resultType, (Class[])argumentTypes, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, new LocationIdentity[]{LocationIdentity.any()}, false, true);
        this.module = module;
        this.name = name;
        this.comment = comment;
    }

    public ImportDescriptor.Function getImportDescriptor(WebImageWasmProviders providers) {
        Class returnType = this.getResultType();
        Class[] argTypes = this.getArgumentTypes();
        WasmValType wasmReturnType = WasmImportForeignCallDescriptor.convertExternType(providers, returnType);
        WasmValType[] wasmArgTypes = (WasmValType[])Arrays.stream(argTypes).map(argType -> WasmImportForeignCallDescriptor.convertExternType(providers, argType)).toArray(WasmValType[]::new);
        TypeUse typeUse = returnType == Void.TYPE ? TypeUse.withoutResult(wasmArgTypes) : TypeUse.withResult(wasmReturnType, wasmArgTypes);
        return new ImportDescriptor.Function(this.module, this.name, typeUse, this.comment);
    }

    private static WasmValType convertExternType(WebImageWasmProviders providers, Class<?> clazz) {
        WasmValType wasmType = clazz == WasmExtern.class ? WasmRefType.EXTERNREF : providers.util().typeForJavaClass(clazz);
        return wasmType;
    }
}

