/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.snippets;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.wasm.snippets.SingleThreadedAtomics;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageWasmLMPlatform.class})
public class SingleThreadedAtomicsFeature
implements InternalFeature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : SingleThreadedAtomics.FOREIGN_CALLS) {
            access.registerAsRoot((AnalysisMethod)descriptor.findMethod((MetaAccessProvider)access.getMetaAccess()), true, "WASM thread atomics support, registered in " + String.valueOf(SingleThreadedAtomicsFeature.class), new MultiMethod.MultiMethodKey[0]);
        }
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(SingleThreadedAtomics.FOREIGN_CALLS);
    }
}

