/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.snippets;

import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public class SingleThreadedAtomics {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor VALUE_COMPARE_AND_SWAP_BYTE = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"byteCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor LOGIC_COMPARE_AND_SWAP_BYTE = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"logicByteCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor VALUE_COMPARE_AND_SWAP_CHAR = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"charCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor LOGIC_COMPARE_AND_SWAP_CHAR = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"logicCharCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor VALUE_COMPARE_AND_SWAP_INT = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"intCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor LOGIC_COMPARE_AND_SWAP_INT = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"logicIntCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor VALUE_COMPARE_AND_SWAP_LONG = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"longCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor LOGIC_COMPARE_AND_SWAP_LONG = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"logicLongCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor VALUE_COMPARE_AND_SWAP_OBJECT = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"objectCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor LOGIC_COMPARE_AND_SWAP_OBJECT = SnippetRuntime.findForeignCall(SingleThreadedAtomics.class, (String)"logicObjectCompareAndSwap", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{VALUE_COMPARE_AND_SWAP_BYTE, LOGIC_COMPARE_AND_SWAP_BYTE, VALUE_COMPARE_AND_SWAP_CHAR, LOGIC_COMPARE_AND_SWAP_CHAR, VALUE_COMPARE_AND_SWAP_INT, LOGIC_COMPARE_AND_SWAP_INT, VALUE_COMPARE_AND_SWAP_LONG, LOGIC_COMPARE_AND_SWAP_LONG, VALUE_COMPARE_AND_SWAP_OBJECT, LOGIC_COMPARE_AND_SWAP_OBJECT};

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int intCompareAndSwap(int addressNum, int expectedValue, int newValue) {
        Word address = (Word)Word.unsigned((int)addressNum);
        int oldValue = address.readInt(0);
        if (oldValue == expectedValue) {
            address.writeInt(0, newValue);
        }
        return oldValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static byte byteCompareAndSwap(int addressNum, byte expectedValue, byte newValue) {
        Word address = (Word)Word.unsigned((int)addressNum);
        byte oldValue = address.readByte(0);
        if (oldValue == expectedValue) {
            address.writeByte(0, newValue);
        }
        return oldValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicByteCompareAndSwap(int address, char expectedValue, char newValue) {
        return SingleThreadedAtomics.charCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static char charCompareAndSwap(int addressNum, char expectedValue, char newValue) {
        Word address = (Word)Word.unsigned((int)addressNum);
        char oldValue = address.readChar(0);
        if (oldValue == expectedValue) {
            address.writeChar(0, newValue);
        }
        return oldValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicCharCompareAndSwap(int address, byte expectedValue, byte newValue) {
        return SingleThreadedAtomics.byteCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicIntCompareAndSwap(int address, int expectedValue, int newValue) {
        return SingleThreadedAtomics.intCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static long longCompareAndSwap(int addressNum, long expectedValue, long newValue) {
        Word address = (Word)Word.unsigned((int)addressNum);
        long oldValue = address.readLong(0);
        if (oldValue == expectedValue) {
            address.writeLong(0, newValue);
        }
        return oldValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicLongCompareAndSwap(int address, long expectedValue, long newValue) {
        return SingleThreadedAtomics.longCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object objectCompareAndSwap(int addressNum, Object expectedValue, Object newValue) {
        Word address = (Word)Word.unsigned((int)addressNum);
        Object oldValue = address.readObject(0);
        if (oldValue == expectedValue) {
            address.writeObject(0, newValue);
        }
        return oldValue;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static boolean logicObjectCompareAndSwap(int address, Object expectedValue, Object newValue) {
        return SingleThreadedAtomics.objectCompareAndSwap(address, expectedValue, newValue) == expectedValue;
    }
}

