/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.print;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmPrintNode;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import com.oracle.svm.webimage.print.WebImagePrintingProvider;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CShortPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredImageSingleton(value={WebImagePrintingProvider.class})
@Platforms(value={WebImageWasmLMPlatform.class})
public class WebImageWasmLMPrintingProvider
extends WebImagePrintingProvider {
    @Override
    @Uninterruptible(reason="Handles untracked pointers.")
    public void print(WebImagePrintingProvider.Descriptor fd, char[] chars) {
        DynamicHub hub = KnownIntrinsics.readHub((Object)chars);
        UnsignedWord baseOffset = LayoutEncoding.getArrayBaseOffset((int)hub.getLayoutEncoding());
        CShortPointer dataPtr = (CShortPointer)Word.objectToUntrackedPointer((Object)chars).add(baseOffset);
        WasmPrintNode.print(fd.num, 2, (PointerBase)dataPtr, Word.unsigned((int)chars.length));
    }

    @Override
    public void flush(WebImagePrintingProvider.Descriptor fd) {
        switch (fd) {
            case OUT: {
                JSCallNode.call(JSCallNode.PRINT_FLUSH_OUT);
                break;
            }
            case ERR: {
                JSCallNode.call(JSCallNode.PRINT_FLUSH_ERR);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }

    @Override
    public void close(WebImagePrintingProvider.Descriptor fd) {
        switch (fd) {
            case OUT: {
                JSCallNode.call(JSCallNode.PRINT_CLOSE_OUT);
                break;
            }
            case ERR: {
                JSCallNode.call(JSCallNode.PRINT_CLOSE_ERR);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereAtRuntime();
            }
        }
    }
}

