/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import com.oracle.svm.hosted.webimage.codegen.phase.ReconstructionVerificationPhase;
import com.oracle.svm.hosted.webimage.codegen.phase.WebImageLowTier;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.wasm.phases.StackPointerVerificationPhase;
import com.oracle.svm.hosted.webimage.wasm.phases.UnorderedIsTruePhase;
import com.oracle.svm.hosted.webimage.wasm.phases.ValueDropPhase;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmLMSingleThreadedAtomicsPhase;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmSimplification;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmStackifierReconstructionPhase;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmSwitchPhase;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.StackifierReconstructionPhase;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PlaceholderPhase;
import jdk.graal.compiler.phases.common.AddressLoweringPhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.ExpandLogicPhase;
import jdk.graal.compiler.phases.common.FixReadsPhase;
import jdk.graal.compiler.phases.common.LowTierLoweringPhase;
import jdk.graal.compiler.phases.schedule.SchedulePhase;

public class WebImageWasmLMLowTier
extends WebImageLowTier {
    public WebImageWasmLMLowTier(OptionValues options) {
        super(options);
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create().copyWithCustomSimplification((CanonicalizerPhase.CustomSimplification)new WasmSimplification());
        if (((Boolean)WebImageOptions.DebugOptions.RuntimeDebugChecks.getValue(options)).booleanValue()) {
            this.prependPhase(new StackPointerVerificationPhase());
        }
        this.prependPhase(new ValueDropPhase());
        this.prependPhase((BasePhase)new PlaceholderPhase(AddressLoweringPhase.class));
        this.prependPhase(new UnorderedIsTruePhase(canonicalizer));
        this.prependPhase(new WasmLMSingleThreadedAtomicsPhase());
        this.prependPhase((BasePhase)new FixReadsPhase(true, (BasePhase)new SchedulePhase((Boolean)GraalOptions.StressTestEarlyReads.getValue(options) != false ? SchedulePhase.SchedulingStrategy.EARLIEST : SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS)));
        this.prependPhase((BasePhase)new ExpandLogicPhase(canonicalizer));
        this.prependPhase((BasePhase)new LowTierLoweringPhase(canonicalizer));
        this.prependPhase(new WasmSwitchPhase(canonicalizer));
        this.removePhase(ReconstructionVerificationPhase.class);
    }

    @Override
    protected StackifierReconstructionPhase createStackifierPhase() {
        return new WasmStackifierReconstructionPhase();
    }
}

