/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import com.oracle.svm.hosted.webimage.wasm.nodes.WasmAddressNode;
import com.oracle.svm.webimage.wasm.types.WasmLMUtil;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.phases.common.AddressLoweringByNodePhase;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class WebImageWasmLMAddressLowering
extends AddressLoweringByNodePhase.AddressLowering {
    public AddressNode lower(ValueNode base, ValueNode offset) {
        boolean isConstant;
        ValueNode newOffset;
        ValueNode newBase;
        StructuredGraph graph = base.graph();
        if (WebImageWasmLMAddressLowering.isCompatibleConstantOffset(offset)) {
            newBase = base;
            newOffset = offset;
            isConstant = true;
        } else if (WebImageWasmLMAddressLowering.isCompatibleConstantOffset(base)) {
            newBase = offset;
            newOffset = base;
            isConstant = true;
        } else {
            newBase = base;
            newOffset = offset;
            isConstant = false;
        }
        if (newOffset.getStackKind().isNumericInteger()) {
            newOffset = (ValueNode)graph.addOrUnique((Node)NarrowNode.create((ValueNode)newOffset, (int)WasmLMUtil.POINTER_TYPE.getBitCount(), (NodeView)NodeView.DEFAULT));
        }
        return (AddressNode)graph.unique((Node)new WasmAddressNode(newBase, newOffset, isConstant));
    }

    private static boolean isCompatibleConstantOffset(ValueNode node) {
        JavaConstant constant = node.asJavaConstant();
        if (constant == null) {
            return false;
        }
        JavaKind kind = constant.getJavaKind();
        if (kind.isNumericInteger()) {
            long value = constant.asLong();
            return value >= 0L && value <= Integer.MAX_VALUE;
        }
        return kind == JavaKind.Object;
    }
}

