/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;

public class WasmSwitchPhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;

    public WasmSwitchPhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    protected void run(StructuredGraph graph, CoreProviders context) {
        for (IntegerSwitchNode switchNode2 : graph.getNodes().filter(IntegerSwitchNode.class)) {
            if (WasmSwitchPhase.replaceTwoCase(graph, switchNode2) || WasmSwitchPhase.correctContiguousOffset(graph, switchNode2)) continue;
            WasmSwitchPhase.replaceWithIfChain(graph, switchNode2);
        }
        graph.getNodes().filter(IntegerSwitchNode.class).forEach(switchNode -> {
            assert (WasmSwitchPhase.isSimplified(switchNode)) : switchNode;
        });
        this.canonicalizer.apply(graph, (Object)context);
    }

    private static boolean replaceTwoCase(StructuredGraph graph, IntegerSwitchNode switchNode) {
        if (switchNode.keyCount() != 1) {
            return false;
        }
        int key = switchNode.intKeyAt(0);
        AbstractBeginNode keySuccessor = switchNode.successorAtKey(key);
        AbstractBeginNode defaultSuccessor = switchNode.defaultSuccessor();
        ProfileData.BranchProbabilityData probabilityData = ProfileData.BranchProbabilityData.create((double)switchNode.probability(keySuccessor), (ProfileData.ProfileSource)switchNode.profileSource());
        LogicNode condition = (LogicNode)graph.addOrUniqueWithInputs((Node)IntegerEqualsNode.create((ValueNode)switchNode.switchValue(), (ValueNode)ConstantNode.forInt((int)key), (NodeView)NodeView.DEFAULT));
        IfNode ifNode = new IfNode(condition, keySuccessor, defaultSuccessor, probabilityData);
        WasmSwitchPhase.replaceSwitch(graph, switchNode, (ControlSplitNode)ifNode);
        return true;
    }

    private static boolean correctContiguousOffset(StructuredGraph graph, IntegerSwitchNode switchNode) {
        if (!WasmSwitchPhase.isContiguous(switchNode)) {
            return false;
        }
        int firstKey = switchNode.intKeyAt(0);
        if (firstKey == 0) {
            assert (WasmSwitchPhase.isSimplified(switchNode)) : switchNode;
            return true;
        }
        ValueNode correctedValue = SubNode.sub((StructuredGraph)graph, (ValueNode)switchNode.value(), (ValueNode)ConstantNode.forInt((int)firstKey), (NodeView)NodeView.DEFAULT);
        int[] newKeys = IntStream.range(0, switchNode.keyCount()).toArray();
        AbstractBeginNode[] blockSuccessors = new AbstractBeginNode[switchNode.blockSuccessorCount()];
        for (int i = 0; i < blockSuccessors.length; ++i) {
            blockSuccessors[i] = switchNode.blockSuccessor(i);
        }
        IntegerSwitchNode newSwitch = new IntegerSwitchNode(correctedValue, blockSuccessors, newKeys, switchNode.getKeySuccessors(), switchNode.getProfileData());
        WasmSwitchPhase.replaceSwitch(graph, switchNode, (ControlSplitNode)newSwitch);
        return true;
    }

    private static void replaceWithIfChain(StructuredGraph graph, IntegerSwitchNode switchNode) {
        int numSuccessors = switchNode.getSuccessorCount();
        Map<Integer, List<Integer>> successorToKeys = WasmSwitchPhase.getSuccessorToKeysMap(switchNode);
        assert (numSuccessors > 1) : numSuccessors;
        AbstractBeginNode nextElseBranch = switchNode.defaultSuccessor();
        switchNode.setBlockSuccessor(switchNode.defaultSuccessorIndex(), null);
        for (int successorIndex = 0; successorIndex < numSuccessors; ++successorIndex) {
            AbstractBeginNode successor = switchNode.blockSuccessor(successorIndex);
            if (switchNode.defaultSuccessorIndex() == successorIndex) continue;
            List<Integer> keys = successorToKeys.get(successorIndex);
            assert (!keys.isEmpty()) : "Successor " + String.valueOf(successor) + " does not have any associated keys";
            Stream<LogicNode> keyChecks = keys.stream().map(ConstantNode::forInt).map(keyNode -> IntegerEqualsNode.create((ValueNode)switchNode.switchValue(), (ValueNode)keyNode, (NodeView)NodeView.DEFAULT)).map(arg_0 -> ((StructuredGraph)graph).addOrUniqueWithInputs(arg_0));
            LogicNode anyKeyCheck = keyChecks.reduce((l1, l2) -> LogicNode.or((LogicNode)l1, (LogicNode)l2, (ProfileData.BranchProbabilityData)ProfileData.BranchProbabilityData.unknown())).get();
            double successorProbability = switchNode.probability(successor);
            ProfileData.BranchProbabilityData probabilityData = ProfileData.BranchProbabilityData.create((double)successorProbability, (ProfileData.ProfileSource)switchNode.profileSource());
            switchNode.setBlockSuccessor(successorIndex, null);
            nextElseBranch = (FixedNode)graph.addOrUniqueWithInputs((Node)new IfNode(anyKeyCheck, (FixedNode)successor, (FixedNode)nextElseBranch, probabilityData));
        }
        assert (nextElseBranch instanceof ControlSplitNode) : nextElseBranch;
        WasmSwitchPhase.replaceSwitch(graph, switchNode, (ControlSplitNode)((IfNode)nextElseBranch));
    }

    public static Map<Integer, List<Integer>> getSuccessorToKeysMap(IntegerSwitchNode switchNode) {
        int numSuccessors = switchNode.getSuccessorCount();
        Map<Integer, List<Integer>> successorToKeys = IntStream.range(0, numSuccessors).boxed().collect(Collectors.toUnmodifiableMap(Function.identity(), i -> new ArrayList()));
        for (int keyIndex = 0; keyIndex < switchNode.keyCount(); ++keyIndex) {
            int key = switchNode.intKeyAt(keyIndex);
            int successorIndex = switchNode.successorIndexAtKey(key);
            successorToKeys.get(successorIndex).add(key);
        }
        return successorToKeys;
    }

    private static void replaceSwitch(StructuredGraph graph, IntegerSwitchNode oldSwitch, ControlSplitNode newNode) {
        for (int i = 0; i < oldSwitch.getSuccessorCount(); ++i) {
            if (!newNode.successors().contains((Node)oldSwitch.blockSuccessor(i))) continue;
            oldSwitch.setBlockSuccessor(i, null);
        }
        ControlSplitNode added = (ControlSplitNode)graph.addOrUnique((Node)newNode);
        ((FixedWithNextNode)oldSwitch.predecessor()).setNext((FixedNode)added);
        GraphUtil.killCFG((FixedNode)oldSwitch);
    }

    public static boolean isSimplified(IntegerSwitchNode switchNode) {
        int firstKey = switchNode.intKeyAt(0);
        return WasmSwitchPhase.isContiguous(switchNode) && firstKey == 0;
    }

    public static boolean isContiguous(IntegerSwitchNode switchNode) {
        assert (switchNode.isSorted()) : switchNode;
        int keyCount = switchNode.keyCount();
        assert (NumUtil.assertPositiveInt((int)keyCount));
        int firstKey = switchNode.intKeyAt(0);
        int lastKey = switchNode.intKeyAt(keyCount - 1);
        return lastKey - firstKey + 1 == keyCount;
    }
}

