/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import com.oracle.svm.hosted.webimage.wasm.nodes.WasmIsNonZeroNode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.vm.ci.meta.JavaKind;

public class WasmSimplification
implements CanonicalizerPhase.CustomSimplification {
    public void simplify(Node node, SimplifierTool tool) {
        if (WasmSimplification.introduceIsNonZeroNode(node, tool)) {
            return;
        }
        if (WasmSimplification.tryIsNullOptimization(node)) {
            return;
        }
    }

    private static boolean introduceIsNonZeroNode(Node node, SimplifierTool tool) {
        if (node instanceof IntegerEqualsNode) {
            WasmIsNonZeroNode isNonZeroNode;
            IntegerEqualsNode integerEqualsNode = (IntegerEqualsNode)node;
            ValueNode left = integerEqualsNode.getX();
            ValueNode right = integerEqualsNode.getY();
            if (left.getStackKind() != JavaKind.Int) {
                return false;
            }
            StructuredGraph graph = (StructuredGraph)node.graph();
            if (left.isDefaultConstant()) {
                isNonZeroNode = new WasmIsNonZeroNode(right);
            } else if (right.isDefaultConstant()) {
                isNonZeroNode = new WasmIsNonZeroNode(left);
            } else {
                return false;
            }
            isNonZeroNode = (LogicNode)graph.addOrUniqueWithInputs((Node)LogicNegationNode.create((LogicNode)isNonZeroNode));
            node.replaceAtUsages((Node)isNonZeroNode);
            tool.addToWorkList((Iterable)isNonZeroNode.usages());
            return true;
        }
        return false;
    }

    private static boolean tryIsNullOptimization(Node node) {
        ConditionalNode conditional;
        IfNode ifNode;
        LogicNode logicNode;
        StructuredGraph graph = (StructuredGraph)node.graph();
        if (node instanceof IfNode && (logicNode = (ifNode = (IfNode)node).condition()) instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)logicNode;
            ifNode.setCondition((LogicNode)graph.addOrUniqueWithInputs((Node)LogicNegationNode.create((LogicNode)new WasmIsNonZeroNode(isNullNode.getValue()))));
            ifNode.eliminateNegation();
            return true;
        }
        if (node instanceof ConditionalNode && (logicNode = (conditional = (ConditionalNode)node).condition()) instanceof IsNullNode) {
            IsNullNode isNullNode = (IsNullNode)logicNode;
            WasmIsNonZeroNode newCondition = new WasmIsNonZeroNode(isNullNode.getValue());
            ValueNode newConditional = (ValueNode)graph.addOrUniqueWithInputs((Node)ConditionalNode.create((LogicNode)newCondition, (ValueNode)conditional.falseValue(), (ValueNode)conditional.trueValue(), (NodeView)NodeView.DEFAULT));
            conditional.replaceAtUsages((Node)newConditional);
            GraphUtil.tryKillUnused((Node)conditional);
            return true;
        }
        return false;
    }
}

