/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.webimage.wasm.phases.SingleThreadedAtomicsPhase;
import com.oracle.svm.hosted.webimage.wasm.snippets.SingleThreadedAtomics;
import java.util.List;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.LogicCompareAndSwapNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaKind;

public class WasmLMSingleThreadedAtomicsPhase
extends SingleThreadedAtomicsPhase {
    @Override
    protected void processCAS(CoreProviders providers, AbstractCompareAndSwapNode cas) {
        StructuredGraph graph = cas.graph();
        boolean isLogic = cas instanceof LogicCompareAndSwapNode;
        SnippetRuntime.SubstrateForeignCallDescriptor target = switch (cas.getExpectedValue().getStackKind()) {
            case JavaKind.Int -> {
                IntegerStamp stamp = (IntegerStamp)cas.stamp(NodeView.DEFAULT);
                if (stamp.getBits() == 8) {
                    if (isLogic) {
                        yield SingleThreadedAtomics.LOGIC_COMPARE_AND_SWAP_BYTE;
                    }
                    yield SingleThreadedAtomics.VALUE_COMPARE_AND_SWAP_BYTE;
                }
                if (stamp.getBits() == 16) {
                    if (isLogic) {
                        yield SingleThreadedAtomics.LOGIC_COMPARE_AND_SWAP_CHAR;
                    }
                    yield SingleThreadedAtomics.VALUE_COMPARE_AND_SWAP_CHAR;
                }
                if (isLogic) {
                    yield SingleThreadedAtomics.LOGIC_COMPARE_AND_SWAP_INT;
                }
                yield SingleThreadedAtomics.VALUE_COMPARE_AND_SWAP_INT;
            }
            case JavaKind.Long -> {
                if (isLogic) {
                    yield SingleThreadedAtomics.LOGIC_COMPARE_AND_SWAP_LONG;
                }
                yield SingleThreadedAtomics.VALUE_COMPARE_AND_SWAP_LONG;
            }
            case JavaKind.Object -> {
                if (isLogic) {
                    yield SingleThreadedAtomics.LOGIC_COMPARE_AND_SWAP_OBJECT;
                }
                yield SingleThreadedAtomics.VALUE_COMPARE_AND_SWAP_OBJECT;
            }
            default -> throw GraalError.unimplemented((String)("CAS with kind " + String.valueOf(cas.getExpectedValue().getStackKind())));
        };
        graph.replaceFixedWithFixed((FixedWithNextNode)cas, (FixedWithNextNode)graph.add((Node)new ForeignCallNode((ForeignCallDescriptor)target, cas.stamp(NodeView.DEFAULT), List.of(cas.getAddress(), cas.getExpectedValue(), cas.getNewValue()))));
    }
}

