/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmBackend;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.debug.BlackholeNode;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;

public class ValueDropPhase
extends BasePhase<LowTierContext> {
    protected void run(StructuredGraph graph, LowTierContext context) {
        WebImageWasmProviders providers = ((WebImageWasmBackend)context.getTargetProvider()).getWasmProviders();
        for (FixedNode node : graph.getNodes().filter(FixedNode.class)) {
            if (!providers.util().hasValue((Node)node) || providers.util().actualUsages((ValueNode)node).isNotEmpty()) continue;
            if (node instanceof ReadExceptionObjectNode && node.hasNoUsages()) {
                graph.removeFixed((FixedWithNextNode)node);
                continue;
            }
            if (node instanceof FixedWithNextNode) {
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)node;
                graph.addAfterFixed(fixedWithNextNode, (FixedNode)graph.add((Node)new BlackholeNode((ValueNode)node)));
                continue;
            }
            if (node instanceof WithExceptionNode) {
                WithExceptionNode withExceptionNode = (WithExceptionNode)node;
                graph.addAfterFixed((FixedWithNextNode)withExceptionNode.next(), (FixedNode)graph.add((Node)new BlackholeNode((ValueNode)node)));
                graph.addAfterFixed((FixedWithNextNode)withExceptionNode.exceptionEdge(), (FixedNode)graph.add((Node)new BlackholeNode((ValueNode)node)));
                continue;
            }
            GraalError.shouldNotReachHere((String)node.toString());
        }
        for (FixedNode node : graph.getNodes().filter(ValueNode.class)) {
            if (!node.stamp(NodeView.DEFAULT).hasValues()) continue;
            GraalError.guarantee((boolean)node.usages().isNotEmpty(), (String)"Value node without usages still exist: %s", (Object)node);
        }
    }
}

