/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import com.oracle.svm.hosted.webimage.wasm.nodes.WasmIsNonZeroNode;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatEqualsNode;
import jdk.graal.compiler.nodes.calc.FloatLessThanNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;

public class UnorderedIsTruePhase
extends BasePhase<CoreProviders> {
    private final CanonicalizerPhase canonicalizer;

    public UnorderedIsTruePhase(CanonicalizerPhase canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    private static ValueNode logicToValue(ValueNode node) {
        if (node instanceof LogicNode) {
            return new ConditionalNode((LogicNode)node, (ValueNode)ConstantNode.forInt((int)1), (ValueNode)ConstantNode.forInt((int)0));
        }
        return node;
    }

    private static LogicNode valueToLogic(ValueNode node) {
        if (node instanceof LogicNode) {
            return (LogicNode)node;
        }
        return new WasmIsNonZeroNode(node);
    }

    protected void run(StructuredGraph graph, CoreProviders context) {
        for (CompareNode node : graph.getNodes().filter(CompareNode.class)) {
            LogicConstantNode replacement;
            if (!node.unorderedIsTrue()) continue;
            assert (node instanceof FloatLessThanNode || node instanceof FloatEqualsNode) : node;
            ValueNode x = node.getX();
            ValueNode y = node.getY();
            FloatStamp stampX = (FloatStamp)x.stamp(NodeView.DEFAULT);
            FloatStamp stampY = (FloatStamp)y.stamp(NodeView.DEFAULT);
            if (stampX.isNaN() || stampY.isNaN()) {
                replacement = LogicConstantNode.tautology();
            } else {
                replacement = CompareNode.createFloatCompareNode((CanonicalCondition)node.condition(), (ValueNode)x, (ValueNode)y, (boolean)false, (NodeView)NodeView.DEFAULT);
                if (stampX.canBeNaN()) {
                    replacement = new ConditionalNode((LogicNode)new FloatEqualsNode(x, x), UnorderedIsTruePhase.logicToValue((ValueNode)replacement), (ValueNode)ConstantNode.forInt((int)1));
                }
                if (stampY.canBeNaN()) {
                    replacement = new ConditionalNode((LogicNode)new FloatEqualsNode(y, y), UnorderedIsTruePhase.logicToValue((ValueNode)replacement), (ValueNode)ConstantNode.forInt((int)1));
                }
                replacement = UnorderedIsTruePhase.valueToLogic((ValueNode)replacement);
            }
            node.replaceAndDelete(graph.addOrUniqueWithInputs((Node)replacement));
        }
        for (CompareNode node : graph.getNodes().filter(CompareNode.class)) {
            assert (!node.unorderedIsTrue()) : node;
        }
        this.canonicalizer.apply(graph, (Object)context);
    }
}

