/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import com.oracle.svm.hosted.webimage.wasm.debug.NoStackVerification;
import com.oracle.svm.hosted.webimage.wasm.debug.WasmDebug;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import org.graalvm.nativeimage.AnnotationAccess;

public class StackPointerVerificationPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)graph.method(), NoStackVerification.class)) {
            return;
        }
        ForeignCallNode originalStackPointer = (ForeignCallNode)graph.addOrUnique((Node)new ForeignCallNode((ForeignCallDescriptor)WasmDebug.READ_STACK_POINTER, new ValueNode[0]));
        graph.addAfterFixed((FixedWithNextNode)graph.start(), (FixedNode)originalStackPointer);
        for (ControlSinkNode controlSink : graph.getNodes().filter(ControlSinkNode.class)) {
            StackPointerVerificationPhase.addCheckBeforeFixed(graph, (FixedNode)controlSink, (ValueNode)originalStackPointer);
        }
        for (InvokeNode invoke : graph.getNodes().filter(InvokeNode.class)) {
            StackPointerVerificationPhase.addCheckBeforeAndAfter(graph, (FixedWithNextNode)invoke, (ValueNode)originalStackPointer);
        }
        for (InvokeNode invoke : graph.getNodes(InvokeWithExceptionNode.TYPE)) {
            StackPointerVerificationPhase.addCheckBeforeFixed(graph, (FixedNode)invoke, (ValueNode)originalStackPointer);
            StackPointerVerificationPhase.addCheckAfterFixed(graph, (FixedWithNextNode)invoke.next(), (ValueNode)originalStackPointer);
            StackPointerVerificationPhase.addCheckAfterFixed(graph, (FixedWithNextNode)invoke.exceptionEdge(), (ValueNode)originalStackPointer);
        }
    }

    private static void addCheckBeforeAndAfter(StructuredGraph graph, FixedWithNextNode fixed, ValueNode originalStackPointer) {
        StackPointerVerificationPhase.addCheckBeforeFixed(graph, (FixedNode)fixed, originalStackPointer);
        StackPointerVerificationPhase.addCheckAfterFixed(graph, fixed, originalStackPointer);
    }

    private static void addCheckBeforeFixed(StructuredGraph graph, FixedNode fixed, ValueNode originalStackPointer) {
        ForeignCallNode checkStackPointer = (ForeignCallNode)graph.addOrUnique((Node)new ForeignCallNode((ForeignCallDescriptor)WasmDebug.CHECK_STACK_POINTER, new ValueNode[]{originalStackPointer}));
        graph.addBeforeFixed(fixed, (FixedWithNextNode)checkStackPointer);
    }

    private static void addCheckAfterFixed(StructuredGraph graph, FixedWithNextNode fixed, ValueNode originalStackPointer) {
        ForeignCallNode checkStackPointer = (ForeignCallNode)graph.addOrUnique((Node)new ForeignCallNode((ForeignCallDescriptor)WasmDebug.CHECK_STACK_POINTER, new ValueNode[]{originalStackPointer}));
        graph.addAfterFixed(fixed, (FixedNode)checkStackPointer);
    }
}

