/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.phases;

import java.util.function.Function;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.LoweredAtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import org.graalvm.word.LocationIdentity;

public abstract class SingleThreadedAtomicsPhase
extends BasePhase<CoreProviders> {
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (AbstractCompareAndSwapNode cas : graph.getNodes(AbstractCompareAndSwapNode.TYPE)) {
            this.processCAS(context, cas);
        }
        for (LoweredAtomicReadAndWriteNode readAndWriteNode : graph.getNodes(LoweredAtomicReadAndWriteNode.TYPE)) {
            this.processReadAndWrite(readAndWriteNode);
        }
        for (LoweredAtomicReadAndAddNode readAndAddNode : graph.getNodes(LoweredAtomicReadAndAddNode.TYPE)) {
            this.processReadAndAdd(readAndAddNode);
        }
    }

    protected abstract void processCAS(CoreProviders var1, AbstractCompareAndSwapNode var2);

    protected void processReadAndWrite(LoweredAtomicReadAndWriteNode readAndWriteNode) {
        SingleThreadedAtomicsPhase.replaceWithReadAndWrite(readAndWriteNode.graph(), (FixedAccessNode)readAndWriteNode, value -> readAndWriteNode.getNewValue());
    }

    protected void processReadAndAdd(LoweredAtomicReadAndAddNode readAndAddNode) {
        StructuredGraph graph = readAndAddNode.graph();
        SingleThreadedAtomicsPhase.replaceWithReadAndWrite(graph, (FixedAccessNode)readAndAddNode, value -> BinaryArithmeticNode.add((StructuredGraph)graph, (ValueNode)value, (ValueNode)readAndAddNode.delta(), (NodeView)NodeView.DEFAULT));
    }

    private static void replaceWithReadAndWrite(StructuredGraph graph, FixedAccessNode readWriteNode, Function<ReadNode, ValueNode> readToWriteValue) {
        AddressNode address = readWriteNode.getAddress();
        LocationIdentity locationIdentity = readWriteNode.getLocationIdentity();
        BarrierType barrierType = readWriteNode.getBarrierType();
        MemoryOrderMode memoryOrder = MemoryOrderMode.VOLATILE;
        ReadNode readNode = (ReadNode)graph.add((Node)new ReadNode(address, locationIdentity, readWriteNode.stamp(NodeView.DEFAULT), barrierType, memoryOrder));
        ValueNode newValue = readToWriteValue.apply(readNode);
        WriteNode writeNode = (WriteNode)graph.add((Node)new WriteNode(address, locationIdentity, newValue, barrierType, memoryOrder));
        graph.replaceFixedWithFixed((FixedWithNextNode)readWriteNode, (FixedWithNextNode)readNode);
        graph.addAfterFixed((FixedWithNextNode)readNode, (FixedNode)writeNode);
    }
}

