/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.nodes;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class WasmPopcntNode
extends UnaryNode {
    public static final NodeClass<WasmPopcntNode> TYPE = NodeClass.create(WasmPopcntNode.class);

    public WasmPopcntNode(ValueNode value) {
        super(TYPE, WasmPopcntNode.computeStamp(value.stamp(NodeView.DEFAULT), value), value);
    }

    public Stamp foldStamp(Stamp newStamp) {
        ValueNode theValue = this.getValue();
        return WasmPopcntNode.computeStamp(newStamp, theValue);
    }

    static Stamp computeStamp(Stamp newStamp, ValueNode theValue) {
        assert (newStamp.isCompatible(theValue.stamp(NodeView.DEFAULT))) : String.valueOf(newStamp) + " is not compatible with " + String.valueOf(theValue.stamp(NodeView.DEFAULT));
        IntegerStamp valueStamp = (IntegerStamp)newStamp;
        assert ((valueStamp.mustBeSet() & CodeUtil.mask((int)valueStamp.getBits())) == valueStamp.mustBeSet()) : valueStamp.mustBeSet();
        assert ((valueStamp.mayBeSet() & CodeUtil.mask((int)valueStamp.getBits())) == valueStamp.mayBeSet()) : valueStamp.mayBeSet();
        return StampFactory.forInteger((JavaKind)theValue.getStackKind(), (long)Long.bitCount(valueStamp.mustBeSet()), (long)Long.bitCount(valueStamp.mayBeSet()));
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isConstant()) {
            JavaConstant c = forValue.asJavaConstant();
            return forValue.getStackKind() == JavaKind.Int ? ConstantNode.forInt((int)Integer.bitCount(c.asInt())) : ConstantNode.forLong((long)Long.bitCount(c.asLong()));
        }
        return this;
    }
}

