/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(shortName="memory.fill", cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_1)
public class WasmMemoryFillNode
extends FixedWithNextNode {
    public static final NodeClass<WasmMemoryFillNode> TYPE = NodeClass.create(WasmMemoryFillNode.class);
    @Node.Input
    ValueNode start;
    @Node.Input
    ValueNode fillValue;
    @Node.Input
    ValueNode size;

    public WasmMemoryFillNode(ValueNode start, ValueNode fillValue, ValueNode size) {
        super(TYPE, StampFactory.forVoid());
        this.start = start;
        this.fillValue = fillValue;
        this.size = size;
        assert (start.getStackKind() == JavaKind.Int) : "memory.fill start needs to be an int";
        assert (size.getStackKind() == JavaKind.Int) : "memory.fill size needs to be an int";
    }

    public ValueNode getStart() {
        return this.start;
    }

    public ValueNode getFillValue() {
        return this.fillValue;
    }

    public ValueNode getSize() {
        return this.size;
    }
}

