/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(shortName="memory.copy", cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_1)
public class WasmMemoryCopyNode
extends FixedWithNextNode {
    public static final NodeClass<WasmMemoryCopyNode> TYPE = NodeClass.create(WasmMemoryCopyNode.class);
    @Node.Input
    ValueNode target;
    @Node.Input
    ValueNode source;
    @Node.Input
    ValueNode size;

    public WasmMemoryCopyNode(ValueNode target, ValueNode source, ValueNode size) {
        super(TYPE, StampFactory.forVoid());
        this.target = target;
        this.source = source;
        this.size = size;
        assert (target.getStackKind() == JavaKind.Int) : "memory.copy target needs to be an int";
        assert (source.getStackKind() == JavaKind.Int) : "memory.copy source needs to be an int";
        assert (size.getStackKind() == JavaKind.Int) : "memory.copy size needs to be an int";
    }

    public ValueNode getTarget() {
        return this.target;
    }

    public ValueNode getSource() {
        return this.source;
    }

    public ValueNode getSize() {
        return this.size;
    }
}

