/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.nodes;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.UnaryOpLogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.TriState;

@NodeInfo(shortName="!= 0", cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_1)
public class WasmIsNonZeroNode
extends UnaryOpLogicNode {
    public static final NodeClass<WasmIsNonZeroNode> TYPE = NodeClass.create(WasmIsNonZeroNode.class);

    public WasmIsNonZeroNode(ValueNode value) {
        super(TYPE, value);
    }

    public Stamp getSucceedingStampForValue(boolean negated) {
        return null;
    }

    public TriState tryFold(Stamp stampGeneric) {
        if (stampGeneric instanceof IntegerStamp) {
            IntegerStamp integerStamp = (IntegerStamp)stampGeneric;
            if (integerStamp.getStackKind() == JavaKind.Int) {
                Stamp zeroStamp = StampFactory.forConstant((JavaConstant)JavaConstant.forInt((int)0));
                if (integerStamp.alwaysDistinct(zeroStamp)) {
                    return TriState.TRUE;
                }
                if (integerStamp.neverDistinct(zeroStamp)) {
                    return TriState.FALSE;
                }
            }
        } else if (stampGeneric instanceof AbstractPointerStamp) {
            AbstractPointerStamp pointerStamp = (AbstractPointerStamp)stampGeneric;
            if (pointerStamp.alwaysNull()) {
                return TriState.FALSE;
            }
            if (pointerStamp.nonNull()) {
                return TriState.TRUE;
            }
        }
        return TriState.UNKNOWN;
    }

    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        return switch (this.tryFold(forValue.stamp(NodeView.DEFAULT))) {
            default -> throw new MatchException(null, null);
            case TriState.TRUE -> LogicConstantNode.tautology();
            case TriState.FALSE -> LogicConstantNode.contradiction();
            case TriState.UNKNOWN -> this;
        };
    }
}

