/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.nodes;

import com.oracle.svm.webimage.wasm.types.WasmLMUtil;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.vm.ci.meta.JavaConstant;

@NodeInfo(allowedUsageTypes={InputType.Association}, cycles=NodeCycles.CYCLES_1, cyclesRationale="Is at most an addition", size=NodeSize.SIZE_1)
public class WasmAddressNode
extends AddressNode {
    public static final NodeClass<WasmAddressNode> TYPE = NodeClass.create(WasmAddressNode.class);
    @Node.Input
    ValueNode base;
    @Node.Input
    ValueNode offset;
    private final boolean isConstantOffset;

    public WasmAddressNode(ValueNode base, ValueNode offset, boolean isConstantOffset) {
        super(TYPE);
        this.base = base;
        this.offset = offset;
        this.isConstantOffset = isConstantOffset;
        if (Assertions.assertionsEnabled()) {
            Stamp localStamp = offset.stamp(NodeView.DEFAULT);
            assert (localStamp instanceof ObjectStamp || IntegerStamp.getBits((Stamp)localStamp) == WasmLMUtil.POINTER_TYPE.getBitCount()) : localStamp;
        }
    }

    public ValueNode getBase() {
        return this.base;
    }

    public ValueNode getIndex() {
        return this.offset;
    }

    public long getMaxConstantDisplacement() {
        throw GraalError.unimplementedOverride();
    }

    public boolean hasConstantOffset() {
        return this.isConstantOffset;
    }

    public JavaConstant getConstantOffset() {
        return this.offset.asJavaConstant();
    }
}

