/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.phases.WebImageHostedGraphKit;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnreachableControlSinkNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class WebImageWasmJNINativeCallWrapperMethod
extends CustomSubstitutionMethod {
    public WebImageWasmJNINativeCallWrapperMethod(ResolvedJavaMethod original) {
        super(original);
    }

    public boolean isSynthetic() {
        return true;
    }

    public int getModifiers() {
        int synthetic = 4096;
        return (this.getOriginal().getModifiers() | 0x1000) & 0xFFFFFEDF;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (((Boolean)WebImageOptions.DebugOptions.VerificationPhases.getValue(debug.getOptions())).booleanValue()) {
            throw GraalError.shouldNotReachHere((String)("Found non-substituted native method " + method.format("%H.%n(%P)")));
        }
        WebImageHostedGraphKit kit = new WebImageHostedGraphKit(debug, providers, (ResolvedJavaMethod)method, purpose);
        JavaConstant errorMessage = providers.getConstantReflection().forString(method.format("Found unsupported native method %H.%n(%P)"));
        ConstantNode errorConstant = (ConstantNode)kit.append((Node)ConstantNode.forConstant((JavaConstant)errorMessage, (MetaAccessProvider)providers.getMetaAccess()));
        kit.createInvokeWithExceptionAndUnwind(ImplicitExceptions.class, "throwLinkageError", CallTargetNode.InvokeKind.Static, new ValueNode[]{errorConstant});
        kit.append((Node)new UnreachableControlSinkNode());
        return kit.finalizeGraph();
    }
}

