/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.jni;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.webimage.wasm.jni.WebImageWasmJNINativeCallWrapperMethod;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageWasmLMPlatform.class, WebImageWasmGCPlatform.class})
public class WasmJNICallWrapperFeature
implements InternalFeature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        config.registerNativeSubstitutionProcessor(new SubstitutionProcessor(this){
            private final Map<ResolvedJavaMethod, WebImageWasmJNINativeCallWrapperMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, WebImageWasmJNINativeCallWrapperMethod>();

            public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
                assert (method.isNative()) : "Must have been registered as a native substitution processor";
                return (ResolvedJavaMethod)this.callWrappers.computeIfAbsent(method, WebImageWasmJNINativeCallWrapperMethod::new);
            }
        });
    }
}

