/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeapVerifier;
import com.oracle.svm.hosted.webimage.wasm.stack.WebImageWasmStackFrameVisitor;
import com.oracle.svm.hosted.webimage.wasm.stack.WebImageWasmStackWalker;
import com.oracle.svm.webimage.wasm.code.WasmSimpleCodeInfoQueryResult;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class WasmStackVerifier {
    private static final StackFrameVerificationVisitor STACK_FRAME_VISITOR = new StackFrameVerificationVisitor();

    @NeverInline(value="Starts stack walk in caller frame")
    public static boolean verify() {
        STACK_FRAME_VISITOR.initialize();
        WebImageWasmStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), STACK_FRAME_VISITOR);
        return STACK_FRAME_VISITOR.getResult();
    }

    private static class StackFrameVerificationVisitor
    extends WebImageWasmStackFrameVisitor {
        private final WasmHeapVerifier.ObjectReferenceVerifier verifyFrameReferencesVisitor = new WasmHeapVerifier.ObjectReferenceVerifier();

        @Platforms(value={Platform.HOSTED_ONLY.class})
        StackFrameVerificationVisitor() {
        }

        public void initialize() {
            this.verifyFrameReferencesVisitor.initialize();
        }

        public boolean getResult() {
            return this.verifyFrameReferencesVisitor.result;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the stack.")
        public boolean visitFrame(Pointer currentSP, CodePointer currentIP) {
            WasmSimpleCodeInfoQueryResult queryResult = (WasmSimpleCodeInfoQueryResult)StackValue.get(WasmSimpleCodeInfoQueryResult.class);
            WebImageWasmStackWalker.getCodeInfo(currentIP, queryResult);
            for (int offset : queryResult.getOffsets()) {
                this.verifyFrameReferencesVisitor.visitObjectReferences(currentSP.add(offset), false, FrameAccess.uncompressedReferenceSize(), null, 1);
            }
            return true;
        }
    }
}

