/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeap;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class WasmObjectHeader
extends ObjectHeader {
    private static final int RESERVED_BITS_MASK = 7;
    private static final UnsignedWord MASK_HEADER_BITS = Word.unsigned((int)7);
    private static final UnsignedWord CLEAR_HEADER_BITS = MASK_HEADER_BITS.not();
    private static final UnsignedWord WHITE_BITS;
    private static final UnsignedWord GRAY_BITS;
    private static final UnsignedWord BLACK_BITS;

    @Fold
    public static WasmObjectHeader getObjectHeaderImpl() {
        WasmObjectHeader oh = WasmHeap.getHeapImpl().getObjectHeaderImpl();
        assert (oh != null);
        return oh;
    }

    public int getReservedHubBitsMask() {
        return 7;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsUnmanagedObjectHeader(DynamicHub hub) {
        return WasmObjectHeader.encodeAsObjectHeader(hub, false, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
    protected void initializeObjectHeader(Pointer objectPointer, Word encodedHub, boolean isArrayLike, ObjectHeader.MemWriter writer) {
        writer.writeWord(objectPointer, WasmObjectHeader.getHubOffset(), encodedHub);
        writer.writeInt(objectPointer, WasmObjectHeader.getIdentityHashCodeOffset(), 0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word readHeaderFromPointer(Pointer objectPointer) {
        return (Word)objectPointer.readWord(WasmObjectHeader.getHubOffset());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word readHeaderFromObject(Object o) {
        return (Word)ObjectAccess.readWord((Object)o, (int)WasmObjectHeader.getHubOffset());
    }

    public boolean hasOptionalIdentityHashField(Word header) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have the identity hash code field in the object header");
            return false;
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public boolean hasIdentityHashFromAddress(Word header) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have the identity hash code field in the object header");
        return false;
    }

    public void setIdentityHashFromAddress(Pointer ptr, Word currentHeader) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"identity hash codes are never computed from addresses");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void dynamicAssert(boolean condition, String msg) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.dynamicAssert((boolean)condition, (String)msg);
        } else assert (condition) : msg;
    }

    private static void writeHeaderToObject(Object o, WordBase header) {
        ObjectAccess.writeWord((Object)o, (int)WasmObjectHeader.getHubOffset(), (WordBase)header);
    }

    public Word encodeAsTLABObjectHeader(DynamicHub hub) {
        return WasmObjectHeader.encodeAsObjectHeader(hub, false, false);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        WasmObjectHeader.dynamicAssert(!rememberedSet, "Remembered set not supported");
        WasmObjectHeader.dynamicAssert(!unaligned, "Unaligned flag not supported");
        return Word.objectToUntrackedPointer((Object)hub);
    }

    public long encodeAsTLABObjectHeader(long hubOffsetFromHeapBase) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public int constantHeaderSize() {
        return -1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer extractPotentialDynamicHubFromHeader(Word header) {
        return (Pointer)WasmObjectHeader.clearBits((UnsignedWord)header);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord clearBits(UnsignedWord header) {
        return header.and(CLEAR_HEADER_BITS);
    }

    public long encodeHubPointerForImageHeap(ImageHeapObject obj, long hubOffsetFromHeapBase) {
        long header = hubOffsetFromHeapBase;
        assert ((header & MASK_HEADER_BITS.rawValue()) == 0L) : "Object header bits must be zero initially";
        return header;
    }

    public void verifyDynamicHubOffsetInImageHeap(long offsetFromHeapBase) {
    }

    public static boolean isWhiteHeader(UnsignedWord header) {
        return header.and(MASK_HEADER_BITS).equal(WHITE_BITS);
    }

    public static boolean isWhiteObject(Object obj) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromObject(obj);
        return WasmObjectHeader.isWhiteHeader((UnsignedWord)header);
    }

    public static void markWhite(Object o) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word oldHeader = oh.readHeaderFromObject(o);
        UnsignedWord newHeader = WasmObjectHeader.clearBits((UnsignedWord)oldHeader).or(WHITE_BITS);
        WasmObjectHeader.writeHeaderToObject(o, (WordBase)newHeader);
    }

    public static boolean isGrayHeader(UnsignedWord header) {
        return header.and(MASK_HEADER_BITS).equal(GRAY_BITS);
    }

    public static boolean isGrayObject(Object obj) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromObject(obj);
        return WasmObjectHeader.isGrayHeader((UnsignedWord)header);
    }

    public static void markGray(Object o) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word oldHeader = oh.readHeaderFromObject(o);
        UnsignedWord newHeader = WasmObjectHeader.clearBits((UnsignedWord)oldHeader).or(GRAY_BITS);
        WasmObjectHeader.writeHeaderToObject(o, (WordBase)newHeader);
    }

    public static boolean isBlackHeader(UnsignedWord header) {
        return header.and(MASK_HEADER_BITS).equal(BLACK_BITS);
    }

    public static boolean isBlackObject(Object obj) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromObject(obj);
        return WasmObjectHeader.isBlackHeader((UnsignedWord)header);
    }

    public static void markBlack(Object o) {
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word oldHeader = oh.readHeaderFromObject(o);
        UnsignedWord newHeader = WasmObjectHeader.clearBits((UnsignedWord)oldHeader).or(BLACK_BITS);
        WasmObjectHeader.writeHeaderToObject(o, (WordBase)newHeader);
    }

    @Fold
    static int getIdentityHashCodeOffset() {
        return ConfigurationValues.getObjectLayout().getObjectHeaderIdentityHashOffset();
    }

    static {
        assert (MASK_HEADER_BITS.rawValue() == 7L);
        assert (CLEAR_HEADER_BITS.rawValue() == -8L);
        WHITE_BITS = Word.unsigned((int)0);
        GRAY_BITS = Word.unsigned((int)1);
        BLACK_BITS = Word.unsigned((int)2);
    }
}

