/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.genscavenge.ChunkedImageHeapLayouter;
import com.oracle.svm.core.genscavenge.remset.NoRememberedSet;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeap;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import jdk.graal.compiler.nodes.gc.NoBarrierSet;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={WebImageWasmLMPlatform.class})
public class WasmLMHeapFeature
implements InternalFeature {
    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(Heap.class, (Object)((Object)new WasmHeap()));
        ImageSingletons.add(RememberedSet.class, (Object)new NoRememberedSet());
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(BarrierSetProvider.class, metaAccess -> new NoBarrierSet());
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        ChunkedImageHeapLayouter heapLayouter = new ChunkedImageHeapLayouter(WasmHeap.getImageHeapInfo(), (long)Heap.getHeap().getImageHeapOffsetInAddressSpace());
        ImageSingletons.add(ImageHeapLayouter.class, (Object)heapLayouter);
    }
}

