/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.gc.BlackenImageHeapRootsVisitor;
import com.oracle.svm.hosted.webimage.wasm.gc.GrayToBlackObjectVisitor;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmAllocation;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmGCCause;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeap;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeapVerifier;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmObjectHeader;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmStackVerifier;
import com.oracle.svm.hosted.webimage.wasm.stack.WebImageWasmStackFrameVisitor;
import com.oracle.svm.hosted.webimage.wasm.stack.WebImageWasmStackWalker;
import com.oracle.svm.webimage.wasm.code.WasmSimpleCodeInfoQueryResult;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class WasmLMGC
implements GC {
    private final GrayToBlackObjectVisitor grayToBlackObjectVisitor = new GrayToBlackObjectVisitor();
    private final BlackenImageHeapRootsVisitor blackenImageHeapRootsVisitor = new BlackenImageHeapRootsVisitor(this.grayToBlackObjectVisitor);
    private final WebImageWasmStackFrameVisitor blackenStackRootsVisitor = new WebImageWasmStackFrameVisitor(){

        @Override
        public boolean visitFrame(Pointer sp, CodePointer ip) {
            WasmSimpleCodeInfoQueryResult queryResult = (WasmSimpleCodeInfoQueryResult)StackValue.get(WasmSimpleCodeInfoQueryResult.class);
            WebImageWasmStackWalker.getCodeInfo(ip, queryResult);
            for (int offset : queryResult.getOffsets()) {
                Object o = sp.readObject(offset);
                if (o == null || WasmHeap.getHeapImpl().isInImageHeap(o)) continue;
                WasmLMGC.this.grayToBlackObjectVisitor.promoteToGray(o);
                WasmLMGC.this.grayToBlackObjectVisitor.visitObject(o);
            }
            return true;
        }
    };
    private final CollectionVMOperation collectOperation = new CollectionVMOperation();
    private final NoAllocationVerifier noAllocationVerifier = NoAllocationVerifier.factory((String)"WasmLMGC.WasmLMGC()", (boolean)false);
    private boolean collectionInProgress;

    @Fold
    public static WasmLMGC getGC() {
        WasmLMGC gcImpl = WasmHeap.getHeapImpl().getGC();
        assert (gcImpl != null);
        return gcImpl;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isCollectionInProgress() {
        return this.collectionInProgress;
    }

    private void startCollectionOrExit() {
        CollectionInProgressError.exitIf(this.collectionInProgress);
        this.collectionInProgress = true;
    }

    private void finishCollection() {
        assert (this.collectionInProgress);
        this.collectionInProgress = false;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void collect(GCCause cause) {
        this.collect(cause, false);
    }

    public void collectCompletely(GCCause cause) {
        this.collect(cause, true);
    }

    public void collectionHint(boolean fullGC) {
    }

    public String getName() {
        return "Wasm GC";
    }

    public String getDefaultMaxHeapSize() {
        return "unknown";
    }

    public void maybeCollectOnAllocation() {
        boolean outOfMemory = false;
        if (WasmLMGC.shouldCollectOnAllocation()) {
            outOfMemory = this.collectWithoutAllocating(WasmGCCause.OnAllocation, false);
        }
        if (outOfMemory) {
            throw OutOfMemoryUtil.heapSizeExceeded();
        }
    }

    private static boolean shouldCollectOnAllocation() {
        return (Boolean)Options.GCStressTest.getValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void collect(GCCause cause, boolean forceFullGC) {
        boolean outOfMemory = this.collectWithoutAllocating(cause, forceFullGC);
        if (outOfMemory) {
            WasmLMGC.throwOutOfMemoryError();
        }
    }

    @Uninterruptible(reason="Switch from uninterruptible to interruptible code.", calleeMustBe=false)
    private static void throwOutOfMemoryError() {
        throw OutOfMemoryUtil.heapSizeExceeded();
    }

    @Uninterruptible(reason="Avoid races with other threads that also try to trigger a GC", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of garbage collection.")
    boolean collectWithoutAllocating(GCCause cause, boolean forceFullGC) {
        int size = SizeOf.get(CollectionVMOperationData.class);
        CollectionVMOperationData data = (CollectionVMOperationData)StackValue.get((int)size);
        UnmanagedMemoryUtil.fill((Pointer)((Pointer)data), (UnsignedWord)Word.unsigned((int)size), (byte)0);
        data.setNativeVMOperation(this.collectOperation);
        data.setCauseId(cause.getId());
        data.setRequestingEpoch((UnsignedWord)Word.zero());
        data.setRequestingNanoTime(System.nanoTime());
        data.setForceFullGC(forceFullGC);
        this.enqueueCollectOperation(data);
        return data.getOutOfMemory();
    }

    @Uninterruptible(reason="Used as a transition between uninterruptible and interruptible code", calleeMustBe=false)
    private void enqueueCollectOperation(CollectionVMOperationData data) {
        this.collectOperation.enqueue(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectOperation(CollectionVMOperationData data) {
        assert (VMOperation.isGCInProgress()) : "Collection should be a VMOperation.";
        this.startCollectionOrExit();
        try (NoAllocationVerifier nav = this.noAllocationVerifier.open();){
            WasmLMGC.verifyGC(HeapVerifier.Occasion.Before);
            this.blackenRoots();
            this.blackenCollectedHeap();
            WasmLMGC.releaseSpace();
            if (WasmAllocation.getObjectPercentage() > (Integer)Options.GrowthTriggerThreshold.getValue()) {
                long numBytes = (long)((double)WasmAllocation.getHeapSize() * ((Double)Options.HeapGrowthFactor.getValue() - 1.0));
                WasmAllocation.growAllocatorRegion(Word.unsigned((long)numBytes));
            }
            WasmLMGC.verifyGC(HeapVerifier.Occasion.After);
        }
        this.finishCollection();
        data.setOutOfMemory(false);
    }

    private static void verifyGC(HeapVerifier.Occasion occasion) {
        if (!((Boolean)SubstrateGCOptions.VerifyHeap.getValue()).booleanValue()) {
            return;
        }
        boolean success = true;
        success &= WasmHeapVerifier.verify();
        if (!(success &= WasmStackVerifier.verify())) {
            Log.log().string("Heap verification ").string(occasion.name()).string(" GC failed").newline();
            throw VMError.shouldNotReachHere((String)"Heap verification failed");
        }
    }

    private void blackenRoots() {
        this.blackenImageHeapRoots();
        this.blackenStackRoots();
    }

    private void blackenImageHeapRoots() {
        WasmHeap.getHeapImpl().walkNativeImageHeapRegions(this.blackenImageHeapRootsVisitor);
    }

    @NeverInline(value="Starts a stack walk in the caller frame")
    private void blackenStackRoots() {
        WebImageWasmStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), this.blackenStackRootsVisitor);
    }

    private void blackenCollectedHeap() {
        while (this.grayToBlackObjectVisitor.hasGray()) {
            WasmHeap.getHeapImpl().walkCollectedHeapObjects(this.grayToBlackObjectVisitor);
        }
    }

    private static void releaseSpace() {
        WasmHeap.getHeapImpl().walkCollectedHeapObjects(o -> {
            if (WasmObjectHeader.isWhiteObject(o)) {
                WasmAllocation.logicalFree((Pointer)Word.objectToUntrackedPointer((Object)o));
            } else {
                VMError.guarantee((boolean)WasmObjectHeader.isBlackObject(o), (String)"Found gray object after mark phase");
                WasmObjectHeader.markWhite(o);
            }
        });
        WasmAllocation.coalesce();
    }

    private static class CollectionVMOperation
    extends NativeVMOperation {
        CollectionVMOperation() {
            super(VMOperationInfos.get(CollectionVMOperation.class, (String)"Garbage collection", (VMOperation.SystemEffect)VMOperation.SystemEffect.SAFEPOINT));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public boolean isGC() {
            return true;
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while collecting")
        protected void operate(NativeVMOperationData data) {
            ImplicitExceptions.activateImplicitExceptionsAreFatal();
            try {
                WasmLMGC.getGC().collectOperation((CollectionVMOperationData)data);
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere((Throwable)t);
            }
            finally {
                ImplicitExceptions.deactivateImplicitExceptionsAreFatal();
            }
        }

        protected boolean hasWork(NativeVMOperationData data) {
            return true;
        }
    }

    static final class CollectionInProgressError
    extends Error {
        private static final CollectionInProgressError SINGLETON = new CollectionInProgressError();

        static void exitIf(boolean state) {
            if (state) {
                Log.log().string("[CollectionInProgressError]").newline();
                throw SINGLETON;
            }
        }

        private CollectionInProgressError() {
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> GCStressTest = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> WasmVerifyReferences = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Double> HeapGrowthFactor = new HostedOptionKey<Double>(Double.valueOf(1.8)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Double oldValue, Double newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                UserError.guarantee((newValue > 1.0 ? 1 : 0) != 0, (String)"%s must be larger than 1", (Object[])new Object[]{this.getName()});
            }
        };
        public static final HostedOptionKey<Integer> GrowthTriggerThreshold = new HostedOptionKey<Integer>(Integer.valueOf(50)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                UserError.guarantee((0 <= newValue && newValue <= 100 ? 1 : 0) != 0, (String)"%s must be in [0, 100]", (Object[])new Object[]{this.getName()});
            }
        };
    }

    @RawStructure
    private static interface CollectionVMOperationData
    extends NativeVMOperationData {
        @RawField
        public int getCauseId();

        @RawField
        public void setCauseId(int var1);

        @RawField
        public UnsignedWord getRequestingEpoch();

        @RawField
        public void setRequestingEpoch(UnsignedWord var1);

        @RawField
        public long getRequestingNanoTime();

        @RawField
        public void setRequestingNanoTime(long var1);

        @RawField
        public boolean getForceFullGC();

        @RawField
        public void setForceFullGC(boolean var1);

        @RawField
        public boolean getOutOfMemory();

        @RawField
        public void setOutOfMemory(boolean var1);
    }
}

