/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmObjectHeader;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public final class WasmLMAllocationSnippets
implements Snippets {
    @Snippet
    public static Object formatObjectSnippet(Word memory, DynamicHub hub, boolean rememberedSet, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getPureInstanceAllocationSize((int)layoutEncoding);
        Word objectHeader = WasmLMAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, false);
        return WasmLMAllocationSnippets.alloc().formatObject(objectHeader, size, memory, fillContents, emitMemoryBarrier, false, snippetCounters);
    }

    @Snippet
    public static Object formatArraySnippet(Word memory, DynamicHub hub, int length, boolean rememberedSet, boolean unaligned, AllocationSnippets.FillContent fillContents, boolean emitMemoryBarrier, @Snippet.ConstantParameter boolean supportsBulkZeroing, @Snippet.ConstantParameter boolean supportsOptimizedFilling, @Snippet.ConstantParameter AllocationSnippets.AllocationSnippetCounters snippetCounters) {
        DynamicHub hubNonNull = (DynamicHub)PiNode.piCastNonNull((Object)hub, (GuardingNode)SnippetAnchorNode.anchor());
        int layoutEncoding = hubNonNull.getLayoutEncoding();
        UnsignedWord size = LayoutEncoding.getArrayAllocationSize((int)layoutEncoding, (int)length);
        Word objectHeader = WasmLMAllocationSnippets.encodeAsObjectHeader(hubNonNull, rememberedSet, unaligned);
        return WasmLMAllocationSnippets.alloc().formatArray(objectHeader, size, length, memory, fillContents, emitMemoryBarrier, false, supportsBulkZeroing, supportsOptimizedFilling, snippetCounters);
    }

    private static Word encodeAsObjectHeader(DynamicHub hub, boolean rememberedSet, boolean unaligned) {
        return WasmObjectHeader.encodeAsObjectHeader(hub, rememberedSet, unaligned);
    }

    @Fold
    static SubstrateAllocationSnippets alloc() {
        return (SubstrateAllocationSnippets)ImageSingletons.lookup(SubstrateAllocationSnippets.class);
    }

    public static class Templates
    extends SubstrateTemplates {
        private final SubstrateAllocationSnippets.Templates baseTemplates;
        private final SnippetTemplate.SnippetInfo formatObject;
        private final SnippetTemplate.SnippetInfo formatArray;

        public Templates(OptionValues options, Providers providers, SubstrateAllocationSnippets.Templates baseTemplates) {
            super(options, providers);
            this.baseTemplates = baseTemplates;
            this.formatObject = this.snippet(providers, WasmLMAllocationSnippets.class, "formatObjectSnippet", new LocationIdentity[0]);
            this.formatArray = this.snippet(providers, WasmLMAllocationSnippets.class, "formatArraySnippet", new LocationIdentity[0]);
        }

        public void registerLowering(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
            lowerings.put(FormatObjectNode.class, new FormatObjectLowering());
            lowerings.put(FormatArrayNode.class, new FormatArrayLowering());
        }

        private final class FormatObjectLowering
        implements NodeLoweringProvider<FormatObjectNode> {
            private FormatObjectLowering() {
            }

            public void lower(FormatObjectNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatObject, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.add("snippetCounters", (Object)Templates.this.baseTemplates.getSnippetCounters());
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }

        private final class FormatArrayLowering
        implements NodeLoweringProvider<FormatArrayNode> {
            private FormatArrayLowering() {
            }

            public void lower(FormatArrayNode node, LoweringTool tool) {
                StructuredGraph graph = node.graph();
                if (graph.getGuardsStage().areFrameStatesAtSideEffects()) {
                    return;
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(Templates.this.formatArray, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("memory", (Object)node.getMemory());
                args.add("hub", (Object)node.getHub());
                args.add("length", (Object)node.getLength());
                args.add("rememberedSet", (Object)node.getRememberedSet());
                args.add("unaligned", (Object)node.getUnaligned());
                args.add("fillContents", (Object)node.getFillContents());
                args.add("emitMemoryBarrier", (Object)node.getEmitMemoryBarrier());
                args.add("supportsBulkZeroing", (Object)tool.getLowerer().supportsBulkZeroingOfEden());
                args.add("supportsOptimizedFilling", (Object)tool.getLowerer().supportsOptimizedFilling(graph.getOptions()));
                args.add("snippetCounters", (Object)Templates.this.baseTemplates.getSnippetCounters());
                Templates.this.template((CoreProviders)tool, (ValueNode)node, args).instantiate(tool.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

