/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmAllocation;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeap;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmLMGC;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmObjectHeader;
import java.lang.ref.Reference;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class WasmHeapVerifier {
    private static final ObjectVerifier OBJECT_VERIFIER = new ObjectVerifier();
    private static final ImageHeapRegionVerifier IMAGE_HEAP_OBJECT_VERIFIER = new ImageHeapRegionVerifier();
    private static final ObjectReferenceVerifier REFERENCE_VERIFIER = new ObjectReferenceVerifier();

    public static boolean verify() {
        boolean success = true;
        success &= WasmHeapVerifier.verifyImageHeapObjects();
        return success &= WasmHeapVerifier.verifyCollectedHeap();
    }

    private static boolean verifyImageHeapObjects() {
        IMAGE_HEAP_OBJECT_VERIFIER.initialize();
        ImageHeapWalker.walkRegions((ImageHeapInfo)WasmHeap.getImageHeapInfo(), (MemoryWalker.ImageHeapRegionVisitor)IMAGE_HEAP_OBJECT_VERIFIER);
        return WasmHeapVerifier.IMAGE_HEAP_OBJECT_VERIFIER.result;
    }

    private static boolean verifyCollectedHeap() {
        OBJECT_VERIFIER.initialize();
        WasmAllocation.walkObjects(OBJECT_VERIFIER);
        return WasmHeapVerifier.OBJECT_VERIFIER.result;
    }

    private static boolean verifyObject(Object obj) {
        Word ptr = Word.objectToUntrackedPointer((Object)obj);
        if (ptr.isNull()) {
            Log.log().string("Encounter a null pointer while walking the heap objects.").newline();
            return false;
        }
        int objectAlignment = ConfigurationValues.getObjectLayout().getAlignment();
        if (ptr.unsignedRemainder(objectAlignment).notEqual(0)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" is not properly aligned to ").signed(objectAlignment).string(" bytes.").newline();
            return false;
        }
        ObjectHeader oh = Heap.getHeap().getObjectHeader();
        Word header = oh.readHeaderFromPointer((Pointer)ptr);
        if (!WasmObjectHeader.isWhiteHeader((UnsignedWord)header)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" has a non-white header: ").zhex((WordBase)header).newline();
            return false;
        }
        DynamicHub hub = KnownIntrinsics.readHub((Object)obj);
        if (!Heap.getHeap().isInImageHeap((Object)hub)) {
            Log.log().string("Object ").zhex((WordBase)ptr).string(" references a hub that is not in the image heap: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)hub)).newline();
            return false;
        }
        return WasmHeapVerifier.verifyReferences(obj);
    }

    private static boolean verifyReferences(Object obj) {
        if (!((Boolean)WasmLMGC.Options.WasmVerifyReferences.getValue()).booleanValue()) {
            return true;
        }
        REFERENCE_VERIFIER.initialize();
        InteriorObjRefWalker.walkObject((Object)obj, (ObjectReferenceVisitor)REFERENCE_VERIFIER);
        boolean success = WasmHeapVerifier.REFERENCE_VERIFIER.result;
        DynamicHub hub = KnownIntrinsics.readHub((Object)obj);
        if (hub.isReferenceInstanceClass()) {
            Reference ref = (Reference)obj;
            success &= WasmHeapVerifier.verifyReferent(ref);
        }
        return success;
    }

    private static boolean verifyReferent(Reference<?> ref) {
        return WasmHeapVerifier.verifyReference(ref, ReferenceInternals.getReferentFieldAddress(ref), ReferenceInternals.getReferentPointer(ref));
    }

    public static boolean verifyReference(Object parentObject, Pointer objRef, boolean compressed) {
        Word ptr = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        return WasmHeapVerifier.verifyReference(parentObject, objRef, (Pointer)ptr);
    }

    private static boolean verifyReference(Object parentObject, Pointer objRef, Pointer referencedObject) {
        if (referencedObject.isNull()) {
            return true;
        }
        if (!WasmHeap.getHeapImpl().isInHeap(referencedObject)) {
            Log.log().string("Object reference at ").zhex((WordBase)objRef).string(" points outside the Java heap: ").zhex((WordBase)referencedObject).string(". ");
            WasmHeapVerifier.printParentObject(parentObject);
            return false;
        }
        if (!WasmObjectHeader.getObjectHeaderImpl().pointsToObjectHeader(referencedObject)) {
            Log.log().string("Object reference at ").zhex((WordBase)objRef).string(" does not point to a Java object or the object header of the Java object is invalid: ").zhex((WordBase)referencedObject).string(". ");
            WasmHeapVerifier.printParentObject(parentObject);
            return false;
        }
        return true;
    }

    private static void printParentObject(Object parentObject) {
        if (parentObject != null) {
            Log.log().string("The object that contains the invalid reference is of type ").string(parentObject.getClass().getName()).newline();
        } else {
            Log.log().string("The invalid reference is on the stack.").newline();
        }
    }

    private static class ImageHeapRegionVerifier
    extends ObjectVerifier
    implements MemoryWalker.ImageHeapRegionVisitor {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        ImageHeapRegionVerifier() {
        }

        public <T> void visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            access.visitObjects(region, (ObjectVisitor)this);
        }

        @Override
        public void visitObject(Object object) {
            Word pointer = Word.objectToUntrackedPointer((Object)object);
            if (!Heap.getHeap().isInImageHeap(object)) {
                Log.log().string("Image heap object ").zhex((WordBase)pointer).string(" is not considered as part of the image heap.").newline();
                this.result = false;
            }
            super.visitObject(object);
        }
    }

    private static class ObjectVerifier
    implements ObjectVisitor {
        protected boolean result;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ObjectVerifier() {
        }

        void initialize() {
            this.result = true;
        }

        public void visitObject(Object object) {
            this.result &= WasmHeapVerifier.verifyObject(object);
        }
    }

    static class ObjectReferenceVerifier
    implements ObjectReferenceVisitor {
        boolean result;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ObjectReferenceVerifier() {
        }

        public void initialize() {
            this.result = true;
        }

        public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
            Pointer pos = firstObjRef;
            Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
            while (pos.belowThan((UnsignedWord)end)) {
                this.visitObjectReference(pos, compressed, holderObject);
                pos = pos.add(referenceSize);
            }
        }

        private void visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
            this.result &= WasmHeapVerifier.verifyReference(holderObject, objRef, compressed);
        }
    }
}

