/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RuntimeCodeInfoGCSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmAllocation;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmLMGC;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmObjectHeader;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class WasmHeap
extends Heap {
    private final WasmObjectHeader objectHeader = new WasmObjectHeader();
    public final ImageHeapInfo imageHeapInfo = new ImageHeapInfo();
    private final WasmLMGC gc = new WasmLMGC();
    private List<Class<?>> classList;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public WasmHeap() {
    }

    @Fold
    public static WasmHeap getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof WasmHeap) : "VMConfiguration heap is not a WasmHeap. " + String.valueOf(heap);
        return (WasmHeap)heap;
    }

    public static ImageHeapInfo getImageHeapInfo() {
        return WasmHeap.getHeapImpl().imageHeapInfo;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void attachThread(IsolateThread isolateThread) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void detachThread(IsolateThread isolateThread) {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public void suspendAllocation() {
    }

    public void resumeAllocation() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || VMThreads.SafepointBehavior.ignoresSafepoints() || this.gc.isCollectionInProgress();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (WasmHeap.getHeapImpl().isAllocationDisallowed()) {
            throw NoAllocationVerifier.exit((String)callSite, (String)typeName);
        }
    }

    public WasmLMGC getGC() {
        return this.gc;
    }

    public RuntimeCodeInfoGCSupport getRuntimeCodeInfoGCSupport() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public void walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"must only be executed at a safepoint");
        this.walkImageHeapObjects(visitor);
        this.walkCollectedHeapObjects(visitor);
    }

    public void walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Must only be called at a safepoint");
        if (visitor != null) {
            ImageHeapWalker.walkImageHeapObjects((ImageHeapInfo)this.imageHeapInfo, (ObjectVisitor)visitor);
            if (AuxiliaryImageHeap.isPresent()) {
                AuxiliaryImageHeap.singleton().walkObjects(visitor);
            }
        }
    }

    public void walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint((String)"Must only be called at a safepoint");
        WasmAllocation.walkObjects(visitor);
    }

    public void walkNativeImageHeapRegions(MemoryWalker.ImageHeapRegionVisitor visitor) {
        ImageHeapWalker.walkRegions((ImageHeapInfo)this.imageHeapInfo, (MemoryWalker.ImageHeapRegionVisitor)visitor);
        if (AuxiliaryImageHeap.isPresent()) {
            AuxiliaryImageHeap.singleton().walkRegions(visitor);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getClassCount() {
        return this.imageHeapInfo.dynamicHubCount;
    }

    protected List<Class<?>> getAllClasses() {
        if (this.classList == null) {
            ArrayList list = new ArrayList(this.imageHeapInfo.dynamicHubCount);
            ImageHeapWalker.walkRegions((ImageHeapInfo)this.imageHeapInfo, (MemoryWalker.ImageHeapRegionVisitor)new ClassListBuilderVisitor(list));
            list.trimToSize();
            this.classList = list;
        }
        assert (this.classList.size() == this.imageHeapInfo.dynamicHubCount);
        return this.classList;
    }

    @Uninterruptible(reason="Necessary to return a reasonably consistent value (a GC can change the queried values).")
    public UnsignedWord getUsedBytes() {
        return Word.unsigned((long)WasmAllocation.getObjectSize());
    }

    public UnsignedWord getImageHeapReservedBytes() {
        throw VMError.shouldNotReachHere((String)"Native Memory Tracking is not supported");
    }

    public UnsignedWord getImageHeapCommittedBytes() {
        throw VMError.shouldNotReachHere((String)"Native Memory Tracking is not supported");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.objectHeader;
    }

    WasmObjectHeader getObjectHeaderImpl() {
        return this.objectHeader;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean tearDown() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.tearDown");
    }

    public void prepareForSafepoint() {
    }

    public void endSafepoint() {
    }

    public int getPreferredAddressSpaceAlignment() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.getPreferredAddressSpaceAlignment");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer getImageHeapStart() {
        return ((Word)Isolates.IMAGE_HEAP_BEGIN.get()).add(this.getImageHeapOffsetInAddressSpace());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getImageHeapOffsetInAddressSpace() {
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object obj) {
        return this.isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objPointer) {
        return this.isInPrimaryImageHeap(objPointer);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Object obj) {
        return this.isInPrimaryImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Pointer objPointer) {
        return this.imageHeapInfo.isInImageHeap(objPointer);
    }

    boolean isInHeap(Pointer ptr) {
        return this.isInImageHeap(ptr) || WasmAllocation.isObjectPointer(ptr);
    }

    public void doReferenceHandling() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.doReferenceHandling");
    }

    public boolean hasReferencePendingList() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.hasReferencePendingList");
    }

    public void waitForReferencePendingList() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.waitForReferencePendingList");
    }

    public void wakeUpReferencePendingListWaiters() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.wakeUpReferencePendingListWaiters");
    }

    public Reference<?> getAndClearReferencePendingList() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.getAndClearReferencePendingList");
    }

    public boolean printLocationInfo(Log log, UnsignedWord value, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        throw VMError.shouldNotReachHere((String)"WasmHeap.printLocationInfo");
    }

    public void optionValueChanged(RuntimeOptionKey<?> key) {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadAllocatedMemory(IsolateThread thread) {
        throw VMError.shouldNotReachHere((String)"WasmHeap.getThreadAllocatedMemory");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getUsedMemoryAfterLastGC() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.getUsedMemoryAfterLastGC");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyAllReferencesOf(Object obj) {
        throw VMError.shouldNotReachHere((String)"WasmHeap.dirtyAllReferencesOf");
    }

    public long getMillisSinceLastWholeHeapExamined() {
        throw VMError.shouldNotReachHere((String)"WasmHeap.getMillisSinceLastWholeHeapExamined");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getIdentityHashSalt(Object obj) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"identity hash codes are never computed from addresses");
        return 0L;
    }

    public boolean verifyImageHeapMapping() {
        return true;
    }

    private static final class ClassListBuilderVisitor
    implements MemoryWalker.ImageHeapRegionVisitor,
    ObjectVisitor {
        private final List<Class<?>> list;

        private ClassListBuilderVisitor(List<Class<?>> list) {
            this.list = list;
        }

        public <T> void visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (!access.isWritable(region) && !access.consistsOfHugeObjects(region)) {
                access.visitObjects(region, (ObjectVisitor)this);
            }
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Allocation is fine: this method traverses only the image heap.")
        public void visitObject(Object o) {
            if (o instanceof Class) {
                this.list.add((Class)o);
            }
        }
    }
}

