/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.gc.MemoryLayout;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmGCCause;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeap;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmLMGC;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmObjectHeader;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmTrapNode;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import com.oracle.svm.webimage.wasmgc.annotation.WasmExport;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class WasmAllocation {
    private static final OutOfMemoryError OUT_OF_MEMORY_ERROR = new OutOfMemoryError("Could not allocate memory");
    private static final UnsignedWord MASK_HEADER_BITS = Word.unsigned((int)7);
    private static final UnsignedWord MASK_IS_ALLOCATED_BIT = Word.unsigned((int)1);
    private static final UnsignedWord MASK_IS_OBJECT_BIT = Word.unsigned((int)2);
    private static final UnsignedWord CLEAR_HEADER_BITS = MASK_HEADER_BITS.not();
    private static final UnsignedWord ALIGNMENT = Word.unsigned((int)8);
    private static final UnsignedWord HEADER_SIZE = WasmAllocation.align(ALIGNMENT);
    private static final UnsignedWord MIN_INNER_SIZE = WasmAllocation.getInnerSize(FreeList.MIN_FREE_BLOCK_SIZE);

    @Fold
    public static boolean shouldVerify() {
        return (Boolean)Options.VerifyAllocations.getValue();
    }

    @Fold
    public static byte getFillByte() {
        assert (((Boolean)Options.ClearFreeMemory.getValue()).booleanValue());
        return (byte)(WasmAllocation.shouldVerify() ? 205 : 0);
    }

    @WasmExport(value="malloc", comment="Allocate unmanaged memory")
    @Platforms(value={WebImageWasmLMPlatform.class})
    public static Pointer malloc(UnsignedWord numBytes) {
        return WasmAllocation.doMalloc(numBytes);
    }

    @WasmExport(value="free", comment="Free memory allocated with malloc")
    @Platforms(value={WebImageWasmLMPlatform.class})
    public static void free(Pointer ptr) {
        WasmAllocation.doFree(ptr);
    }

    @Uninterruptible(reason="Runs while module is constructed", callerMustBe=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator not yet initialized")
    static void initialize() {
        Pointer end;
        Pointer base = MemoryLayout.getAllocatorBase();
        VMError.guarantee((base == (end = MemoryLayout.getAllocatorTop()) ? 1 : 0) != 0, (String)"Allocator must start out completely empty");
        if (WasmAllocation.growAllocatorRegion(MemoryLayout.pageSize()).isNull()) {
            WasmTrapNode.trap();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator may be in inconsistent state")
    static Pointer growAllocatorRegion(UnsignedWord numBytes) {
        Pointer top = MemoryLayout.getAllocatorTop();
        Pointer newTop = MemoryLayout.ensureAllocatorRegion((Pointer)MemoryLayout.alignToPage((UnsignedWord)top.add(numBytes)));
        if (newTop.isNull()) {
            return (Pointer)Word.nullPointer();
        }
        Pointer size = newTop.subtract((UnsignedWord)top);
        Statistics.freeSize += size.rawValue();
        WasmAllocation.writeFreeBlockHeader(top, (UnsignedWord)size);
        FreeList.add(top);
        return top;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyBlockHeader(UnsignedWord header) {
        if (WasmAllocation.shouldVerify()) {
            WasmAllocation.doVerifyBlockHeader(header);
        }
    }

    @Uninterruptible(reason="Executes interruptible code if the validation fails.", callerMustBe=true, calleeMustBe=false)
    private static void doVerifyBlockHeader(UnsignedWord header) {
        UnsignedWord size = header.and(CLEAR_HEADER_BITS);
        boolean isAllocated = header.and(MASK_IS_ALLOCATED_BIT).notEqual(0);
        VMError.guarantee((boolean)WasmAllocation.isAligned(size), (String)"Size is not aligned");
        VMError.guarantee((boolean)WasmAllocation.isAligned(WasmAllocation.getInnerSize(size)), (String)"Inner size is not aligned");
        if (size.aboveThan((UnsignedWord)MemoryLayout.getAllocatorTop().subtract((UnsignedWord)MemoryLayout.getAllocatorBase()))) {
            Log.log().string("Block size is larger than allocator region: ").hex((WordBase)size).newline();
            throw VMError.shouldNotReachHereAtRuntime();
        }
        if (size.belowThan(FreeList.MIN_FREE_BLOCK_SIZE)) {
            Log.log().string("Block size is too small: ").hex((WordBase)size).string(isAllocated ? " (allocated)" : " (free)").string(". Must be at least ").unsigned((WordBase)FreeList.MIN_FREE_BLOCK_SIZE).string("B").newline();
            throw VMError.shouldNotReachHereAtRuntime();
        }
        if (!isAllocated) {
            VMError.guarantee((boolean)header.and(MASK_IS_OBJECT_BIT).equal(0), (String)"Free block is marked as object");
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void verifyAllBlocks() {
        if (!WasmAllocation.shouldVerify()) {
            return;
        }
        FreeList.verifyFreeList();
        Pointer currentBlock = MemoryLayout.getAllocatorBase();
        long objectSize = 0L;
        long freeSize = 0L;
        while (currentBlock.belowThan((UnsignedWord)MemoryLayout.getAllocatorTop())) {
            VMError.guarantee((boolean)WasmAllocation.isAligned((UnsignedWord)currentBlock), (String)"Block is not aligned");
            BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
            WasmAllocation.readBlockHeader(currentBlock, header);
            if (header.getAllocated()) {
                if (header.getIsObject()) {
                    objectSize += header.getSize().rawValue();
                }
            } else {
                freeSize += header.getSize().rawValue();
            }
            if (!header.getAllocated() && ((Boolean)Options.ClearFreeMemory.getValue()).booleanValue()) {
                UnsignedWord offset = FreeList.POINTERS_SIZE;
                while (offset.belowThan(WasmAllocation.getInnerSize(header))) {
                    VMError.guarantee((WasmAllocation.getInnerPointer(currentBlock).readByte((WordBase)offset) == WasmAllocation.getFillByte() ? 1 : 0) != 0, (String)"Free block does not only contain fill bytes");
                    offset = offset.add(1);
                }
            }
            currentBlock = WasmAllocation.getNextBlock(currentBlock, header);
        }
        VMError.guarantee((boolean)currentBlock.equal((UnsignedWord)MemoryLayout.getAllocatorTop()), (String)"Last block does not point to allocator top");
        VMError.guarantee((objectSize == Statistics.objectSize ? 1 : 0) != 0, (String)"objectSize has wrong value in Statistics");
        VMError.guarantee((freeSize == Statistics.freeSize ? 1 : 0) != 0, (String)"freeSize has wrong value in Statistics");
    }

    @Uninterruptible(reason="Executes interruptible code.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator state must not change")
    static void printState() {
        Log.log().string("Allocator state").newline();
        Log.log().string("Free size: ").unsigned(WasmAllocation.getFreeSize()).newline();
        Log.log().string("Object size: ").unsigned(WasmAllocation.getObjectSize()).newline();
        Pointer currentBlock = MemoryLayout.getAllocatorBase();
        while (currentBlock.belowThan((UnsignedWord)MemoryLayout.getAllocatorTop())) {
            BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
            WasmAllocation.readBlockHeader(currentBlock, header);
            Log.log().hex((WordBase)currentBlock).string(" [").string(header.getAllocated() ? "alloc" : " free").string("]");
            if (header.getIsObject()) {
                int c;
                Object obj = WasmAllocation.getInnerPointer(currentBlock).toObjectNonNull();
                if (WasmObjectHeader.isWhiteObject(obj)) {
                    c = 87;
                } else if (WasmObjectHeader.isGrayObject(obj)) {
                    c = 71;
                } else if (WasmObjectHeader.isBlackObject(obj)) {
                    c = 66;
                } else {
                    throw VMError.shouldNotReachHereUnexpectedInput((Object)obj);
                }
                Log.log().string(" [").character((char)c).string("] ").object(obj);
            }
            Log.log().string(", size: ").hex((WordBase)header.getSize()).newline();
            currentBlock = WasmAllocation.getNextBlock(currentBlock, header);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getObjectSize() {
        return Statistics.objectSize;
    }

    public static long getFreeSize() {
        return Statistics.freeSize;
    }

    public static long getHeapSize() {
        return WasmAllocation.getObjectSize() + WasmAllocation.getFreeSize();
    }

    public static int getObjectPercentage() {
        return (int)(WasmAllocation.getObjectSize() * 100L / WasmAllocation.getHeapSize());
    }

    @Uninterruptible(reason="Reads allocator state")
    public static boolean isObjectPointer(Pointer ptr) {
        if (ptr.belowThan((UnsignedWord)MemoryLayout.getAllocatorBase()) || ptr.aboveOrEqual((UnsignedWord)MemoryLayout.getAllocatorTop())) {
            return false;
        }
        Pointer outer = WasmAllocation.getOuterPointer(ptr);
        BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
        WasmAllocation.readBlockHeader(outer, header);
        return header.getAllocated() && header.getIsObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends UnsignedWord> T align(T address) {
        UnsignedWord ptr = UnsignedUtils.roundUp(address, (UnsignedWord)ALIGNMENT);
        return (T)ptr;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isAligned(UnsignedWord address) {
        return UnsignedUtils.isAMultiple((UnsignedWord)address, (UnsignedWord)ALIGNMENT);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getNextBlock(Pointer blockBase, BlockHeader header) {
        return WasmAllocation.getNextBlock(blockBase, header.getSize());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getNextBlock(Pointer blockBase, UnsignedWord size) {
        return blockBase.add(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getInnerPointer(Pointer blockBase) {
        return blockBase.add(HEADER_SIZE);
    }

    @Uninterruptible(reason="Exposes allocator state", callerMustBe=true)
    private static Pointer getOuterPointer(Pointer innerPointer) {
        return innerPointer.subtract(HEADER_SIZE);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getInnerSize(BlockHeader header) {
        return header.getSize().subtract(HEADER_SIZE);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static UnsignedWord getInnerSize(UnsignedWord size) {
        return size.subtract(HEADER_SIZE);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AlwaysInline(value="Allocator Performance")
    private static void readBlockHeader(Pointer blockBase, BlockHeader returnHeader) {
        UnsignedWord header = (UnsignedWord)blockBase.readWord(0);
        WasmAllocation.verifyBlockHeader(header);
        returnHeader.setSize(header.and(CLEAR_HEADER_BITS));
        returnHeader.setAllocated(header.and(MASK_IS_ALLOCATED_BIT).notEqual(0));
        returnHeader.setIsObject(header.and(MASK_IS_OBJECT_BIT).notEqual(0));
    }

    @Uninterruptible(reason="Holds uninitialized memory.", callerMustBe=true)
    @AlwaysInline(value="Allocator performance")
    private static void writeFreeBlockHeader(Pointer blockBase, UnsignedWord size) {
        WasmAllocation.writeBlockHeader(blockBase, size, false, false);
    }

    @Uninterruptible(reason="Holds uninitialized memory", callerMustBe=true)
    @AlwaysInline(value="Allocator performance")
    private static void writeBlockHeader(Pointer blockBase, BlockHeader header) {
        WasmAllocation.writeBlockHeader(blockBase, header.getSize(), header.getAllocated(), header.getIsObject());
    }

    @Uninterruptible(reason="Holds uninitialized memory", callerMustBe=true)
    @AlwaysInline(value="Allocator performance")
    private static void writeBlockHeader(Pointer blockBase, UnsignedWord size, boolean isAllocated, boolean isObject) {
        VMError.guarantee((boolean)WasmAllocation.isAligned((UnsignedWord)blockBase));
        UnsignedWord header = size;
        if (isAllocated) {
            header = header.or(MASK_IS_ALLOCATED_BIT);
        }
        if (isObject) {
            assert (isAllocated);
            header = header.or(MASK_IS_OBJECT_BIT);
        }
        WasmAllocation.verifyBlockHeader(header);
        blockBase.writeWord(0, (WordBase)header);
        if (!isAllocated && ((Boolean)Options.ClearFreeMemory.getValue()).booleanValue()) {
            JavaMemoryUtil.fill((Pointer)WasmAllocation.getInnerPointer(blockBase).add(FreeList.POINTERS_SIZE), (UnsignedWord)WasmAllocation.getInnerSize(size).subtract(FreeList.POINTERS_SIZE), (byte)WasmAllocation.getFillByte());
        }
    }

    @Uninterruptible(reason="Modifies allocator state.", callerMustBe=true)
    private static void markFree(Pointer blockBase) {
        WasmAllocation.verifyAllBlocks();
        BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
        WasmAllocation.readBlockHeader(blockBase, header);
        VMError.guarantee((boolean)header.getAllocated(), (String)"Double free");
        Statistics.removeBlock(header);
        WasmAllocation.writeFreeBlockHeader(blockBase, header.getSize());
        FreeList.add(blockBase);
        WasmAllocation.verifyAllBlocks();
    }

    @Uninterruptible(reason="Holds uninitialized memory.", callerMustBe=true)
    private static void markAsObject(Pointer blockBase) {
        WasmAllocation.verifyAllBlocks();
        BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
        WasmAllocation.readBlockHeader(blockBase, header);
        assert (header.getAllocated());
        if (!header.getIsObject()) {
            header.setIsObject(true);
            WasmAllocation.writeBlockHeader(blockBase, header);
            Statistics.objectSize += header.getSize().rawValue();
            WasmAllocation.verifyAllBlocks();
        }
    }

    @Uninterruptible(reason="Modifies allocator state.", callerMustBe=true)
    private static void allocateInBlock(Pointer blockBase, UnsignedWord newSize) {
        BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
        WasmAllocation.readBlockHeader(blockBase, header);
        WasmAllocation.allocateInBlock(blockBase, header, newSize);
    }

    @Uninterruptible(reason="Modifies allocator state.", callerMustBe=true)
    private static void allocateInBlock(Pointer blockBase, BlockHeader header, UnsignedWord newSize) {
        UnsignedWord alignedSize = WasmAllocation.align(newSize);
        WasmAllocation.verifyAllBlocks();
        if (WasmAllocation.shouldVerify()) {
            VMError.guarantee((!header.getAllocated() ? 1 : 0) != 0, (String)"Trying to allocate in non-free block");
            VMError.guarantee((boolean)WasmAllocation.getInnerSize(header).aboveOrEqual(alignedSize), (String)"Trying to allocate in too small block");
            VMError.guarantee((boolean)newSize.aboveOrEqual(MIN_INNER_SIZE), (String)"Trying to allocate too small block");
        }
        UnsignedWord spaceFreeAfter = WasmAllocation.getInnerSize(header).subtract(alignedSize);
        if (WasmAllocation.shouldVerify()) {
            VMError.guarantee((boolean)WasmAllocation.isAligned(spaceFreeAfter), (String)"Remaining space after block is not aligned");
        }
        boolean shouldSplit = spaceFreeAfter.aboveOrEqual(FreeList.MIN_FREE_BLOCK_SIZE);
        UnsignedWord newBlockSize = header.getSize().subtract(shouldSplit ? spaceFreeAfter : (UnsignedWord)Word.zero());
        header.setSize(newBlockSize);
        header.setAllocated(true);
        FreeList.remove(blockBase);
        WasmAllocation.writeBlockHeader(blockBase, header);
        Statistics.freeSize -= newBlockSize.rawValue();
        if (shouldSplit) {
            Pointer nextBlockBase = WasmAllocation.getNextBlock(blockBase, header);
            WasmAllocation.writeFreeBlockHeader(nextBlockBase, spaceFreeAfter);
            FreeList.add(nextBlockBase);
        }
        WasmAllocation.verifyAllBlocks();
    }

    @Uninterruptible(reason="Modifies allocator state", calleeMustBe=false)
    private static Pointer growMalloc(UnsignedWord numBytes) {
        Pointer newBlockBase = WasmAllocation.growAllocatorRegion(numBytes.add(HEADER_SIZE));
        if (newBlockBase.isNull()) {
            return (Pointer)Word.nullPointer();
        }
        WasmAllocation.allocateInBlock(newBlockBase, numBytes);
        return WasmAllocation.getInnerPointer(newBlockBase);
    }

    @Uninterruptible(reason="Modifies allocator state", mayBeInlined=true)
    @AlwaysInline(value="Allocator Performance")
    private static Pointer allocateInExistingBlocks(UnsignedWord numBytes) {
        assert (numBytes.notEqual(0));
        Pointer current = FreeList.firstFree;
        while (current.isNonNull()) {
            BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
            WasmAllocation.readBlockHeader(current, header);
            assert (!header.getAllocated());
            if (WasmAllocation.getInnerSize(header).aboveOrEqual(numBytes)) {
                WasmAllocation.allocateInBlock(current, header, numBytes);
                return WasmAllocation.getInnerPointer(current);
            }
            current = FreeList.getNextFreeBlock(current);
        }
        return (Pointer)Word.nullPointer();
    }

    @Uninterruptible(reason="Modifies allocator state")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    public static Pointer doMalloc(UnsignedWord numBytes) {
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)numBytes.equal(0))) {
            return (Pointer)Word.nullPointer();
        }
        UnsignedWord paddedSize = UnsignedUtils.max((UnsignedWord)MIN_INNER_SIZE, (UnsignedWord)numBytes);
        WasmAllocation.verifyAllBlocks();
        Pointer ptr = WasmAllocation.allocateInExistingBlocks(paddedSize);
        if (ptr.isNonNull()) {
            return ptr;
        }
        WasmLMGC.getGC().collect(WasmGCCause.OnAllocation);
        ptr = WasmAllocation.allocateInExistingBlocks(paddedSize);
        if (ptr.isNonNull()) {
            return ptr;
        }
        return WasmAllocation.growMalloc(paddedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Modifies allocator state")
    public static Pointer doRealloc(Pointer innerPtr, UnsignedWord numBytes) {
        try {
            if (innerPtr.isNull()) {
                Pointer pointer = WasmAllocation.doMalloc(numBytes);
                return pointer;
            }
            if (numBytes.equal(0)) {
                Pointer pointer = (Pointer)Word.nullPointer();
                return pointer;
            }
            Pointer outerPtr = WasmAllocation.getOuterPointer(innerPtr);
            BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
            WasmAllocation.readBlockHeader(outerPtr, header);
            UnsignedWord currentSize = WasmAllocation.getInnerSize(header);
            Pointer newPtr = WasmAllocation.doMalloc(numBytes);
            UnsignedWord copiedSize = UnsignedUtils.min((UnsignedWord)currentSize, (UnsignedWord)numBytes);
            UnmanagedMemoryUtil.copy((Pointer)innerPtr, (Pointer)newPtr, (UnsignedWord)copiedSize);
            Pointer pointer = newPtr;
            return pointer;
        }
        finally {
            WasmAllocation.doFree(innerPtr);
        }
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void doFree(Pointer innerPtr) {
        if (innerPtr.isNull()) {
            return;
        }
        WasmAllocation.logicalFree(innerPtr);
        Pointer blockBase = WasmAllocation.getOuterPointer(innerPtr);
        BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
        WasmAllocation.readBlockHeader(blockBase, header);
        WasmAllocation.coalesceAt(blockBase, header);
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void logicalFree(Pointer innerPtr) {
        if (innerPtr.isNull()) {
            return;
        }
        WasmAllocation.markFree(WasmAllocation.getOuterPointer(innerPtr));
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void coalesce() {
        Pointer currentBlock = MemoryLayout.getAllocatorBase();
        Pointer minFreeBlock = MemoryLayout.getAllocatorTop();
        while (currentBlock.belowThan((UnsignedWord)MemoryLayout.getAllocatorTop())) {
            BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
            WasmAllocation.readBlockHeader(currentBlock, header);
            if (!header.getAllocated()) {
                WasmAllocation.coalesceAt(currentBlock, header);
                minFreeBlock = (Pointer)UnsignedUtils.min((UnsignedWord)minFreeBlock, (UnsignedWord)currentBlock);
            }
            currentBlock = WasmAllocation.getNextBlock(currentBlock, header);
        }
        WasmAllocation.verifyAllBlocks();
    }

    @Uninterruptible(reason="Modifies allocator state")
    public static void coalesceAt(Pointer blockBase, BlockHeader header) {
        assert (!header.getAllocated());
        UnsignedWord newSize = header.getSize();
        Pointer currentBlock = WasmAllocation.getNextBlock(blockBase, header);
        while (currentBlock.belowThan((UnsignedWord)MemoryLayout.getAllocatorTop())) {
            BlockHeader currentHeader = (BlockHeader)StackValue.get(BlockHeader.class);
            WasmAllocation.readBlockHeader(currentBlock, currentHeader);
            if (currentHeader.getAllocated()) break;
            FreeList.remove(currentBlock);
            newSize = newSize.add(currentHeader.getSize());
            currentBlock = WasmAllocation.getNextBlock(currentBlock, currentHeader);
        }
        if (newSize.aboveThan(header.getSize())) {
            header.setSize(newSize);
            WasmAllocation.writeBlockHeader(blockBase, header);
        }
    }

    public static void walkObjects(ObjectVisitor visitor) {
        Pointer currentBlock = MemoryLayout.getAllocatorBase();
        while (currentBlock.belowThan((UnsignedWord)MemoryLayout.getAllocatorTop())) {
            BlockHeader header = (BlockHeader)StackValue.get(BlockHeader.class);
            WasmAllocation.readBlockHeader(currentBlock, header);
            if (header.getIsObject()) {
                visitor.visitObject(WasmAllocation.getInnerPointer(currentBlock).toObjectNonNull());
            }
            currentBlock = WasmAllocation.getNextBlock(currentBlock, header);
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object newInstance(Word objectHeader) {
        DynamicHub hub = WasmObjectHeader.getObjectHeaderImpl().dynamicHubFromObjectHeader(objectHeader);
        return WasmAllocation.newInstanceWithoutAllocating(hub);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object newArray(Word objectHeader, int length) {
        return WasmAllocation.newArrayLikeObject(objectHeader, length);
    }

    private static Object newArrayLikeObject(Word objectHeader, int length) {
        if (length < 0) {
            throw new NegativeArraySizeException();
        }
        return WasmAllocation.newArrayLikeObject0(objectHeader, length);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object newArrayLikeObject0(Word objectHeader, int length) {
        DynamicHub hub = WasmObjectHeader.getObjectHeaderImpl().dynamicHubFromObjectHeader(objectHeader);
        WasmHeap.exitIfAllocationDisallowed("WasmAllocation.newArrayLikeObject0", DynamicHub.toClass((DynamicHub)hub).getName());
        WasmLMGC.getGC().maybeCollectOnAllocation();
        return WasmAllocation.allocateArrayLikeObject(hub, length);
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object allocateArrayLikeObject(DynamicHub hub, int length) {
        UnsignedWord size = LayoutEncoding.getArrayAllocationSize((int)hub.getLayoutEncoding(), (int)length);
        Pointer memory = WasmAllocation.allocateObject(size);
        return WasmAllocation.formatArrayLikeObject(memory, hub, length, false, AllocationSnippets.FillContent.WITH_ZEROES);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object newInstanceWithoutAllocating(DynamicHub hub) {
        WasmHeap.exitIfAllocationDisallowed("WasmAllocation.newInstanceWithoutAllocating", DynamicHub.toClass((DynamicHub)hub).getName());
        WasmLMGC.getGC().maybeCollectOnAllocation();
        return WasmAllocation.allocateInstance(hub);
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object allocateInstance(DynamicHub hub) {
        UnsignedWord size = LayoutEncoding.getPureInstanceAllocationSize((int)hub.getLayoutEncoding());
        Pointer memory = WasmAllocation.allocateObject(size);
        return FormatObjectNode.formatObject((Pointer)memory, (Class)DynamicHub.toClass((DynamicHub)hub), (boolean)false, (AllocationSnippets.FillContent)AllocationSnippets.FillContent.WITH_ZEROES, (boolean)true);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    @Uninterruptible(reason="Holds uninitialized memory")
    private static Pointer allocateObject(UnsignedWord size) {
        Pointer ptr = WasmAllocation.doMalloc(size);
        if (ptr.isNull()) {
            throw OUT_OF_MEMORY_ERROR;
        }
        WasmAllocation.markAsObject(WasmAllocation.getOuterPointer(ptr));
        return ptr;
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object formatArrayLikeObject(Pointer memory, DynamicHub hub, int length, boolean unaligned, AllocationSnippets.FillContent fillContent) {
        Class clazz = DynamicHub.toClass((DynamicHub)hub);
        return FormatArrayNode.formatArray((Pointer)memory, (Class)clazz, (int)length, (boolean)false, (boolean)unaligned, (AllocationSnippets.FillContent)fillContent, (boolean)true);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> VerifyAllocations = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> ClearFreeMemory = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return (Boolean)VerifyAllocations.getValueOrDefault(values);
                }
                return (Boolean)super.getValueOrDefault(values);
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
    }

    static class Statistics {
        static long objectSize = 0L;
        static long freeSize = 0L;

        Statistics() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void removeBlock(BlockHeader header) {
            assert (header.getAllocated());
            long size = header.getSize().rawValue();
            if (header.getIsObject()) {
                objectSize -= size;
            }
            freeSize += size;
        }
    }

    private static final class FreeList {
        private static Pointer firstFree = (Pointer)Word.nullPointer();
        private static final UnsignedWord POINTERS_SIZE = Word.unsigned((int)(2 * FrameAccess.wordSize()));
        private static final UnsignedWord MIN_FREE_BLOCK_SIZE = HEADER_SIZE.add(POINTERS_SIZE);

        private FreeList() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static Pointer getNextFreeBlock(Pointer freeBlock) {
            return (Pointer)WasmAllocation.getInnerPointer(freeBlock).readWord(0);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static Pointer getPrevFreeBlock(Pointer freeBlock) {
            return (Pointer)WasmAllocation.getInnerPointer(freeBlock).readWord(FrameAccess.wordSize());
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void setNext(Pointer freeBlock, Pointer next) {
            WasmAllocation.getInnerPointer(freeBlock).writeWord(0, (WordBase)next);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void setPrev(Pointer freeBlock, Pointer prev) {
            WasmAllocation.getInnerPointer(freeBlock).writeWord(FrameAccess.wordSize(), (WordBase)prev);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @AlwaysInline(value="Allocator Performance")
        static void remove(Pointer freeBlock) {
            Pointer prev = FreeList.getPrevFreeBlock(freeBlock);
            Pointer next = FreeList.getNextFreeBlock(freeBlock);
            if (prev.isNull()) {
                firstFree = next;
            } else {
                FreeList.setNext(prev, next);
            }
            if (next.isNonNull()) {
                FreeList.setPrev(next, prev);
            }
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        @AlwaysInline(value="Allocator Performance")
        static void add(Pointer freeBlock) {
            Pointer next = firstFree;
            FreeList.setNext(freeBlock, next);
            FreeList.setPrev(freeBlock, (Pointer)Word.nullPointer());
            if (next.isNonNull()) {
                FreeList.setPrev(next, freeBlock);
            }
            firstFree = freeBlock;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void verifyFreeList() {
            if (!WasmAllocation.shouldVerify()) {
                return;
            }
            Pointer current = firstFree;
            while (current.isNonNull()) {
                Pointer prev = FreeList.getPrevFreeBlock(current);
                Pointer next = FreeList.getNextFreeBlock(current);
                BlockHeader blockHeader = (BlockHeader)StackValue.get(BlockHeader.class);
                WasmAllocation.readBlockHeader(current, blockHeader);
                VMError.guarantee((!blockHeader.getAllocated() ? 1 : 0) != 0, (String)"Found allocated block in free list");
                if (prev.isNull()) {
                    VMError.guarantee((boolean)firstFree.equal((UnsignedWord)current), (String)"Block with null prev pointer is not the first block");
                } else {
                    VMError.guarantee((boolean)FreeList.getNextFreeBlock(prev).equal((UnsignedWord)current), (String)"Broken double link to previous block");
                }
                if (next.isNonNull()) {
                    VMError.guarantee((boolean)FreeList.getPrevFreeBlock(next).equal((UnsignedWord)current), (String)"Broken double link to next block");
                }
                current = FreeList.getNextFreeBlock(current);
            }
        }
    }

    @RawStructure
    private static interface BlockHeader
    extends PointerBase {
        @RawField
        public UnsignedWord getSize();

        @RawField
        public void setSize(UnsignedWord var1);

        @RawField
        public boolean getAllocated();

        @RawField
        public void setAllocated(boolean var1);

        @RawField
        public boolean getIsObject();

        @RawField
        public void setIsObject(boolean var1);
    }
}

