/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeap;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmLMGC;
import com.oracle.svm.webimage.platform.WebImageWasmLMPlatform;
import org.graalvm.nativeimage.Platforms;

@TargetClass(value=Runtime.class)
@Platforms(value={WebImageWasmLMPlatform.class})
final class Target_java_lang_Runtime {
    Target_java_lang_Runtime() {
    }

    @Substitute
    private long freeMemory() {
        return this.maxMemory() - WasmHeap.getHeapImpl().getUsedBytes().rawValue();
    }

    @Substitute
    private long totalMemory() {
        return this.maxMemory();
    }

    @Substitute
    private long maxMemory() {
        return 0x100000000L;
    }

    @Substitute
    private void gc() {
        WasmLMGC.getGC().collectCompletely(GCCause.JavaLangSystemGC);
    }

    @Substitute
    public int availableProcessors() {
        return 1;
    }
}

