/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;

final class SizedObjectStack {
    public final int maxSize;
    private int currentSize = 0;
    private final Word[] stack;

    SizedObjectStack(int maxSize) {
        this.maxSize = maxSize;
        this.stack = new Word[maxSize];
    }

    @AlwaysInline(value="GC performance")
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @AlwaysInline(value="GC performance")
    public boolean hasSpace() {
        return this.currentSize < this.maxSize;
    }

    @AlwaysInline(value="GC performance")
    public int size() {
        return this.currentSize;
    }

    @AlwaysInline(value="GC performance")
    public Object pop() {
        VMError.guarantee((!this.isEmpty() ? 1 : 0) != 0, (String)"Tried to pop empty stack");
        --this.currentSize;
        return this.stack[this.currentSize].toObjectNonNull();
    }

    @AlwaysInline(value="GC performance")
    public void push(Object o) {
        VMError.guarantee((boolean)this.hasSpace(), (String)"Tried to push onto full stack");
        assert (o != null);
        this.stack[this.currentSize] = Word.objectToUntrackedPointer((Object)o);
        ++this.currentSize;
    }
}

