/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmAllocation;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemoryGrowNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemorySizeNode;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class MemoryLayout {
    public static final Pointer HEAP_BASE = (Pointer)Word.pointer((long)4096L);
    public static final CGlobalData<Word> IMAGE_HEAP_SIZE = CGlobalDataFactory.forSymbol((String)"__webimage_heap_size");
    public static final CGlobalData<Word> STACK_SIZE = CGlobalDataFactory.forSymbol((String)"__webimage_stack_size");
    public static final CGlobalData<Word> HEAP_TOP = CGlobalDataFactory.forSymbol((String)"__webimage_heap_top");
    public static final CGlobalData<Word> STACK_BOTTOM = CGlobalDataFactory.forSymbol((String)"__webimage_stack_bottom");
    public static final CGlobalData<Word> STACK_BASE = CGlobalDataFactory.forSymbol((String)"__webimage_stack_base");
    public static final CGlobalData<Word> ALLOCATOR_BASE = CGlobalDataFactory.forSymbol((String)"__webimage_allocator_base");
    private static Pointer allocatorTop = (Pointer)Word.nullPointer();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static int constructLayout(EconomicMap<CGlobalData<?>, UnsignedWord> globalData, int heapSize, int stackSize) {
        Pointer heapTop = HEAP_BASE.add(heapSize);
        Pointer stackBottom = (Pointer)MemoryLayout.alignToPage((UnsignedWord)heapTop);
        Pointer stackBase = stackBottom.add(MemoryLayout.pageSize().multiply(stackSize));
        globalData.put(IMAGE_HEAP_SIZE, (Object)Word.unsigned((int)heapSize));
        globalData.put(STACK_SIZE, (Object)Word.unsigned((int)stackSize));
        globalData.put(HEAP_TOP, (Object)heapTop);
        globalData.put(STACK_BOTTOM, (Object)stackBottom);
        globalData.put(STACK_BASE, (Object)stackBase);
        globalData.put(ALLOCATOR_BASE, (Object)stackBase);
        globalData.put((Object)Isolates.IMAGE_HEAP_BEGIN, (Object)HEAP_BASE);
        globalData.put((Object)Isolates.IMAGE_HEAP_END, (Object)heapTop);
        return (int)stackBase.rawValue();
    }

    @Node.NodeIntrinsic(value=WasmMemorySizeNode.class)
    public static native int pages();

    @Node.NodeIntrinsic(value=WasmMemoryGrowNode.class)
    public static native UnsignedWord grow(UnsignedWord var0);

    @AlwaysInline(value="Is lowered to a constant")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getStackBottom() {
        return (Pointer)STACK_BOTTOM.get();
    }

    @AlwaysInline(value="Is lowered to a constant")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getStackBase() {
        return (Pointer)STACK_BASE.get();
    }

    @AlwaysInline(value="Is lowered to a constant")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getAllocatorBase() {
        return (Pointer)ALLOCATOR_BASE.get();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getAllocatorTop() {
        return allocatorTop;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    private static void setAllocatorTop(Pointer newTop) {
        assert (newTop.belowOrEqual(MemoryLayout.size())) : "Allocator top is above end of memory";
        assert (newTop.aboveOrEqual((UnsignedWord)allocatorTop)) : "Allocator top is below old top";
        assert (MemoryLayout.alignToPage((UnsignedWord)newTop).equal((UnsignedWord)newTop)) : "Allocator top is not page-aligned";
        allocatorTop = newTop;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static UnsignedWord size() {
        return MemoryLayout.pageSize().multiply(MemoryLayout.pages());
    }

    @Fold
    public static UnsignedWord pageSize() {
        return Word.unsigned((int)65536);
    }

    @Uninterruptible(reason="Runs while module is constructed", callerMustBe=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocator not yet initialized")
    public static void initialize() {
        MemoryLayout.setAllocatorTop(MemoryLayout.getAllocatorBase());
        assert (MemoryLayout.checkAlignments());
        WasmAllocation.initialize();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static boolean checkAlignments() {
        VMError.guarantee((boolean)UnsignedUtils.isAMultiple((UnsignedWord)MemoryLayout.getStackBottom(), (UnsignedWord)MemoryLayout.pageSize()));
        VMError.guarantee((boolean)UnsignedUtils.isAMultiple((UnsignedWord)MemoryLayout.getAllocatorBase(), (UnsignedWord)MemoryLayout.pageSize()));
        VMError.guarantee((boolean)UnsignedUtils.isAMultiple((UnsignedWord)allocatorTop, (UnsignedWord)MemoryLayout.pageSize()));
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static UnsignedWord alignToPage(UnsignedWord address) {
        return UnsignedUtils.roundUp((UnsignedWord)address, (UnsignedWord)MemoryLayout.pageSize());
    }

    @Uninterruptible(reason="Modifies memory size.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static boolean ensureMemorySize(UnsignedWord numBytes) {
        int currentSize = MemoryLayout.pages();
        UnsignedWord numPages = MemoryLayout.alignToPage(numBytes).unsignedDivide(MemoryLayout.pageSize());
        if (numPages.aboveThan(currentSize)) {
            return MemoryLayout.tryGrow(numPages.subtract(currentSize));
        }
        return true;
    }

    @Uninterruptible(reason="Modifies memory size.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Called during initialization")
    public static boolean tryGrow(UnsignedWord numPages) {
        if (BranchProbabilityNode.probability((double)1.0000000000287557E-6, (boolean)numPages.equal(0))) {
            return true;
        }
        UnsignedWord oldSize = MemoryLayout.grow(numPages);
        return !oldSize.equal(Word.unsigned((int)-1));
    }

    @Uninterruptible(reason="Modifies memory size.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    public static Pointer ensureAllocatorRegion(Pointer newTop) {
        Pointer alignedTop = (Pointer)MemoryLayout.alignToPage((UnsignedWord)newTop);
        if (MemoryLayout.ensureMemorySize((UnsignedWord)alignedTop)) {
            MemoryLayout.setAllocatorTop(alignedTop);
            return MemoryLayout.getAllocatorTop();
        }
        return (Pointer)Word.nullPointer();
    }
}

