/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.gc;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.hub.InteriorObjRefWalker;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.hosted.webimage.wasm.gc.SizedObjectStack;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmHeap;
import com.oracle.svm.hosted.webimage.wasm.gc.WasmObjectHeader;
import java.lang.ref.Reference;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class GrayToBlackObjectVisitor
implements ObjectVisitor {
    private int numberOfGrayObjects = 0;
    private final GrayHeapVisitor grayReferenceVisitor = new GrayHeapVisitor();
    private final SizedObjectStack worklist = new SizedObjectStack(128);

    GrayToBlackObjectVisitor() {
    }

    public boolean hasGray() {
        return this.numberOfGrayObjects > 0;
    }

    @AlwaysInline(value="GC Performance")
    private void promoteToBlack(Object o) {
        if (!WasmHeap.getHeapImpl().isInImageHeap(o)) {
            assert (WasmObjectHeader.isGrayObject(o)) : "Tried to promote a non-gray object to black";
            WasmObjectHeader.markBlack(o);
            --this.numberOfGrayObjects;
        }
    }

    @AlwaysInline(value="GC Performance")
    boolean promoteToGray(Object o) {
        assert (!WasmHeap.getHeapImpl().isInImageHeap(o)) : "Tried to promote an image heap object to gray";
        if (WasmObjectHeader.isWhiteObject(o)) {
            ++this.numberOfGrayObjects;
            WasmObjectHeader.markGray(o);
            return true;
        }
        return false;
    }

    @AlwaysInline(value="GC Performance")
    private static boolean isGray(Object o) {
        if (WasmHeap.getHeapImpl().isInImageHeap(o)) {
            return true;
        }
        return WasmObjectHeader.isGrayObject(o);
    }

    @AlwaysInline(value="GC performance")
    public void visitObject(Object o) {
        if (!GrayToBlackObjectVisitor.isGray(o)) {
            return;
        }
        assert (this.worklist.isEmpty()) : "Worklist must be empty before every visit";
        this.worklist.push(o);
        while (!this.worklist.isEmpty()) {
            Object obj = this.worklist.pop();
            assert (GrayToBlackObjectVisitor.isGray(obj)) : "Object in worklist is not gray";
            if (BranchProbabilityNode.probability((double)0.010000000000000009, (boolean)KnownIntrinsics.readHub((Object)obj).isReferenceInstanceClass())) {
                GrayToBlackObjectVisitor.discoverReference(obj, this.grayReferenceVisitor);
            }
            InteriorObjRefWalker.walkObject((Object)obj, (ObjectReferenceVisitor)this.grayReferenceVisitor);
            this.promoteToBlack(obj);
        }
    }

    @AlwaysInline(value="GC Performance")
    private static void discoverReference(Object obj, ObjectReferenceVisitor referenceVisitor) {
        Reference dr = (Reference)obj;
        Pointer referentAddr = ReferenceInternals.getReferentPointer((Reference)dr);
        if (referentAddr.isNull()) {
            return;
        }
        if (Heap.getHeap().isInImageHeap(referentAddr)) {
            return;
        }
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        referenceVisitor.visitObjectReferences(ReferenceInternals.getReferentFieldAddress((Reference)dr), false, referenceSize, (Object)dr, 1);
    }

    private final class GrayHeapVisitor
    implements ObjectReferenceVisitor {
        private GrayHeapVisitor() {
        }

        @AlwaysInline(value="GC performance")
        public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
            Pointer pos = firstObjRef;
            Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
            while (pos.belowThan((UnsignedWord)end)) {
                this.visitObjectReference(pos, compressed);
                pos = pos.add(referenceSize);
            }
        }

        public void visitObjectReference(Pointer objRef, boolean compressed) {
            assert (!objRef.isNull()) : "Tried to visit object references of null object";
            Word p = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
            if (p.isNull()) {
                return;
            }
            if (WasmHeap.getHeapImpl().isInImageHeap((Pointer)p)) {
                return;
            }
            ObjectHeader oh = Heap.getHeap().getObjectHeader();
            Word header = oh.readHeaderFromPointer((Pointer)p);
            if (!WasmObjectHeader.isWhiteHeader((UnsignedWord)header)) {
                return;
            }
            Object obj = p.toObjectNonNull();
            if (GrayToBlackObjectVisitor.this.promoteToGray(obj) && GrayToBlackObjectVisitor.this.worklist.hasSpace()) {
                GrayToBlackObjectVisitor.this.worklist.push(obj);
            }
        }
    }
}

