/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.debug;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.SystemInOutErrSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.wasm.debug.NoStackVerification;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmTrapNode;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import com.oracle.svm.webimage.wasmgc.annotation.WasmExport;
import java.io.PrintStream;
import java.util.ArrayList;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.LocationIdentity;

public class WasmDebug {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor LOG_OBJECT = SnippetRuntime.findForeignCall(WasmDebug.class, (String)"logObject", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor LOG_ERROR = SnippetRuntime.findForeignCall(WasmDebug.class, (String)"logError", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor NULL_METHOD_POINTER = SnippetRuntime.findForeignCall(WasmDebug.class, (String)"nullMethodPointer", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor READ_STACK_POINTER = SnippetRuntime.findForeignCall(WasmDebug.class, (String)"readStackPointer", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CHECK_STACK_POINTER = SnippetRuntime.findForeignCall(WasmDebug.class, (String)"checkStackPointer", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{LOG_OBJECT, LOG_ERROR, NULL_METHOD_POINTER, READ_STACK_POINTER, CHECK_STACK_POINTER};

    public static PrintStream getErrorStream() {
        return ((SystemInOutErrSupport)ImageSingletons.lookup(SystemInOutErrSupport.class)).err();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void logObject(Object o) {
        Log.log().object(o).newline();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static void logError(String err) {
        WasmDebug.getErrorStream().println(err);
        WasmTrapNode.trap();
    }

    @NeverInline(value="Force a non-floating stack pointer read")
    @NoStackVerification(value="Part of the verification instrumentation")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    public static long readStackPointer() {
        return KnownIntrinsics.readCallerStackPointer().rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void printStackTrace() {
        JSCallNode.call(JSCallNode.PRINT_STACK_TRACE);
    }

    @NeverInline(value="Accesses stack pointer of caller")
    @NoStackVerification(value="Part of the verification instrumentation")
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void checkStackPointer(long oldSP) {
        long newSP = KnownIntrinsics.readCallerStackPointer().rawValue();
        if (newSP != oldSP) {
            Log.log().string("Method's stack pointer has changed during execution, was: 0x").hex(oldSP).string(" is: 0x").hex(newSP).newline();
            throw VMError.shouldNotReachHere((String)"Stack verification failed");
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void nullMethodPointer() {
        throw VMError.shouldNotReachHere((String)"Program tried to call null method pointer.");
    }

    @WasmExport(value="debug.dumpObject", comment="Prints debug info about Java object")
    private static void dumpObject(Object o) {
        Object header;
        ArrayList<Object> extraInfo = new ArrayList<Object>();
        if (o == null) {
            header = "This object is null";
        } else {
            Class<?> clazz = o.getClass();
            header = String.valueOf(clazz) + ": ";
            try {
                extraInfo.add("toString: " + String.valueOf(o));
            }
            catch (Exception exception) {
                extraInfo.add("toString threw an exception");
            }
        }
        System.err.println((String)header);
        for (String string : extraInfo) {
            System.err.println("\t" + string);
        }
        if (o instanceof Throwable) {
            Throwable throwable = (Throwable)o;
            throwable.printStackTrace();
        }
    }
}

