/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.hosted.webimage.codegen.WebImageVariableAllocation;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmLMCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmAddressNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmIsNonZeroNode;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmSwitchPhase;
import java.util.Collection;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.variables.VariableAllocation;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class WebImageWasmVariableAllocation
extends WebImageVariableAllocation {
    @Override
    public Collection<VariableAllocation.SafetyPolicy> getSafeInliningPolicies(ValueNode node, CodeGenTool codeGenTool) {
        IntegerSwitchNode switchUsage;
        WasmLMCodeGenTool lmCodeGenTool;
        Collection<VariableAllocation.SafetyPolicy> policies = super.getSafeInliningPolicies(node, codeGenTool);
        if (codeGenTool instanceof WasmLMCodeGenTool && (lmCodeGenTool = (WasmLMCodeGenTool)codeGenTool).isSpilled(node)) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        }
        if (node instanceof ReadExceptionObjectNode) {
            policies.add(VariableAllocation.SafetyPolicy.Always);
        }
        if (node instanceof Invoke || node instanceof ForeignCall) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        }
        if ((switchUsage = (IntegerSwitchNode)node.usages().filter(IntegerSwitchNode.class).first()) != null && !WasmSwitchPhase.isSimplified(switchUsage)) {
            policies.add(VariableAllocation.SafetyPolicy.Never);
        }
        return policies;
    }

    @Override
    protected boolean shouldInline(ValueNode node, int numUsages, CodeGenTool c) {
        WasmAddressNode addressNode;
        WasmCodeGenTool codeGenTool = (WasmCodeGenTool)c;
        ResolvedJavaMethod method = codeGenTool.method;
        if (node instanceof ParameterNode) {
            ParameterNode parameterNode = (ParameterNode)node;
            if (method.hasReceiver() && parameterNode.index() == 0 && !codeGenTool.compilationResult.getParamTypes()[0].equals((Object)method.getDeclaringClass())) {
                return numUsages == 1;
            }
        }
        if (node instanceof ReadExceptionObjectNode) {
            return true;
        }
        if (node instanceof ConstantNode) {
            return true;
        }
        if (node instanceof WasmIsNonZeroNode) {
            return true;
        }
        if (node instanceof CompressionNode) {
            return true;
        }
        if (node instanceof WasmAddressNode && (addressNode = (WasmAddressNode)node).hasConstantOffset()) {
            return true;
        }
        return super.shouldInline(node, numUsages, codeGenTool);
    }
}

