/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.wasm.WasmJSCounterparts;
import com.oracle.svm.hosted.webimage.wasm.ast.id.KnownIds;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmBackend;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmLMNodeLowerer;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmNodeLowerer;
import com.oracle.svm.webimage.wasm.types.WasmLMUtil;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import java.io.PrintStream;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WebImageWasmProviders
extends WebImageProviders {
    protected final WasmIdFactory idFactory = new WasmIdFactory();
    protected final KnownIds knownIds = this.createKnownIds(this.idFactory);
    protected final WasmJSCounterparts jsCounterparts = new WasmJSCounterparts();
    protected final WasmUtil util = this.createWasmUtil(this);

    public WebImageWasmProviders(RuntimeConfiguration runtimeConfig, CoreProviders underlyingProviders, PrintStream out, DebugContext debug) {
        super(underlyingProviders, out, debug);
        this.knownIds.initializeJavaThrowableTag(this);
        runtimeConfig.getBackends().forEach(backend -> ((WebImageWasmBackend)((Object)backend)).setWasmProviders(this));
    }

    public ResolvedJavaType getReceiverType(HostedMethod hostedMethod) {
        assert (hostedMethod.hasReceiver()) : "Cannot determine receiver type for method without receiver: " + String.valueOf(hostedMethod);
        return hostedMethod.getDeclaringClass();
    }

    protected WasmUtil createWasmUtil(WebImageWasmProviders providers) {
        return new WasmLMUtil((CoreProviders)providers, ((HostedProviders)providers.getProviders()).getGraphBuilderPlugins());
    }

    public WasmIdFactory idFactory() {
        return this.idFactory;
    }

    public KnownIds knownIds() {
        return this.knownIds;
    }

    public WasmJSCounterparts getJSCounterparts() {
        return this.jsCounterparts;
    }

    public WasmUtil util() {
        return this.util;
    }

    public WebImageWasmNodeLowerer getNodeLowerer(WasmCodeGenTool codeGen) {
        return new WebImageWasmLMNodeLowerer(codeGen);
    }

    protected KnownIds createKnownIds(WasmIdFactory factory) {
        return new KnownIds(factory);
    }
}

