/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.webimage.codegen.WebImageJSNodeLowerer;
import com.oracle.svm.hosted.webimage.wasm.WasmImports;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.Literal;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmIRWalker;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmIsNonZeroNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmPopcntNode;
import com.oracle.svm.hosted.webimage.wasm.snippets.WasmImportForeignCallDescriptor;
import com.oracle.svm.webimage.wasm.WasmForeignCallDescriptor;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.calc.FloatConvert;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.NodeLowerer;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.ShortCircuitOrNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.AbsNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.CopySignNode;
import jdk.graal.compiler.nodes.calc.FloatConvertNode;
import jdk.graal.compiler.nodes.calc.FloatDivNode;
import jdk.graal.compiler.nodes.calc.FloatingIntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IntegerTestNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.MaxNode;
import jdk.graal.compiler.nodes.calc.MinMaxNode;
import jdk.graal.compiler.nodes.calc.MinNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.calc.OrNode;
import jdk.graal.compiler.nodes.calc.ReinterpretNode;
import jdk.graal.compiler.nodes.calc.RemNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.RoundNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerDivNode;
import jdk.graal.compiler.nodes.calc.SignedFloatingIntegerRemNode;
import jdk.graal.compiler.nodes.calc.SignumNode;
import jdk.graal.compiler.nodes.calc.SqrtNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.calc.XorNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.debug.BlackholeNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.GetClassNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.extended.LoadArrayComponentHubNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.ObjectIsArrayNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryLoadNode;
import jdk.graal.compiler.nodes.extended.UnsafeMemoryStoreNode;
import jdk.graal.compiler.nodes.java.AbstractUnsafeCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndAddNode;
import jdk.graal.compiler.nodes.java.AtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.NewMultiArrayNode;
import jdk.graal.compiler.nodes.java.ReachabilityFenceNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.replacements.nodes.ArrayEqualsNode;
import jdk.graal.compiler.replacements.nodes.ArrayFillNode;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.CountLeadingZerosNode;
import jdk.graal.compiler.replacements.nodes.CountTrailingZerosNode;
import jdk.graal.compiler.replacements.nodes.ObjectClone;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.graal.compiler.word.WordCastNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.VMConstant;

public abstract class WebImageWasmNodeLowerer
extends NodeLowerer {
    protected final WasmCodeGenTool masm;
    protected final WasmId.Local exceptionObjectVariable;
    protected final WasmId.Local stackPointerHolder;
    protected final WasmUtil util;
    protected static final Set<Class<?>> FORBIDDEN_NODE_TYPES = new HashSet<Class>(Arrays.asList(AbstractEndNode.class, PhiNode.class));

    protected WebImageWasmNodeLowerer(WasmCodeGenTool codeGenTool) {
        super((CodeGenTool)codeGenTool);
        this.masm = codeGenTool;
        this.exceptionObjectVariable = this.masm.idFactory.newTemporaryVariable(codeGenTool.getWasmProviders().util().getThrowableType());
        this.stackPointerHolder = this.masm.compilationResult.getGraph().getNodes().filter(WithExceptionNode.class).isEmpty() ? null : this.masm.idFactory.newTemporaryVariable(this.masm.getKnownIds().stackPointer.getVariableType());
        this.util = this.masm.wasmProviders.util();
    }

    protected WasmCodeGenTool masm() {
        return this.masm;
    }

    protected void dispatch(Node node) {
        throw GraalError.shouldNotReachHere((String)"This method cannot be used in the WASM backend.");
    }

    public Collection<Class<?>> getIgnoredNodeTypes() {
        return WebImageJSNodeLowerer.IGNORED_NODE_TYPES;
    }

    public boolean isIgnored(Node node) {
        for (Class<?> c : this.getIgnoredNodeTypes()) {
            if (!c.isInstance(node)) continue;
            return true;
        }
        return false;
    }

    protected boolean isForbiddenNode(Node node) {
        for (Class<?> c : FORBIDDEN_NODE_TYPES) {
            if (!c.isInstance(node)) continue;
            return true;
        }
        return false;
    }

    public NodeIterable<Node> actualUsages(ValueNode node) {
        return this.util.actualUsages(node);
    }

    public boolean isActiveValueNode(ValueNode node) {
        return this.util.hasValue((Node)node) && this.actualUsageCount((Node)node) > 0;
    }

    public boolean isTopLevelStatement(Node node) {
        if (this.isIgnored(node)) {
            return false;
        }
        if (this.masm.declared(node)) {
            return true;
        }
        return !this.util.hasValue(node);
    }

    public String nodeDebugInfo(Node node) {
        Object object;
        boolean isValueNode = node instanceof ValueNode;
        String string = String.valueOf(node);
        String string2 = String.valueOf(node.usages());
        boolean bl = isValueNode && !this.masm.getVariableAllocation().needsVariable((ValueNode)node, (CodeGenTool)this.masm);
        Object object2 = isValueNode ? ", safe inlining = " + String.valueOf(this.masm.getVariableAllocation().getSafeInliningPolicies((ValueNode)node, (CodeGenTool)this.masm)) : "";
        if (node instanceof FixedWithNextNode) {
            FixedWithNextNode fixed = (FixedWithNextNode)node;
            object = ", next = " + String.valueOf(fixed.next());
        } else {
            object = "";
        }
        return string + ", " + string2 + ", inlineable = " + bl + (String)object2 + (String)object + (String)(node instanceof ControlSplitNode ? ", " + String.valueOf(node.successors()) : "");
    }

    protected String reportForbiddenNode(Node node) {
        return this.nodeDebugInfo(node);
    }

    public void lowerStatement(Node n) {
        if (this.masm.declared(n)) {
            ValueNode valueNode = (ValueNode)n;
            Instruction value = this.dispatch(valueNode, WasmIRWalker.Requirements.defaults());
            ResolvedVar variable = this.lowerVariableStore(valueNode, value);
            variable.setDefinitionLowered();
        } else {
            Instruction stmt = this.lowerTopLevelStatement(n, WasmIRWalker.Requirements.defaults());
            if (stmt == null) {
                if (WebImageWasmOptions.genComments()) {
                    this.masm.genInst((Instruction)new Instruction.Nop(), n);
                }
            } else {
                this.masm.genInst(stmt, n);
            }
        }
    }

    public ResolvedVar lowerVariableStore(ValueNode n, Instruction value) {
        assert (this.masm.declared((Node)n)) : n;
        assert (this.util.hasValue((Node)n)) : n;
        ResolvedVar variable = this.masm.getAllocatedVariable(n);
        WasmValType type = this.util.typeForNode(n);
        WebImageWasmIds.NodeVariable local = this.masm.idFactory.forVariable(variable, type);
        this.masm.genInst((Instruction)local.setter(value), (Node)n);
        return variable;
    }

    protected abstract Instruction lowerTopLevelStatement(Node var1, WasmIRWalker.Requirements var2);

    protected abstract Instruction lowerReturn(ReturnNode var1);

    protected Instruction lowerReachabilityFence(ReachabilityFenceNode n) {
        ArrayList<Instruction> values = new ArrayList<Instruction>(n.getValues().count());
        for (ValueNode value : n.getValues()) {
            Instruction inst = this.lowerDrop(value);
            if (inst == null) continue;
            values.add(inst);
        }
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return (Instruction)values.get(0);
        }
        Instruction.Block block = new Instruction.Block(null);
        block.instructions.addAll(values);
        return block;
    }

    protected Instruction lowerDrop(ValueNode value) {
        if (value instanceof FloatingNode) {
            return null;
        }
        return new Instruction.Drop(this.lowerExpression(value, WasmIRWalker.Requirements.valueIgnored()));
    }

    protected static Instruction lowerAssert(AssertionNode n) {
        n.generate(null);
        return null;
    }

    protected Instruction lowerExpression(ValueNode n) {
        return this.lowerExpression(n, WasmIRWalker.Requirements.defaults());
    }

    protected Instruction lowerExpression(ValueNode n, WasmIRWalker.Requirements reqs) {
        Instruction inst;
        Objects.requireNonNull(n, "Tried to lower null Node");
        ResolvedVar variable = this.masm.variableMap.getVarByNode(n);
        if (variable != null) {
            assert (variable.isDefinitionLowered()) : "Variable not yet defined: " + String.valueOf(variable);
            inst = this.masm.idFactory.forVariable(variable, this.util.typeForNode(n)).getter();
        } else {
            inst = this.dispatch(n, reqs);
        }
        if (inst.getComment() == null) {
            inst.setComment(this.masm.getNodeComment((Node)n));
        }
        return inst;
    }

    protected abstract Instruction dispatch(ValueNode var1, WasmIRWalker.Requirements var2);

    protected Instruction lowerParam(ParameterNode param) {
        return this.masm.compilationResult.getFunction().getParam(param.index()).getter();
    }

    protected Instruction getStub(Node n) {
        Instruction inst = null;
        if (n instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)n;
            inst = this.getValueStub(valueNode);
        }
        if (inst == null) {
            inst = new Instruction.Nop();
        }
        inst.setComment("unreachable: " + String.valueOf(n));
        return inst;
    }

    protected Instruction getValueStub(ValueNode node) {
        JavaKind wasmKind = this.util.kindForNode(node);
        if (wasmKind == JavaKind.Void) {
            return null;
        }
        Literal literal = Literal.forConstant((PrimitiveConstant)JavaConstant.defaultForKind((JavaKind)wasmKind));
        return new Instruction.Const(literal);
    }

    protected Instruction lowerConstant(ConstantNode n) {
        return this.lowerConstant(n.getValue());
    }

    protected Instruction lowerConstant(Constant constant) {
        if (constant instanceof PrimitiveConstant) {
            return Instruction.Const.forConstant((PrimitiveConstant)constant);
        }
        if (JavaConstant.isNull((Constant)constant)) {
            return Instruction.Const.forInt(0);
        }
        if (constant instanceof SubstrateMethodPointerConstant) {
            SubstrateMethodPointerConstant pointerConstant = (SubstrateMethodPointerConstant)constant;
            return this.masm.getRelocation((Reference)new ConstantReference((VMConstant)pointerConstant));
        }
        if (constant instanceof VMConstant && constant instanceof JavaConstant) {
            return this.masm.getConstantRelocation((JavaConstant)constant);
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)constant);
    }

    protected Instruction lowerCompression(CompressionNode compression, WasmIRWalker.Requirements reqs) {
        assert (!compression.getEncoding().hasBase()) : compression.getEncoding();
        assert (!compression.getEncoding().hasShift()) : compression.getEncoding();
        return this.lowerExpression(compression.getValue(), reqs);
    }

    protected Instruction lowerSubstrateForeignCall(SnippetRuntime.SubstrateForeignCallDescriptor descriptor, Instruction ... args) {
        return this.lowerSubstrateForeignCall(descriptor, Instructions.asInstructions(args));
    }

    protected Instruction lowerSubstrateForeignCall(SnippetRuntime.SubstrateForeignCallDescriptor descriptor, Instructions args) {
        ResolvedJavaMethod method = descriptor.findMethod(this.masm.getProviders().getMetaAccess());
        return this.masm.getCall((InvokeTarget)method, true, new Instruction.Call((WasmId.Func)this.masm.idFactory.forMethod(method), args));
    }

    protected abstract Instruction lowerWasmImportForeignCall(WasmImportForeignCallDescriptor var1, Instructions var2);

    protected Instruction lowerWasmForeignCall(WasmForeignCallDescriptor descriptor, Instructions args) {
        throw GraalError.unimplemented((String)("Unsupported WasmForeignCallDescriptor: " + String.valueOf((Object)descriptor)));
    }

    protected Instruction lowerForeignCall(ForeignCall n) {
        ForeignCallDescriptor descriptor;
        Instructions args = new Instructions();
        n.getArguments().forEach(arg -> args.add(this.lowerExpression((ValueNode)arg)));
        ForeignCallDescriptor foreignCallDescriptor = descriptor = n.getDescriptor();
        Objects.requireNonNull(foreignCallDescriptor);
        ForeignCallDescriptor foreignCallDescriptor2 = foreignCallDescriptor;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SnippetRuntime.SubstrateForeignCallDescriptor.class, WasmImportForeignCallDescriptor.class, WasmForeignCallDescriptor.class}, (Object)foreignCallDescriptor2, n2)) {
            case 0 -> {
                SnippetRuntime.SubstrateForeignCallDescriptor substrateDescriptor = (SnippetRuntime.SubstrateForeignCallDescriptor)foreignCallDescriptor2;
                yield this.lowerSubstrateForeignCall(substrateDescriptor, args);
            }
            case 1 -> {
                WasmImportForeignCallDescriptor wasmImportForeignCallDescriptor = (WasmImportForeignCallDescriptor)foreignCallDescriptor2;
                yield this.lowerWasmImportForeignCall(wasmImportForeignCallDescriptor, args);
            }
            case 2 -> {
                WasmForeignCallDescriptor wasmForeignCallDescriptor = (WasmForeignCallDescriptor)foreignCallDescriptor2;
                yield this.lowerWasmForeignCall(wasmForeignCallDescriptor, args);
            }
            default -> throw VMError.shouldNotReachHereUnexpectedInput((Object)descriptor);
        };
    }

    protected Instruction lowerDivRem(IntegerDivRemNode n) {
        return WebImageWasmNodeLowerer.getDivRemOp(n).create(this.lowerExpression(n.getX()), this.lowerExpression(n.getY()));
    }

    private static Instruction.Binary.Op getDivRemOp(IntegerDivRemNode n) {
        JavaKind kind = n.getStackKind();
        assert (n.getX().getStackKind() == n.getY().getStackKind()) : String.valueOf(n.getX().getStackKind()) + " != " + String.valueOf(n.getY().getStackKind());
        assert (kind == n.getX().getStackKind()) : String.valueOf(kind) + " != " + String.valueOf(n.getX().getStackKind());
        WasmPrimitiveType type = WasmUtil.mapPrimitiveType(kind);
        assert (type.isInt()) : type;
        boolean isI32 = type == WasmPrimitiveType.i32;
        IntegerDivRemNode.Op op = n.getOp();
        IntegerDivRemNode.Type signed = n.getType();
        if (op == IntegerDivRemNode.Op.DIV && signed == IntegerDivRemNode.Type.SIGNED) {
            return isI32 ? Instruction.Binary.Op.I32DivS : Instruction.Binary.Op.I64DivS;
        }
        if (op == IntegerDivRemNode.Op.DIV && signed == IntegerDivRemNode.Type.UNSIGNED) {
            return isI32 ? Instruction.Binary.Op.I32DivU : Instruction.Binary.Op.I64DivU;
        }
        if (op == IntegerDivRemNode.Op.REM && signed == IntegerDivRemNode.Type.SIGNED) {
            return isI32 ? Instruction.Binary.Op.I32RemS : Instruction.Binary.Op.I64RemS;
        }
        if (op == IntegerDivRemNode.Op.REM && signed == IntegerDivRemNode.Type.UNSIGNED) {
            return isI32 ? Instruction.Binary.Op.I32RemU : Instruction.Binary.Op.I64RemU;
        }
        throw GraalError.unimplemented((String)("IntegerDivRem, op: " + String.valueOf(op) + ", type: " + String.valueOf(type)));
    }

    protected Instruction lowerLogicNode(LogicNode n, WasmIRWalker.Requirements reqs) {
        if (n instanceof IntegerTestNode) {
            IntegerTestNode integerTest = (IntegerTestNode)n;
            return this.lowerIntegerTest(integerTest);
        }
        if (n instanceof CompareNode) {
            CompareNode compare = (CompareNode)n;
            return this.lowerCompareNode(compare);
        }
        if (n instanceof IsNullNode) {
            IsNullNode isNull = (IsNullNode)n;
            return this.lowerIsNull(isNull);
        }
        if (n instanceof WasmIsNonZeroNode) {
            WasmIsNonZeroNode isNonZero = (WasmIsNonZeroNode)n;
            return this.lowerIsNonZero(isNonZero, reqs);
        }
        throw GraalError.unimplemented((String)n.toString());
    }

    protected abstract Instruction lowerIsNull(IsNullNode var1);

    private Instruction lowerIsNonZero(WasmIsNonZeroNode n, WasmIRWalker.Requirements reqs) {
        ValueNode value = n.getValue();
        assert (this.util.mapType(value.getStackKind()) == WasmPrimitiveType.i32) : value.getStackKind();
        if (reqs.hasStrictLogic()) {
            return Instruction.Binary.Op.I32Ne.create(this.lowerExpression(value), Instruction.Const.forInt(0));
        }
        return this.lowerExpression(value, reqs);
    }

    private Instruction lowerIntegerTest(IntegerTestNode n) {
        JavaKind kind = n.getX().getStackKind();
        assert (kind == n.getY().getStackKind()) : String.valueOf(kind) + " != " + String.valueOf(n.getY().getStackKind());
        assert (kind.isNumericInteger()) : kind;
        Instruction.Unary.Op eqzOp = kind == JavaKind.Int ? Instruction.Unary.Op.I32Eqz : Instruction.Unary.Op.I64Eqz;
        Instruction.Binary.Op andOp = kind == JavaKind.Int ? Instruction.Binary.Op.I32And : Instruction.Binary.Op.I64And;
        return eqzOp.create(andOp.create(this.lowerExpression(n.getX()), this.lowerExpression(n.getY())));
    }

    protected Instruction lowerUnary(UnaryNode node) {
        assert (node.getStackKind().isPrimitive() && node.getValue().getStackKind().isPrimitive()) : "This method can only deal with primitive UnaryNodes";
        WasmPrimitiveType type = this.util.mapType(node.getStackKind()).asPrimitive();
        WasmPrimitiveType fromType = this.util.mapType(node.getValue().getStackKind()).asPrimitive();
        if (node instanceof UnaryMathIntrinsicNode) {
            UnaryMathIntrinsicNode unaryMathIntrinsic = (UnaryMathIntrinsicNode)node;
            return this.lowerUnaryMathIntrinsic(unaryMathIntrinsic);
        }
        if (node instanceof NotNode) {
            Instruction.Binary.Op xorOp;
            assert (type.isInt()) : type;
            return xorOp.create(this.lowerExpression(node.getValue()), switch (type) {
                case WasmPrimitiveType.i32 -> {
                    xorOp = Instruction.Binary.Op.I32Xor;
                    yield Instruction.Const.forInt(-1);
                }
                case WasmPrimitiveType.i64 -> {
                    xorOp = Instruction.Binary.Op.I64Xor;
                    yield Instruction.Const.forLong(-1L);
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)type);
            });
        }
        if (node instanceof NegateNode && type.isInt()) {
            Instruction.Binary.Op subOp;
            return subOp.create(switch (type) {
                case WasmPrimitiveType.i32 -> {
                    subOp = Instruction.Binary.Op.I32Sub;
                    yield Instruction.Const.forInt(0);
                }
                case WasmPrimitiveType.i64 -> {
                    subOp = Instruction.Binary.Op.I64Sub;
                    yield Instruction.Const.forLong(0L);
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)type);
            }, this.lowerExpression(node.getValue()));
        }
        if (node instanceof NarrowNode) {
            NarrowNode narrow = (NarrowNode)node;
            assert (type.isInt()) : type;
            int inputBits = narrow.getInputBits();
            int resultBits = narrow.getResultBits();
            Instruction input = this.lowerExpression(node.getValue());
            if (inputBits > 32) {
                assert (resultBits <= 32) : resultBits;
                Instruction.Unary wrap = Instruction.Unary.Op.I32Wrap64.create(input);
                if (resultBits == 32) {
                    return wrap;
                }
                return Instruction.Binary.Op.I32And.create(wrap, Instruction.Const.forInt((int)CodeUtil.mask((int)resultBits)));
            }
            assert (resultBits < 32) : resultBits;
            return Instruction.Binary.Op.I32And.create(input, Instruction.Const.forInt((int)CodeUtil.mask((int)resultBits)));
        }
        if (node instanceof SignExtendNode) {
            SignExtendNode signExtend = (SignExtendNode)node;
            assert (type.isInt()) : type;
            int inputBits = signExtend.getInputBits();
            int resultBits = signExtend.getResultBits();
            Instruction input = this.lowerExpression(node.getValue());
            if (inputBits == 1) {
                if (type == WasmPrimitiveType.i32) {
                    return new Instruction.Select(Instruction.Const.forInt(-1), Instruction.Const.forInt(0), input, WasmPrimitiveType.i32);
                }
                return new Instruction.Select(Instruction.Const.forLong(-1L), Instruction.Const.forLong(0L), input, WasmPrimitiveType.i64);
            }
            Instruction i32Input = input;
            assert (inputBits <= 32) : inputBits;
            if (inputBits < 32) {
                i32Input = switch (inputBits) {
                    case 8 -> Instruction.Unary.Op.I32Extend8.create(input);
                    case 16 -> Instruction.Unary.Op.I32Extend16.create(input);
                    default -> throw GraalError.unimplemented((String)("Sign extend from " + inputBits + "bit to " + resultBits + "bit"));
                };
            }
            if (resultBits > 32) {
                assert (resultBits == 64) : resultBits;
                return Instruction.Unary.Op.I64ExtendI32S.create(i32Input);
            }
            return i32Input;
        }
        if (node instanceof CountLeadingZerosNode && fromType == WasmPrimitiveType.i64) {
            return Instruction.Unary.Op.I32Wrap64.create(Instruction.Unary.Op.I64Clz.create(this.lowerExpression(node.getValue())));
        }
        if (node instanceof CountTrailingZerosNode && fromType == WasmPrimitiveType.i64) {
            return Instruction.Unary.Op.I32Wrap64.create(Instruction.Unary.Op.I64Ctz.create(this.lowerExpression(node.getValue())));
        }
        Instruction.Unary.Op op = WebImageWasmNodeLowerer.getUnaryOp(node);
        if (op == Instruction.Unary.Op.Nop) {
            return this.lowerExpression(node.getValue());
        }
        return op.create(this.lowerExpression(node.getValue()));
    }

    private static Instruction.Unary.Op getUnaryOp(UnaryNode node) {
        WasmPrimitiveType type = WasmUtil.mapPrimitiveType(node.getStackKind());
        WasmPrimitiveType fromType = WasmUtil.mapPrimitiveType(node.getValue().getStackKind());
        if (node instanceof NegateNode) {
            assert (type.isFloat()) : type;
            return type == WasmPrimitiveType.f32 ? Instruction.Unary.Op.F32Neg : Instruction.Unary.Op.F64Neg;
        }
        if (node instanceof AbsNode) {
            assert (type.isFloat()) : type;
            return type == WasmPrimitiveType.f32 ? Instruction.Unary.Op.F32Abs : Instruction.Unary.Op.F64Abs;
        }
        if (node instanceof SqrtNode) {
            assert (type.isFloat()) : type;
            return type == WasmPrimitiveType.f32 ? Instruction.Unary.Op.F32Sqrt : Instruction.Unary.Op.F64Sqrt;
        }
        if (node instanceof ZeroExtendNode) {
            ZeroExtendNode zeroExtend = (ZeroExtendNode)node;
            assert (type.isInt()) : type;
            boolean outIsI32 = type == WasmPrimitiveType.i32;
            int inputBits = zeroExtend.getInputBits();
            int resultBits = zeroExtend.getResultBits();
            if (outIsI32) {
                assert (inputBits < 32) : inputBits;
                assert (resultBits <= 32) : resultBits;
                return Instruction.Unary.Op.Nop;
            }
            assert (inputBits <= 32) : inputBits;
            assert (resultBits == 64) : resultBits;
            return Instruction.Unary.Op.I64ExtendI32U;
        }
        if (node instanceof RoundNode) {
            RoundNode round = (RoundNode)node;
            assert (type.isFloat()) : type;
            boolean isF32 = type == WasmPrimitiveType.f32;
            ArithmeticLIRGeneratorTool.RoundingMode mode = round.mode();
            return switch (mode) {
                default -> throw new MatchException(null, null);
                case ArithmeticLIRGeneratorTool.RoundingMode.NEAREST -> {
                    if (isF32) {
                        yield Instruction.Unary.Op.F32Nearest;
                    }
                    yield Instruction.Unary.Op.F64Nearest;
                }
                case ArithmeticLIRGeneratorTool.RoundingMode.DOWN -> {
                    if (isF32) {
                        yield Instruction.Unary.Op.F32Floor;
                    }
                    yield Instruction.Unary.Op.F64Floor;
                }
                case ArithmeticLIRGeneratorTool.RoundingMode.UP -> {
                    if (isF32) {
                        yield Instruction.Unary.Op.F32Ceil;
                    }
                    yield Instruction.Unary.Op.F64Ceil;
                }
                case ArithmeticLIRGeneratorTool.RoundingMode.TRUNCATE -> isF32 ? Instruction.Unary.Op.F32Trunc : Instruction.Unary.Op.F64Trunc;
            };
        }
        if (node instanceof WasmPopcntNode) {
            assert (type.isInt()) : type;
            return type == WasmPrimitiveType.i32 ? Instruction.Unary.Op.I32Popcnt : Instruction.Unary.Op.I64Popcnt;
        }
        if (node instanceof FloatConvertNode) {
            FloatConvertNode floatConvert = (FloatConvertNode)node;
            JavaKind inputKind = floatConvert.getValue().getStackKind();
            return switch (floatConvert.getFloatConvert()) {
                case FloatConvert.F2I -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Float) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.i32) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.I32TruncSatF32S;
                }
                case FloatConvert.D2I -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Double) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.i32) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.I32TruncSatF64S;
                }
                case FloatConvert.F2L -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Float) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.i64) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.I64TruncSatF32S;
                }
                case FloatConvert.D2L -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Double) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.i64) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.I64TruncSatF64S;
                }
                case FloatConvert.I2F -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Int) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.f32) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.F32ConvertI32S;
                }
                case FloatConvert.L2F -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Long) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.f32) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.F32ConvertI64S;
                }
                case FloatConvert.D2F -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Double) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.f32) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.F32Demote64;
                }
                case FloatConvert.I2D -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Int) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.f64) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.F64ConvertI32S;
                }
                case FloatConvert.L2D -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Long) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.f64) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.F64ConvertI64S;
                }
                case FloatConvert.F2D -> {
                    if (!$assertionsDisabled && inputKind != JavaKind.Float) {
                        throw new AssertionError(inputKind);
                    }
                    if (!$assertionsDisabled && type != WasmPrimitiveType.f64) {
                        throw new AssertionError(type);
                    }
                    yield Instruction.Unary.Op.F64Promote32;
                }
                default -> throw GraalError.unimplemented((String)("FloatConvertNode, op: " + String.valueOf(floatConvert.getFloatConvert())));
            };
        }
        if (node instanceof ReinterpretNode) {
            assert (node.getStackKind().getBitCount() == node.getValue().getStackKind().getBitCount()) : node.getStackKind().getBitCount() + " != " + node.getValue().getStackKind().getBitCount();
            if (fromType == WasmPrimitiveType.f32 && type == WasmPrimitiveType.i32) {
                return Instruction.Unary.Op.I32ReinterpretF32;
            }
            if (fromType == WasmPrimitiveType.f64 && type == WasmPrimitiveType.i64) {
                return Instruction.Unary.Op.I64ReinterpretF64;
            }
            if (fromType == WasmPrimitiveType.i32 && type == WasmPrimitiveType.f32) {
                return Instruction.Unary.Op.F32ReinterpretI32;
            }
            if (fromType == WasmPrimitiveType.i64 && type == WasmPrimitiveType.f64) {
                return Instruction.Unary.Op.F64ReinterpretI64;
            }
            throw GraalError.unimplemented((String)("ReinterpretNode from " + String.valueOf(fromType) + " to " + String.valueOf(type)));
        }
        if (node instanceof CountLeadingZerosNode) {
            assert (type == WasmPrimitiveType.i32) : type;
            assert (fromType == WasmPrimitiveType.i32) : fromType;
            return Instruction.Unary.Op.I32Clz;
        }
        if (node instanceof CountTrailingZerosNode) {
            assert (type == WasmPrimitiveType.i32) : type;
            assert (fromType == WasmPrimitiveType.i32) : fromType;
            return Instruction.Unary.Op.I32Ctz;
        }
        throw GraalError.unimplemented((String)("Unary node: " + String.valueOf(node)));
    }

    private Instruction lowerUnaryMathIntrinsic(UnaryMathIntrinsicNode node) {
        assert (node.getStackKind() == JavaKind.Double) : node.getStackKind();
        ImportDescriptor.Function imported = switch (node.getOperation()) {
            default -> throw new MatchException(null, null);
            case UnaryMathIntrinsicNode.UnaryOperation.LOG -> WasmImports.F64Log;
            case UnaryMathIntrinsicNode.UnaryOperation.LOG10 -> WasmImports.F64Log10;
            case UnaryMathIntrinsicNode.UnaryOperation.SIN -> WasmImports.F64Sin;
            case UnaryMathIntrinsicNode.UnaryOperation.COS -> WasmImports.F64Cos;
            case UnaryMathIntrinsicNode.UnaryOperation.TAN -> WasmImports.F64Tan;
            case UnaryMathIntrinsicNode.UnaryOperation.TANH -> WasmImports.F64Tanh;
            case UnaryMathIntrinsicNode.UnaryOperation.EXP -> WasmImports.F64Exp;
            case UnaryMathIntrinsicNode.UnaryOperation.CBRT -> WasmImports.F64Cbrt;
        };
        return new Instruction.Call((WasmId.Func)this.masm.idFactory.forFunctionImport(imported), this.lowerExpression(node.getValue()));
    }

    protected Instruction lowerConditional(ConditionalNode n) {
        ValueNode trueValue = n.trueValue();
        ValueNode falseValue = n.falseValue();
        assert (trueValue.getStackKind() == falseValue.getStackKind()) : n;
        assert (n.getStackKind() == trueValue.getStackKind()) : n;
        if (n.getStackKind() == JavaKind.Int) {
            PrimitiveConstant trueConstant = (PrimitiveConstant)trueValue.stamp(NodeView.DEFAULT).asConstant();
            PrimitiveConstant falseConstant = (PrimitiveConstant)falseValue.stamp(NodeView.DEFAULT).asConstant();
            if (trueConstant != null && falseConstant != null && trueConstant.asInt() == 1 && falseConstant.asInt() == 0) {
                return this.lowerExpression((ValueNode)n.condition());
            }
        }
        return new Instruction.Select(this.lowerExpression(trueValue), this.lowerExpression(falseValue), this.lowerExpression((ValueNode)n.condition(), WasmIRWalker.Requirements.defaults().setStrictLogic(false)), this.util.mapType(n.getStackKind()));
    }

    protected Instruction lowerBinary(BinaryNode node) {
        if (node instanceof RemNode) {
            WasmPrimitiveType type = WasmUtil.mapPrimitiveType(node.getStackKind());
            assert (type.isFloat()) : type;
            ImportDescriptor.Function func = type == WasmPrimitiveType.f32 ? WasmImports.F32Rem : WasmImports.F64Rem;
            return new Instruction.Call((WasmId.Func)this.masm.idFactory.forFunctionImport(func), this.lowerExpression(node.getX()), this.lowerExpression(node.getY()));
        }
        if (node instanceof BinaryMathIntrinsicNode) {
            BinaryMathIntrinsicNode binaryMathIntrinsic = (BinaryMathIntrinsicNode)node;
            return this.lowerBinaryMathIntrinsic(binaryMathIntrinsic);
        }
        Instruction.Binary.Op op = WebImageWasmNodeLowerer.getBinaryOp(node);
        assert (op != null);
        Instruction opY = this.lowerExpression(node.getY());
        if (node instanceof ShiftNode && node.getStackKind() == JavaKind.Long) {
            if (opY instanceof Instruction.Const) {
                Instruction.Const constant = (Instruction.Const)opY;
                Literal literal = constant.literal;
                assert (literal.type == WasmPrimitiveType.i32) : literal;
                opY = Instruction.Const.forLong(literal.getI32());
            } else {
                opY = Instruction.Unary.Op.I64ExtendI32S.create(opY);
            }
        }
        return op.create(this.lowerExpression(node.getX()), opY);
    }

    private static Instruction.Binary.Op getBinaryOp(BinaryNode node) {
        WasmPrimitiveType type = WasmUtil.mapPrimitiveType(node.getStackKind());
        if (node instanceof AndNode) {
            assert (type.isInt()) : type;
            return type == WasmPrimitiveType.i32 ? Instruction.Binary.Op.I32And : Instruction.Binary.Op.I64And;
        }
        if (node instanceof OrNode) {
            assert (type.isInt()) : type;
            return type == WasmPrimitiveType.i32 ? Instruction.Binary.Op.I32Or : Instruction.Binary.Op.I64Or;
        }
        if (node instanceof XorNode) {
            assert (type.isInt()) : type;
            return type == WasmPrimitiveType.i32 ? Instruction.Binary.Op.I32Xor : Instruction.Binary.Op.I64Xor;
        }
        if (node instanceof AddNode) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case WasmPrimitiveType.i32 -> Instruction.Binary.Op.I32Add;
                case WasmPrimitiveType.i64 -> Instruction.Binary.Op.I64Add;
                case WasmPrimitiveType.f32 -> Instruction.Binary.Op.F32Add;
                case WasmPrimitiveType.f64 -> Instruction.Binary.Op.F64Add;
            };
        }
        if (node instanceof SubNode) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case WasmPrimitiveType.i32 -> Instruction.Binary.Op.I32Sub;
                case WasmPrimitiveType.i64 -> Instruction.Binary.Op.I64Sub;
                case WasmPrimitiveType.f32 -> Instruction.Binary.Op.F32Sub;
                case WasmPrimitiveType.f64 -> Instruction.Binary.Op.F64Sub;
            };
        }
        if (node instanceof MulNode) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case WasmPrimitiveType.i32 -> Instruction.Binary.Op.I32Mul;
                case WasmPrimitiveType.i64 -> Instruction.Binary.Op.I64Mul;
                case WasmPrimitiveType.f32 -> Instruction.Binary.Op.F32Mul;
                case WasmPrimitiveType.f64 -> Instruction.Binary.Op.F64Mul;
            };
        }
        if (node instanceof FloatDivNode) {
            assert (type.isFloat()) : type;
            return type == WasmPrimitiveType.f32 ? Instruction.Binary.Op.F32Div : Instruction.Binary.Op.F64Div;
        }
        if (node instanceof ShiftNode) {
            boolean isInt32;
            assert (type.isInt()) : type;
            boolean bl = isInt32 = type == WasmPrimitiveType.i32;
            if (node instanceof LeftShiftNode) {
                return isInt32 ? Instruction.Binary.Op.I32Shl : Instruction.Binary.Op.I64Shl;
            }
            if (node instanceof RightShiftNode) {
                return isInt32 ? Instruction.Binary.Op.I32ShrS : Instruction.Binary.Op.I64ShrS;
            }
            if (node instanceof UnsignedRightShiftNode) {
                return isInt32 ? Instruction.Binary.Op.I32ShrU : Instruction.Binary.Op.I64ShrU;
            }
        } else {
            if (node instanceof CopySignNode) {
                assert (type.isFloat()) : type;
                return type == WasmPrimitiveType.f32 ? Instruction.Binary.Op.F32CopySign : Instruction.Binary.Op.F64CopySign;
            }
            if (node instanceof FloatingIntegerDivRemNode) {
                boolean isI32;
                assert (type.isInt()) : type;
                boolean bl = isI32 = type == WasmPrimitiveType.i32;
                if (node instanceof SignedFloatingIntegerDivNode) {
                    return isI32 ? Instruction.Binary.Op.I32DivS : Instruction.Binary.Op.I64DivS;
                }
                if (node instanceof SignedFloatingIntegerRemNode) {
                    return isI32 ? Instruction.Binary.Op.I32RemS : Instruction.Binary.Op.I64RemS;
                }
            } else if (node instanceof MinMaxNode) {
                boolean isF32;
                assert (type.isFloat()) : type;
                boolean bl = isF32 = type == WasmPrimitiveType.f32;
                if (node instanceof MaxNode) {
                    return isF32 ? Instruction.Binary.Op.F32Max : Instruction.Binary.Op.F64Max;
                }
                if (node instanceof MinNode) {
                    return isF32 ? Instruction.Binary.Op.F32Min : Instruction.Binary.Op.F64Min;
                }
            }
        }
        throw GraalError.unimplemented((String)node.toString(Verbosity.All));
    }

    private Instruction lowerBinaryMathIntrinsic(BinaryMathIntrinsicNode node) {
        assert (node.getStackKind() == JavaKind.Double) : node.getStackKind();
        switch (node.getOperation()) {
            default: {
                throw new MatchException(null, null);
            }
            case POW: 
        }
        ImportDescriptor.Function imported = WasmImports.F64Pow;
        return new Instruction.Call((WasmId.Func)this.masm.idFactory.forFunctionImport(imported), this.lowerExpression(node.getX()), this.lowerExpression(node.getY()));
    }

    protected Instruction lowerCompareNode(CompareNode compare) {
        ValueNode left = compare.getX();
        JavaKind leftKind = left.getStackKind();
        ValueNode right = compare.getY();
        JavaKind rightKind = right.getStackKind();
        assert (leftKind == rightKind) : String.valueOf(leftKind) + " != " + String.valueOf(rightKind);
        assert (!compare.unorderedIsTrue()) : "Any comparison with unorderedIsTrue should be have been replaced in UnorderedIsTruePhase";
        WasmValType type = this.util.mapType(leftKind.getStackKind());
        if (type.isInt() && compare.isIdentityComparison()) {
            ValueNode nonZeroValue = null;
            if (left.isDefaultConstant()) {
                nonZeroValue = right;
            } else if (right.isDefaultConstant()) {
                nonZeroValue = left;
            }
            if (nonZeroValue != null) {
                return (type == WasmPrimitiveType.i32 ? Instruction.Unary.Op.I32Eqz : Instruction.Unary.Op.I64Eqz).create(this.lowerExpression(nonZeroValue));
            }
        }
        Instruction.Binary.Op op = switch (compare.condition()) {
            default -> throw new MatchException(null, null);
            case CanonicalCondition.EQ -> {
                if (type.isPrimitive()) {
                    switch (type.asPrimitive()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case i32: {
                            yield Instruction.Binary.Op.I32Eq;
                        }
                        case i64: {
                            yield Instruction.Binary.Op.I64Eq;
                        }
                        case f32: {
                            yield Instruction.Binary.Op.F32Eq;
                        }
                        case f64: 
                    }
                    yield Instruction.Binary.Op.F64Eq;
                }
                if (type.isRef()) {
                    yield Instruction.Binary.Op.RefEq;
                }
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)type);
            }
            case CanonicalCondition.LT -> {
                switch (type.asPrimitive()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case i32: {
                        yield Instruction.Binary.Op.I32LtS;
                    }
                    case i64: {
                        yield Instruction.Binary.Op.I64LtS;
                    }
                    case f32: {
                        yield Instruction.Binary.Op.F32Lt;
                    }
                    case f64: 
                }
                yield Instruction.Binary.Op.F64Lt;
            }
            case CanonicalCondition.BT -> {
                if (!$assertionsDisabled && !type.isInt()) {
                    throw new AssertionError(type);
                }
                yield type == WasmPrimitiveType.i32 ? Instruction.Binary.Op.I32LtU : Instruction.Binary.Op.I64LtU;
            }
        };
        return op.create(this.lowerExpression(left), this.lowerExpression(right));
    }

    protected Instruction lowerReadException(ReadExceptionObjectNode n) {
        return this.exceptionObjectVariable.getter();
    }

    protected Instruction lowerWordCast(WordCastNode n) {
        return this.lowerWordCast((ValueNode)n, n.getInput());
    }

    protected Instruction lowerFloatingWordCast(FloatingWordCastNode n) {
        return this.lowerWordCast((ValueNode)n, n.getInput());
    }

    protected Instruction lowerWordCast(ValueNode castNode, ValueNode input) {
        int outputBits;
        Instruction value = this.lowerExpression(input);
        int inputBits = this.util.typeForNode(input).asPrimitive().getBitCount();
        if (inputBits == (outputBits = this.util.typeForNode(castNode).asPrimitive().getBitCount())) {
            return value;
        }
        if (inputBits == 32 && outputBits == 64) {
            return Instruction.Unary.Op.I64ExtendI32U.create(value);
        }
        if (inputBits == 64 && outputBits == 32) {
            return Instruction.Unary.Op.I32Wrap64.create(value);
        }
        throw GraalError.unimplemented((String)(String.valueOf(castNode) + ", inputBits=" + inputBits + ", outputBits=" + outputBits));
    }

    private static void genUnreachable(Object comment) {
        GraalError.shouldNotReachHere((String)String.valueOf(comment));
    }

    protected void lowerVarDeclPrefix(ResolvedVar resolvedVar) {
        WebImageWasmNodeLowerer.genUnreachable(resolvedVar);
    }

    protected void lower(ResolvedVar resolvedVar) {
        WebImageWasmNodeLowerer.genUnreachable(resolvedVar);
    }

    protected void lower(BlackholeNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ReachabilityFenceNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(UnsafeMemoryLoadNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(UnsafeMemoryStoreNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(BytecodeExceptionNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(RoundNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(SqrtNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(AbsNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(UnaryMathIntrinsicNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(BinaryMathIntrinsicNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(GetClassNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(BinaryArithmeticNode<?> node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(IntegerDivRemNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ForeignCall node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ObjectIsArrayNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(DynamicNewArrayNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(AtomicReadAndWriteNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(AtomicReadAndAddNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(AbstractUnsafeCompareAndSwapNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(RawStoreNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(RawLoadNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ReadNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(JavaWriteNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(JavaReadNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(StateSplitProxyNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(EndNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(LoadArrayComponentHubNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(LoadHubNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ObjectClone node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(NewMultiArrayNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ArrayEqualsNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ArrayFillNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(InstanceOfDynamicNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(InstanceOfNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(WordCastNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ShortCircuitOrNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(StoreFieldNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ReinterpretNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(UnboxNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(SignumNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(LoadFieldNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(NewInstanceNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(DynamicNewInstanceNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(NotNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(LogicNegationNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(NarrowNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ZeroExtendNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(SignExtendNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ShiftNode<?> node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(DeadEndNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(CompareNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ObjectEqualsNode node) {
        this.lower((CompareNode)node);
    }

    protected void lower(ReturnNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(IntegerTestNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(BasicArrayCopyNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ArrayLengthNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(FloatConvertNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(BoxNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ConditionalNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ParameterNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(StoreIndexedNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(NewArrayNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(LoadIndexedNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ConstantNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ExceptionObjectNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(IsNullNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(Invoke node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(UnwindNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(NegateNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }

    protected void lower(ClassIsAssignableFromNode node) {
        WebImageWasmNodeLowerer.genUnreachable(node);
    }
}

