/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.ReadExceptionObjectNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFixedNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFloatingNode;
import com.oracle.svm.core.graal.nodes.WriteStackPointerNode;
import com.oracle.svm.core.graal.stackvalue.LoweredStackValueNode;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.js.JSBody;
import com.oracle.svm.hosted.webimage.wasm.WasmImports;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmReservedRegisters;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmVMThreadLocalSTSupport;
import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.ImportDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Instructions;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmIRWalker;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmLMCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmBackend;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmNodeLowerer;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmAddressNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemoryCopyNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemoryFillNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemoryGrowNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmMemorySizeNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmPrintNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WasmTrapNode;
import com.oracle.svm.hosted.webimage.wasm.nodes.WebImageWasmVMThreadLocalSTHolderNode;
import com.oracle.svm.hosted.webimage.wasm.snippets.WasmImportForeignCallDescriptor;
import com.oracle.svm.webimage.functionintrinsics.JSCallNode;
import com.oracle.svm.webimage.functionintrinsics.JSSystemFunction;
import com.oracle.svm.webimage.wasm.types.WasmLMUtil;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.Set;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DirectCallTargetNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoweredCallTargetNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerDivRemNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.debug.BlackholeNode;
import jdk.graal.compiler.nodes.extended.FixedValueAnchorNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.PublishWritesNode;
import jdk.graal.compiler.nodes.java.ReachabilityFenceNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.MemoryAnchorNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.replacements.DimensionsNode;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.graal.compiler.replacements.nodes.ZeroMemoryNode;
import jdk.graal.compiler.word.WordCastNode;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;

public class WebImageWasmLMNodeLowerer
extends WebImageWasmNodeLowerer {
    private static final Set<JSSystemFunction> SUPPORTED_OBJECT_JS_CALLS = Set.of(JSCallNode.GEN_CALL_STACK, JSCallNode.GET_CURRENT_WORKING_DIRECTORY);
    private static final Set<JSSystemFunction> FORBIDDEN_JS_CALLS = Set.of(JSCallNode.MEM_MALLOC, JSCallNode.MEM_CALLOC, JSCallNode.MEM_REALLOC, JSCallNode.MEM_FREE);

    public WebImageWasmLMNodeLowerer(WasmCodeGenTool codeGenTool) {
        super(codeGenTool);
    }

    @Override
    protected WasmLMCodeGenTool masm() {
        return (WasmLMCodeGenTool)super.masm();
    }

    @Override
    public ResolvedVar lowerVariableStore(ValueNode n, Instruction value) {
        assert (this.masm().declared((Node)n)) : n;
        assert (this.util.hasValue((Node)n)) : n;
        ResolvedVar variable = this.masm().getAllocatedVariable(n);
        WasmValType type = this.util.typeForNode(n);
        WebImageWasmIds.NodeVariable local = this.masm().idFactory.forVariable(variable, type);
        if (!this.masm().isSpilled(n)) {
            return super.lowerVariableStore(n, value);
        }
        VirtualStackSlot slot = this.masm().allocateSpillSlot();
        this.masm().genInst(this.masm().getStackSlotAddress(slot));
        this.masm().genInst((Instruction)local.tee(value), (Node)n);
        this.masm().genInst((Instruction)new Instruction.Store(WasmLMUtil.POINTER_TYPE, new Instruction.Nop(), new Instruction.Nop()), "Spilling live object to stack");
        return variable;
    }

    @Override
    protected Instruction lowerTopLevelStatement(Node n, WasmIRWalker.Requirements reqs) {
        assert (!this.util.hasValue(n)) : n;
        if (n instanceof ReturnNode) {
            ReturnNode returnNode = (ReturnNode)n;
            return this.lowerReturn(returnNode);
        }
        if (n instanceof BlackholeNode) {
            BlackholeNode blackhole = (BlackholeNode)n;
            return this.lowerDrop(blackhole.getValue());
        }
        if (n instanceof ReachabilityFenceNode) {
            ReachabilityFenceNode reachabilityFence = (ReachabilityFenceNode)n;
            return this.lowerReachabilityFence(reachabilityFence);
        }
        if (n instanceof LoweredDeadEndNode) {
            return new Instruction.Unreachable();
        }
        if (n instanceof WasmTrapNode) {
            return new Instruction.Unreachable();
        }
        if (n instanceof MemoryAnchorNode) {
            return null;
        }
        if (n instanceof UnwindNode) {
            UnwindNode unwind = (UnwindNode)n;
            return this.lowerUnwind(unwind);
        }
        if (n instanceof AssertionNode) {
            AssertionNode assertion = (AssertionNode)n;
            return WebImageWasmLMNodeLowerer.lowerAssert(assertion);
        }
        if (n instanceof WriteStackPointerNode) {
            WriteStackPointerNode writeStackPointer = (WriteStackPointerNode)n;
            return this.masm().getKnownIds().stackPointer.setter(Instruction.Unary.Op.I32Wrap64.create(this.lowerExpression(writeStackPointer.getValue())));
        }
        if (n instanceof WasmPrintNode) {
            WasmPrintNode printNode = (WasmPrintNode)n;
            return this.lowerPrint(printNode);
        }
        assert (n instanceof ValueNode) : n;
        return this.dispatch((ValueNode)n, reqs);
    }

    @Override
    protected Instruction lowerReturn(ReturnNode returnNode) {
        Instruction result;
        ValueNode resultNode = returnNode.result();
        boolean isVoid = resultNode == null;
        Instruction instruction = result = isVoid ? null : this.lowerExpression(resultNode);
        if (!isVoid) {
            this.masm().genInst(result, (Node)resultNode);
            result = new Instruction.Nop();
            result.setComment("Placeholder, return value is read from stack");
        }
        this.masm().genInst((Instruction)this.masm().getKnownIds().stackPointer.setter(this.masm().getCallerStackPointer()), "Deallocate stack frame");
        return new Instruction.Return(result);
    }

    private Instruction lowerPrint(WasmPrintNode printNode) {
        Instruction fd = this.lowerExpression(printNode.getFd());
        Instruction.Unary address = Instruction.Unary.Op.I32Wrap64.create(this.lowerExpression(printNode.input()));
        Instruction.Unary length = Instruction.Unary.Op.I32Wrap64.create(this.lowerExpression(printNode.getLength()));
        ImportDescriptor.Function printImport = switch (printNode.elementSize) {
            case 1 -> WasmImports.printBytes;
            case 2 -> WasmImports.printChars;
            default -> throw GraalError.shouldNotReachHere((String)("Print node with element size " + printNode.elementSize));
        };
        return new Instruction.Call((WasmId.Func)this.masm().idFactory.forFunctionImport(printImport), fd, address, length);
    }

    private Instruction lowerUnwind(UnwindNode n) {
        return new Instruction.Throw(this.masm().getKnownIds().getJavaThrowableTag(), this.lowerExpression(n.exception()));
    }

    @Override
    protected Instruction dispatch(ValueNode n, WasmIRWalker.Requirements reqs) {
        if (n instanceof LoweredStackValueNode) {
            LoweredStackValueNode loweredStackValue = (LoweredStackValueNode)n;
            return this.lowerStackValue(loweredStackValue);
        }
        if (n instanceof DimensionsNode) {
            DimensionsNode dimensions = (DimensionsNode)n;
            return this.lowerDimensions(dimensions);
        }
        if (n instanceof ReadCallerStackPointerNode) {
            return Instruction.Unary.Op.I64ExtendI32U.create(this.masm().getCallerStackPointer());
        }
        if (n instanceof InvokeNode) {
            InvokeNode invoke = (InvokeNode)n;
            return this.lowerInvoke(invoke);
        }
        if (n instanceof InvokeWithExceptionNode) {
            InvokeWithExceptionNode invoke = (InvokeWithExceptionNode)n;
            return this.lowerInvoke(invoke);
        }
        if (n instanceof ForeignCall) {
            ForeignCall foreignCall = (ForeignCall)n;
            return this.lowerForeignCall(foreignCall);
        }
        if (n instanceof LogicNode) {
            LogicNode logic = (LogicNode)n;
            return this.lowerLogicNode(logic, reqs);
        }
        if (n instanceof FixedAccessNode) {
            FixedAccessNode fixedAccess = (FixedAccessNode)n;
            return this.lowerFixedAccess(fixedAccess);
        }
        if (n instanceof WasmAddressNode) {
            WasmAddressNode addressNode = (WasmAddressNode)n;
            return this.lowerWasmAddress(addressNode);
        }
        if (n instanceof CGlobalDataLoadAddressNode) {
            CGlobalDataLoadAddressNode globalData = (CGlobalDataLoadAddressNode)n;
            return this.lowerGlobalData(globalData);
        }
        if (n instanceof ConstantNode) {
            ConstantNode constant = (ConstantNode)n;
            return this.lowerConstant(constant);
        }
        if (n instanceof ParameterNode) {
            ParameterNode param = (ParameterNode)n;
            return this.lowerParam(param);
        }
        if (n instanceof BinaryNode) {
            BinaryNode binary = (BinaryNode)n;
            return this.lowerBinary(binary);
        }
        if (n instanceof CompressionNode) {
            CompressionNode compression = (CompressionNode)n;
            return this.lowerCompression(compression, reqs);
        }
        if (n instanceof UnaryNode) {
            UnaryNode unary = (UnaryNode)n;
            return this.lowerUnary(unary);
        }
        if (n instanceof ConditionalNode) {
            ConditionalNode conditional = (ConditionalNode)n;
            return this.lowerConditional(conditional);
        }
        if (n instanceof PiNode) {
            PiNode pi = (PiNode)n;
            return this.lowerPi(pi, reqs);
        }
        if (n instanceof IntegerDivRemNode) {
            IntegerDivRemNode divRem = (IntegerDivRemNode)n;
            return this.lowerDivRem(divRem);
        }
        if (n instanceof FixedValueAnchorNode) {
            FixedValueAnchorNode fixedValueAnchor = (FixedValueAnchorNode)n;
            return this.lowerExpression(fixedValueAnchor.object());
        }
        if (n instanceof PublishWritesNode) {
            PublishWritesNode publishWrites = (PublishWritesNode)n;
            return this.lowerExpression(publishWrites.getOriginalNode());
        }
        if (n instanceof WordCastNode) {
            WordCastNode wordCast = (WordCastNode)n;
            return this.lowerWordCast(wordCast);
        }
        if (n instanceof FloatingWordCastNode) {
            FloatingWordCastNode floatingWordCast = (FloatingWordCastNode)n;
            return this.lowerFloatingWordCast(floatingWordCast);
        }
        if (n instanceof ReadExceptionObjectNode) {
            ReadExceptionObjectNode readExceptionObject = (ReadExceptionObjectNode)n;
            return this.lowerReadException(readExceptionObject);
        }
        if (n instanceof ReadReservedRegisterFloatingNode) {
            ReadReservedRegisterFloatingNode readReservedRegister = (ReadReservedRegisterFloatingNode)n;
            return this.lowerReadReservedRegister(readReservedRegister.getRegister());
        }
        if (n instanceof ReadReservedRegisterFixedNode) {
            ReadReservedRegisterFixedNode readReservedRegister = (ReadReservedRegisterFixedNode)n;
            return this.lowerReadReservedRegister(readReservedRegister.getRegister());
        }
        if (n instanceof WebImageWasmVMThreadLocalSTHolderNode) {
            WebImageWasmVMThreadLocalSTHolderNode threadLocalHolder = (WebImageWasmVMThreadLocalSTHolderNode)n;
            return this.lowerThreadLocalHolder(threadLocalHolder);
        }
        if (n instanceof WasmMemorySizeNode) {
            return new Instruction.MemorySize();
        }
        if (n instanceof WasmMemoryGrowNode) {
            WasmMemoryGrowNode memoryGrow = (WasmMemoryGrowNode)n;
            return Instruction.Unary.Op.I64ExtendI32U.create(new Instruction.MemoryGrow(Instruction.Unary.Op.I32Wrap64.create(this.lowerExpression(memoryGrow.getNumPages()))));
        }
        if (n instanceof WasmMemoryCopyNode) {
            WasmMemoryCopyNode memoryCopy = (WasmMemoryCopyNode)n;
            return new Instruction.MemoryCopy(this.lowerExpression(memoryCopy.getTarget()), this.lowerExpression(memoryCopy.getSource()), this.lowerExpression(memoryCopy.getSize()));
        }
        if (n instanceof WasmMemoryFillNode) {
            WasmMemoryFillNode memoryFill = (WasmMemoryFillNode)n;
            return new Instruction.MemoryFill(this.lowerExpression(memoryFill.getStart()), this.lowerExpression(memoryFill.getFillValue()), this.lowerExpression(memoryFill.getSize()));
        }
        if (n instanceof JSBody) {
            JSBody jsBody = (JSBody)n;
            return this.lowerJSBody(jsBody);
        }
        if (n instanceof JSCallNode) {
            JSCallNode jsCall = (JSCallNode)n;
            return this.lowerJSCall(jsCall);
        }
        assert (!this.isForbiddenNode((Node)n)) : this.reportForbiddenNode((Node)n);
        throw GraalError.shouldNotReachHere((String)("Tried to lower unknown node: " + String.valueOf(n)));
    }

    @Override
    protected Instruction lowerWasmImportForeignCall(WasmImportForeignCallDescriptor descriptor, Instructions args) {
        throw GraalError.unimplemented((String)("No foreign calls to imports should exist here: " + String.valueOf((Object)descriptor)));
    }

    @Override
    protected Instruction lowerIsNull(IsNullNode n) {
        return Instruction.Unary.Op.I32Eqz.create(this.lowerExpression(n.getValue()));
    }

    protected Instruction lowerPi(PiNode pi, WasmIRWalker.Requirements reqs) {
        return this.lowerExpression(pi.getOriginalNode(), reqs);
    }

    protected <T extends FixedNode> Instruction lowerInvoke(T node) {
        HostedMethod targetMethod = (HostedMethod)((Invoke)node).getTargetMethod();
        LoweredCallTargetNode callTarget = (LoweredCallTargetNode)((Invoke)node).callTarget();
        Instructions params = new Instructions();
        callTarget.arguments().forEach(param -> params.add(this.lowerExpression((ValueNode)param)));
        if (callTarget instanceof IndirectCallTargetNode) {
            TypeUse typeUse;
            IndirectCallTargetNode indirectCallTarget = (IndirectCallTargetNode)callTarget;
            WasmPrimitiveType addressType = this.util.typeForNode(indirectCallTarget.computedAddress()).asPrimitive();
            Instruction index = this.lowerExpression(indirectCallTarget.computedAddress());
            if (addressType == WasmPrimitiveType.i64) {
                index = Instruction.Unary.Op.I32Wrap64.create(index);
            }
            if (targetMethod == null) {
                assert (!indirectCallTarget.invokeKind().hasReceiver()) : "Calls to an address cannot have receivers: " + String.valueOf(indirectCallTarget);
                MetaAccessProvider metaAccess = this.masm().getProviders().getMetaAccess();
                ResolvedJavaType returnType = indirectCallTarget.returnStamp().getTrustedStamp().javaType(metaAccess);
                typeUse = WebImageWasmBackend.signatureToTypeUse(this.masm().wasmProviders, indirectCallTarget.signature(), (JavaType)returnType);
            } else {
                typeUse = WebImageWasmBackend.methodToTypeUse(this.masm().wasmProviders, targetMethod);
            }
            FunctionTypeDescriptor typeDescriptor = FunctionTypeDescriptor.createSimple(typeUse);
            return this.masm().getCall((InvokeTarget)targetMethod, false, new Instruction.CallIndirect(this.masm().getKnownIds().functionTable, index, this.masm().idFactory.newFuncType(typeDescriptor), typeUse, params));
        }
        if (callTarget instanceof DirectCallTargetNode) {
            return this.masm().getCall((InvokeTarget)targetMethod, true, new Instruction.Call((WasmId.Func)this.masm().idFactory.forMethod((ResolvedJavaMethod)targetMethod), params));
        }
        throw GraalError.shouldNotReachHereUnexpectedValue((Object)callTarget);
    }

    private Instruction lowerReadReservedRegister(Register register) {
        if (register.equals((Object)WebImageWasmReservedRegisters.FRAME_REGISTER)) {
            return Instruction.Unary.Op.I64ExtendI32U.create(this.masm().getKnownIds().stackPointer.getter());
        }
        throw GraalError.unimplemented((String)("Cannot read register: " + String.valueOf(register)));
    }

    private Instruction lowerWasmAddressBase(WasmAddressNode n) {
        ValueNode baseNode = n.getBase();
        Instruction base = this.lowerExpression(baseNode);
        if (baseNode.getStackKind() == JavaKind.Long) {
            base = Instruction.Unary.Op.I32Wrap64.create(base);
        }
        return base;
    }

    private Instruction lowerWasmAddress(WasmAddressNode n) {
        ValueNode offsetNode = n.getIndex();
        return Instruction.Binary.Op.I32Add.create(this.lowerWasmAddressBase(n), this.lowerExpression(offsetNode));
    }

    private Instruction lowerGlobalData(CGlobalDataLoadAddressNode n) {
        return this.masm().getRelocation((Reference)new CGlobalDataReference(n.getDataInfo()));
    }

    private Instruction lowerFixedAccess(FixedAccessNode n) {
        assert (!n.getUsedAsNullCheck()) : "Accesses cannot be used as null checksAccesses cannot be used as null checks";
        WasmAddressNode addressNode = (WasmAddressNode)n.getAddress();
        if (n instanceof ReadNode || n instanceof WriteNode) {
            Instruction offsetInstr;
            Instruction address;
            if (addressNode.hasConstantOffset()) {
                address = this.lowerWasmAddressBase(addressNode);
                offsetInstr = this.lowerConstant((Constant)addressNode.getConstantOffset());
            } else {
                address = this.lowerExpression((ValueNode)addressNode);
                offsetInstr = Instruction.Const.forInt(0);
            }
            if (n instanceof ReadNode) {
                ReadNode read = (ReadNode)n;
                JavaKind stackKind = read.getStackKind();
                int accessBits = stackKind == JavaKind.Object ? WasmLMUtil.POINTER_KIND.getBitCount() : read.getAccessBits();
                MemoryExtendKind extendKind = read.getExtendKind();
                boolean signExtend = false;
                if (extendKind != MemoryExtendKind.DEFAULT) {
                    assert (extendKind.getExtendedBitSize() == stackKind.getBitCount()) : String.valueOf(extendKind) + ", " + String.valueOf(stackKind);
                    signExtend = extendKind.isSignExtend();
                }
                WasmValType stackType = this.util.mapType(stackKind);
                assert (stackType instanceof WasmPrimitiveType) : "Attempt to read non-primitive value from memory: " + String.valueOf(n);
                return new Instruction.Load((WasmPrimitiveType)stackType, offsetInstr, address, accessBits, signExtend);
            }
            WriteNode write = (WriteNode)n;
            ValueNode value = write.value();
            JavaKind writeKind = value.getStackKind();
            JavaKind memoryKind = this.util.memoryKind(value.stamp(NodeView.DEFAULT));
            WasmValType stackType = this.util.mapType(writeKind);
            assert (stackType instanceof WasmPrimitiveType) : "Attempt to write non-primitive value to memory: " + String.valueOf(n);
            return new Instruction.Store((WasmPrimitiveType)stackType, offsetInstr, this.lowerExpression(write.value()), address, memoryKind.getBitCount());
        }
        if (n instanceof ZeroMemoryNode) {
            ZeroMemoryNode zeroMemory = (ZeroMemoryNode)n;
            Instruction length = this.lowerExpression(zeroMemory.getLength());
            return new Instruction.MemoryFill(this.lowerExpression((ValueNode)addressNode), Instruction.Const.forInt(0), Instruction.Unary.Op.I32Wrap64.create(length));
        }
        throw GraalError.shouldNotReachHere((String)n.toString());
    }

    private Instruction lowerThreadLocalHolder(WebImageWasmVMThreadLocalSTHolderNode threadLocalHolder) {
        WebImageWasmVMThreadLocalSTSupport threadLocalSupport = (WebImageWasmVMThreadLocalSTSupport)ImageSingletons.lookup(WebImageWasmVMThreadLocalSTSupport.class);
        boolean isObject = threadLocalHolder.getThreadLocalInfo().isObject;
        Object[] holder = isObject ? threadLocalSupport.objectThreadLocals : (Object[])threadLocalSupport.primitiveThreadLocals;
        return this.masm().getConstantRelocation(this.masm().getProviders().getSnippetReflection().forObject((Object)holder));
    }

    private Instruction lowerStackValue(LoweredStackValueNode stackValue) {
        LoweredStackValueNode.StackSlotHolder stackSlotHolder = stackValue.getStackSlotHolder();
        int sizeInBytes = stackValue.getSizeInBytes();
        int alignmentInBytes = stackValue.getAlignmentInBytes();
        assert (stackSlotHolder != null) : "node not processed by StackValuePhase";
        assert (sizeInBytes > 0) : "Stack slot with size zero";
        VirtualStackSlot slot = stackSlotHolder.getSlot();
        if (slot == null) {
            slot = this.masm().allocateStackMemory(sizeInBytes, alignmentInBytes);
            stackSlotHolder.setSlot(slot);
        }
        return Instruction.Unary.Op.I64ExtendI32U.create(this.masm().getStackSlotAddress(slot));
    }

    private Instruction lowerDimensions(DimensionsNode dimensions) {
        int sizeInBytes = dimensions.getRank() * 4;
        VirtualStackSlot array = this.masm().allocateStackMemory(sizeInBytes, 4);
        return Instruction.Unary.Op.I64ExtendI32U.create(this.masm().getStackSlotAddress(array));
    }

    private Instruction lowerJSCall(JSCallNode n) {
        JSSystemFunction func = n.getFunctionDefinition();
        boolean passesObject = false;
        for (ValueNode node : n.getArguments()) {
            if (!node.stamp(NodeView.DEFAULT).isPointerStamp()) continue;
            passesObject = true;
            break;
        }
        if (n.stamp(NodeView.DEFAULT).isPointerStamp()) {
            passesObject = true;
        }
        if (passesObject && !SUPPORTED_OBJECT_JS_CALLS.contains(func)) {
            return this.getStub((Node)n);
        }
        if (FORBIDDEN_JS_CALLS.contains(func)) {
            return this.getStub((Node)n);
        }
        Instructions params = new Instructions();
        n.getArguments().forEach(param -> params.add(this.lowerExpression((ValueNode)param)));
        return new Instruction.Call(this.masm().wasmProviders.getJSCounterparts().idForJSFunction(this.masm().wasmProviders, func), params);
    }

    private Instruction lowerJSBody(JSBody n) {
        return this.getStub((Node)n.asNode());
    }
}

