/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataImpl;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.image.NativeImageHeapWriter;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmOptions;
import com.oracle.svm.hosted.webimage.wasm.ast.Data;
import com.oracle.svm.hosted.webimage.wasm.ast.Export;
import com.oracle.svm.hosted.webimage.wasm.ast.Global;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.Limit;
import com.oracle.svm.hosted.webimage.wasm.ast.Memory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmRelocationVisitor;
import com.oracle.svm.hosted.webimage.wasm.codegen.AbsoluteIPConstant;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCodeGen;
import com.oracle.svm.hosted.webimage.wasm.gc.MemoryLayout;
import com.oracle.svm.hosted.webimage.wasm.stack.InitialStackPointerConstant;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class WebImageWasmLMCodeGen
extends WebImageWasmCodeGen {
    public WebImageWasmLMCodeGen(WebImageCodeCache codeCache, List<HostedMethod> hostedEntryPoints, HostedMethod mainEntryPoint, WebImageProviders providers, DebugContext debug, WebImageHostedConfiguration config) {
        super(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, config);
    }

    @Override
    public long getImageHeapSize() {
        return this.module.getDataSegments().stream().filter(d -> d.active).mapToLong(Data::getSize).sum();
    }

    @Override
    protected void writeImageHeap() {
        ImageHeapLayoutInfo layout = this.codeCache.nativeImageHeap.getLayouter().layout((ImageHeap)this.codeCache.nativeImageHeap, 65536, ImageHeapLayouter.ImageHeapLayouterCallback.NONE);
        this.setLayout(layout);
        this.afterHeapLayout();
        NativeImageHeapWriter writer = new NativeImageHeapWriter(this.codeCache.nativeImageHeap, layout);
        RelocatableBuffer heapSectionBuffer = new RelocatableBuffer(layout.getImageHeapSize(), WasmUtil.BYTE_ORDER);
        this.codeCache.writeConstants(writer, heapSectionBuffer);
        writer.writeHeap(this.debug, heapSectionBuffer);
        long heapStart = MemoryLayout.HEAP_BASE.rawValue();
        assert (heapStart % 8L == 0L) : heapStart;
        int imageHeapSize = (int)layout.getImageHeapSize();
        EconomicMap globalData = EconomicMap.create();
        int memorySize = MemoryLayout.constructLayout(globalData, imageHeapSize, (Integer)WebImageWasmOptions.StackSize.getValue());
        this.processRelocations(heapSectionBuffer, heapStart, (UnmodifiableEconomicMap<CGlobalData<?>, UnsignedWord>)globalData);
        this.module.addActiveData(heapStart, heapSectionBuffer.getBackingArray());
        WasmId.Memory memId = this.getProviders().knownIds().heapMemory;
        this.module.addExport(new Export(Export.Type.MEM, memId, "memory", "Main Memory"));
        this.module.setMemory(new Memory(memId, Limit.withoutMax(NumUtil.divideAndRoundUp((int)memorySize, (int)65536)), null));
    }

    @Override
    protected void genWasmModule() {
        super.genWasmModule();
        this.module.addGlobal(new Global(this.getProviders().knownIds.stackPointer, true, Instruction.Relocation.forConstant(InitialStackPointerConstant.INSTANCE), "Shadow stack pointer"));
    }

    private void processRelocations(RelocatableBuffer buffer, final long heapStart, final UnmodifiableEconomicMap<CGlobalData<?>, UnsignedWord> globalData) {
        for (Map.Entry entry : buffer.getSortedRelocations()) {
            long relocatedValue;
            int offset = (Integer)entry.getKey();
            RelocatableBuffer.Info info = (RelocatableBuffer.Info)entry.getValue();
            ObjectFile.RelocationKind relocationKind = info.getRelocationKind();
            Object targetObject = info.getTargetObject();
            assert (relocationKind == ObjectFile.RelocationKind.DIRECT_8) : "Unsupported relocation kind: " + String.valueOf(relocationKind);
            if (targetObject instanceof WordBase) {
                GraalError.guarantee((boolean)(targetObject instanceof MethodPointer), (String)"Relocated word is not a method pointer: %s", (Object)targetObject);
                relocatedValue = this.getFunctionTableIndex((MethodPointer)targetObject);
                assert (info.getAddend() == 0L) : "Non-zero addend in method poiner relocation" + String.valueOf(info);
            } else {
                NativeImageHeap.ObjectInfo targetObjectInfo = this.codeCache.nativeImageHeap.getConstantInfo((JavaConstant)targetObject);
                assert (targetObjectInfo != null) : "Relocated object not found: " + String.valueOf(targetObject);
                relocatedValue = heapStart + targetObjectInfo.getOffset();
            }
            long relocationAddend = relocatedValue + info.getAddend();
            buffer.getByteBuffer().putLong(offset, relocationAddend);
        }
        new WasmRelocationVisitor(this){
            final /* synthetic */ WebImageWasmLMCodeGen this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitUnprocessedRelocation(Instruction.Relocation relocation) {
                Reference targetRef = relocation.target;
                if (targetRef instanceof ConstantReference) {
                    VMConstant constant = ((ConstantReference)targetRef).getConstant();
                    if (constant instanceof JavaConstant) {
                        NativeImageHeap.ObjectInfo objectInfo = ((WebImageWasmLMCodeGen)this.this$0).codeCache.nativeImageHeap.getConstantInfo((JavaConstant)constant);
                        int address = (int)(objectInfo.getOffset() + heapStart);
                        relocation.setValue(Instruction.Const.forInt(address));
                    } else if (constant instanceof AbsoluteIPConstant) {
                        AbsoluteIPConstant ipConstant = (AbsoluteIPConstant)constant;
                        HostedMethod method = (HostedMethod)ipConstant.method();
                        relocation.setValue(Instruction.Const.forInt(method.getCodeAddressOffset() + ipConstant.relativeIP()));
                    } else {
                        if (!(constant instanceof InitialStackPointerConstant)) throw GraalError.unimplemented((String)("Unsupported constant relocation: " + String.valueOf(constant)));
                        relocation.setValue(Instruction.Const.forInt((int)((UnsignedWord)globalData.get(MemoryLayout.STACK_BASE)).rawValue()));
                    }
                } else if (targetRef instanceof CGlobalDataReference) {
                    CGlobalDataImpl globalDataReference = ((CGlobalDataReference)targetRef).getDataInfo().getData();
                    GraalError.guarantee((boolean)globalData.containsKey((Object)globalDataReference), (String)"CGlobalData was referenced but not defined: %s", (Object)globalDataReference);
                    relocation.setValue(Instruction.Const.forWord((WordBase)globalData.get((Object)globalDataReference)));
                }
                GraalError.guarantee((boolean)relocation.wasProcessed(), (String)"Relocation %s was not processed, target: %s", (Object)relocation, (Object)targetRef);
            }
        }.visitModule(this.module);
    }
}

