/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.hosted.webimage.codegen.WebImageCompilationResult;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WebImageWasmCompilationResult
extends WebImageCompilationResult {
    protected Function function;
    private List<Function> extraFunctions;
    protected ResolvedJavaType[] paramTypes;
    protected ResolvedJavaType returnType;
    protected final List<StackSlot> liveSlots = new ArrayList<StackSlot>();

    public WebImageWasmCompilationResult(CompilationIdentifier compilationId, String name) {
        super(compilationId, name);
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public void addExtraFunction(Function f) {
        if (this.extraFunctions == null) {
            this.extraFunctions = new ArrayList<Function>();
        }
        this.extraFunctions.add(f);
    }

    public List<Function> getAllFunctions() {
        int numExtraFunctions = this.extraFunctions == null ? 0 : this.extraFunctions.size();
        ArrayList<Function> functions = new ArrayList<Function>(numExtraFunctions + 1);
        if (this.function != null) {
            functions.add(this.function);
        }
        if (this.extraFunctions != null) {
            functions.addAll(this.extraFunctions);
        }
        return functions;
    }

    public ResolvedJavaType[] getParamTypes() {
        return this.paramTypes;
    }

    public void setParamTypes(ResolvedJavaType[] paramTypes) {
        this.paramTypes = paramTypes;
    }

    public ResolvedJavaType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ResolvedJavaType returnType) {
        this.returnType = Objects.requireNonNull(returnType);
    }

    public void addLiveStackSlot(StackSlot slot) {
        this.liveSlots.add(slot);
    }

    public List<StackSlot> getLiveSlots() {
        return Collections.unmodifiableList(this.liveSlots);
    }
}

