/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.InvalidMethodPointerHandler;
import com.oracle.svm.core.image.ImageHeap;
import com.oracle.svm.core.image.ImageHeapLayoutInfo;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.WebImageCodeCache;
import com.oracle.svm.hosted.webimage.WebImageHostedConfiguration;
import com.oracle.svm.hosted.webimage.codegen.LowerableResource;
import com.oracle.svm.hosted.webimage.codegen.LowerableResources;
import com.oracle.svm.hosted.webimage.codegen.Runtime;
import com.oracle.svm.hosted.webimage.codegen.WebImageCodeGen;
import com.oracle.svm.hosted.webimage.codegen.WebImageCompilationResult;
import com.oracle.svm.hosted.webimage.codegen.WebImageProviders;
import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.ImageBreakdownMetricKeys;
import com.oracle.svm.hosted.webimage.metrickeys.UniverseMetricKeys;
import com.oracle.svm.hosted.webimage.name.WebImageNamingConvention;
import com.oracle.svm.hosted.webimage.options.WebImageOptions;
import com.oracle.svm.hosted.webimage.wasm.WebImageWasmHeapBreakdownProvider;
import com.oracle.svm.hosted.webimage.wasm.annotation.WasmStartFunction;
import com.oracle.svm.hosted.webimage.wasm.ast.ActiveFunctionElements;
import com.oracle.svm.hosted.webimage.wasm.ast.Export;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.StartFunction;
import com.oracle.svm.hosted.webimage.wasm.ast.Table;
import com.oracle.svm.hosted.webimage.wasm.ast.WasmModule;
import com.oracle.svm.hosted.webimage.wasm.ast.id.ResolverContext;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmElementCreator;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmIdResolver;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmPrinter;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmValidator;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmAssembler;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmFunctionTemplate;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmLMLowerableResources;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCompilationResult;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.hosted.webimage.wasm.debug.WasmDebug;
import com.oracle.svm.hosted.webimage.wasmgc.WasmGCFunctionTemplateFeature;
import com.oracle.svm.hosted.webimage.wasmgc.types.WasmRefType;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionDefinition;
import com.oracle.svm.webimage.functionintrinsics.JSGenericFunctionDefinition;
import com.oracle.svm.webimage.functionintrinsics.JSSystemFunction;
import com.oracle.svm.webimage.wasmgc.annotation.WasmExport;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.Emitter;
import jdk.graal.compiler.hightiercodegen.IEmitter;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class WebImageWasmCodeGen
extends WebImageCodeGen {
    protected final String wasmFilename;
    protected final Path wasmFile;
    protected final String watFilename;
    protected final Path watFile;
    protected WasmModule module;
    protected final ActiveFunctionElements functionTableElements = new ActiveFunctionElements(0, WasmRefType.FUNCREF);
    private ImageHeapLayoutInfo layout = null;
    public static final JSFunctionDefinition ENTRY_POINT_FUN = new JSGenericFunctionDefinition("wasmRun", 1, false, null, false);

    protected WebImageWasmCodeGen(WebImageCodeCache codeCache, List<HostedMethod> hostedEntryPoints, HostedMethod mainEntryPoint, WebImageProviders providers, DebugContext debug, WebImageHostedConfiguration config) {
        super(codeCache, hostedEntryPoints, mainEntryPoint, providers, debug, config);
        this.wasmFilename = this.filename + ".wasm";
        this.watFilename = this.filename + ".wat";
        this.watFile = NativeImageGenerator.generatedFiles((OptionValues)this.options).resolve(this.watFilename);
        this.wasmFile = NativeImageGenerator.generatedFiles((OptionValues)this.options).resolve(this.wasmFilename);
    }

    @Override
    protected WebImageWasmProviders getProviders() {
        return (WebImageWasmProviders)super.getProviders();
    }

    public ImageHeapLayoutInfo getLayout() {
        assert (this.layout != null) : "Image heap layout not set yet";
        return this.layout;
    }

    protected void setLayout(ImageHeapLayoutInfo layout) {
        assert (this.layout == null) : "Image heap layout already set";
        this.layout = Objects.requireNonNull(layout);
    }

    public long getImageHeapSize() {
        return this.getLayout().getImageHeapSize();
    }

    public long getFullImageHeapSize() {
        return this.getLayout().getImageHeapSize();
    }

    @Override
    protected void emitCode() {
        this.genWasmModule();
        assert (this.module != null);
        this.fillNullMethodPointer();
        this.writeImageHeap();
        this.createMissingElements();
        this.getProviders().idFactory().freeze();
        this.patchIds();
        this.module.constructActiveDataSegments();
        ((WebImageWasmHeapBreakdownProvider)HeapBreakdownProvider.singleton()).setActualTotalHeapSize((int)this.getFullImageHeapSize());
        if (((Boolean)WebImageOptions.DebugOptions.VerificationPhases.getValue(this.options)).booleanValue()) {
            this.validateModule();
        }
        this.emitJSCode();
        try (BufferedWriter writer = Files.newBufferedWriter(this.watFile, new OpenOption[0]);){
            new WasmPrinter(writer).visitModule(this.module);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.assembleWasmFile(this.watFile, this.wasmFile);
    }

    @Override
    protected void postProcess() {
        long wasmSize = this.wasmFile.toFile().length();
        LoggerContext.counter(ImageBreakdownMetricKeys.WASM_IMAGE_SIZE).add(wasmSize);
        LoggerContext.counter(ImageBreakdownMetricKeys.ENTIRE_IMAGE_SIZE).add(wasmSize);
    }

    protected void fillNullMethodPointer() {
        ResolvedJavaMethod nullMethod = WasmDebug.NULL_METHOD_POINTER.findMethod(this.getProviders().getMetaAccess());
        assert (this.getProviders().idFactory().hasMethod(nullMethod)) : "nullMethod was never generated";
        int nullMethodIndex = this.functionTableElements.getOrAddElement(this.getProviders().idFactory().forMethod(nullMethod));
        assert (nullMethodIndex == 0) : nullMethodIndex + " functions were added to global function table before the null method";
    }

    protected int getFunctionTableIndex(MethodPointer methodPointer) {
        HostedMethod hostedMethod;
        HostedMethod target;
        ResolvedJavaMethod method = methodPointer.getMethod();
        HostedMethod hostedMethod2 = target = method instanceof HostedMethod ? (hostedMethod = (HostedMethod)method) : this.hUniverse.lookup((JavaMethod)method);
        if (!target.isCompiled()) {
            target = this.hMetaAccess.lookupJavaMethod((Executable)InvalidMethodPointerHandler.METHOD_POINTER_NOT_COMPILED_HANDLER_METHOD);
        }
        WebImageWasmIds.MethodName methodId = this.getProviders().idFactory().forMethod((ResolvedJavaMethod)target);
        return this.getFunctionTableIndex(methodId);
    }

    protected int getFunctionTableIndex(WasmId.Func function) {
        int idx = this.functionTableElements.getOrAddElement(function);
        assert (idx > 0) : idx;
        return idx;
    }

    protected abstract void writeImageHeap();

    @Override
    protected Collection<Path> writeFiles() {
        ArrayList<Path> outFiles = new ArrayList<Path>(super.writeFiles());
        outFiles.add(this.wasmFile);
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.EXECUTABLE, this.wasmFile);
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, this.watFile);
        return outFiles;
    }

    protected void assembleWasmFile(Path watPath, Path wasmPath) {
        try {
            WasmAssembler.singleton().assemble(watPath, wasmPath, this.options, this.getProviders().stdout()::println);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void genWasmModule() {
        this.module = new WasmModule();
        for (WebImageCompilationResult result : this.compilations.values()) {
            WebImageWasmCompilationResult res = (WebImageWasmCompilationResult)result;
            res.getAllFunctions().forEach(this.module::addFunction);
            LoggerContext.counter(UniverseMetricKeys.EMITTED_METHODS).increment();
        }
        LoggerContext.counter(UniverseMetricKeys.EMITTED_TYPES).add(this.compilations.keySet().stream().map(ResolvedJavaMethod::getDeclaringClass).distinct().count());
        this.module.addFunctionExport(this.getProviders().idFactory.forMethod((ResolvedJavaMethod)this.mainEntryPoint), "main", "Main Entry Point");
        for (HostedMethod entryPoint : this.hostedEntryPoints) {
            if (entryPoint.isAnnotationPresent(WasmExport.class)) {
                WasmExport annotation = (WasmExport)entryPoint.getAnnotation(WasmExport.class);
                this.module.addFunctionExport(this.getProviders().idFactory().forMethod((ResolvedJavaMethod)entryPoint), annotation.value(), annotation.comment().isEmpty() ? null : annotation.comment());
            }
            if (!entryPoint.isAnnotationPresent(WasmStartFunction.class)) continue;
            this.module.setStartFunction(new StartFunction(this.getProviders().idFactory().forMethod((ResolvedJavaMethod)entryPoint), null));
        }
        this.getProviders().knownIds.getExports().forEach(this.module::addExport);
        this.module.addExport(new Export(Export.Type.TAG, this.getProviders().knownIds.getJavaThrowableTag(), "tag.throwable", "Tag for Java exceptions"));
    }

    protected void createMissingElements() {
        List<WasmFunctionTemplate<?>> templates = this.getProviders().knownIds().getLateFunctionTemplates();
        List<Function> functionTemplates = WasmGCFunctionTemplateFeature.createFunctionTemplates(templates, (t, f) -> t.createFunctionForIdLate(this.getProviders(), (WasmId.Func)f));
        functionTemplates.forEach(this.module::addFunction);
        this.module.addTable(new Table(this.getProviders().knownIds().functionTable, this.functionTableElements, "Function table"));
        this.getElementsCreator().visitModule(this.module);
    }

    protected WasmElementCreator getElementsCreator() {
        return new WasmElementCreator();
    }

    protected void patchIds() {
        WebImageNamingConvention namingConvention = WebImageNamingConvention.getInstance();
        new WasmIdResolver(new ResolverContext(namingConvention), this.getProviders().idFactory()).visitModule(this.module);
    }

    protected void validateModule() {
        new WasmValidator().visitModule(this.module);
    }

    protected void afterHeapLayout() {
        assert (!this.hasDuplicatedObjects(this.codeCache.nativeImageHeap)) : "heap.getObjects() must not contain any duplicates";
        BuildPhaseProvider.markHeapLayoutFinished();
        this.codeCache.nativeImageHeap.getLayouter().afterLayout((ImageHeap)this.codeCache.nativeImageHeap);
    }

    protected boolean hasDuplicatedObjects(NativeImageHeap heap) {
        Set deduplicated = Collections.newSetFromMap(new IdentityHashMap());
        deduplicated.addAll(heap.getObjects());
        return deduplicated.size() != heap.getObjectCount();
    }

    @Override
    protected void emitPreamble() {
    }

    @Override
    protected void emitBootstrapDefinitions() {
        LowerableResources.lower(this.codeGenTool, LowerableResources.bootstrap);
        LowerableResources.lower(this.codeGenTool, (LowerableResource[])this.getWasmBootstrapResources().toArray(LowerableResource[]::new));
        Runtime.SET_ENDIANNESS_FUN.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((Boolean)true)});
        this.codeGenTool.getCodeBuffer().emitInsEnd();
        TreeMap<String, IEmitter> interopImports = new TreeMap<String, IEmitter>();
        for (JSSystemFunction f : this.getProviders().getJSCounterparts().getFunctions()) {
            interopImports.put(f.getFunctionName(), (IEmitter)Emitter.of((String)("(...args) => " + f.getFunctionName() + "(...args)")));
        }
        this.codeGenTool.genResolvedVarAssignmentPrefix("wasmImports.interop");
        this.codeGenTool.genObject(interopImports);
        this.codeGenTool.getCodeBuffer().emitInsEnd();
    }

    protected List<LowerableResource> getWasmBootstrapResources() {
        return List.of(WasmLMLowerableResources.STACK_TRACE, WasmLMLowerableResources.BOOTSTRAP, WasmLMLowerableResources.IMPORTS, WasmLMLowerableResources.INTEROP, WasmLMLowerableResources.RUNNER, LowerableResources.CWD);
    }

    @Override
    protected void emitRuntimeDefinitions() {
    }

    @Override
    protected void emitCompiledCode() {
    }

    @Override
    protected void emitEntryPointCall() {
        ENTRY_POINT_FUN.emitCall((CodeGenTool)this.codeGenTool, new IEmitter[]{Emitter.of((String)"vmArgs")});
        this.codeBuffer.emitInsEnd();
    }

    @Override
    protected void emitJSCodeFiles() {
    }
}

