/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.webimage.codegen.WebImageBackend;
import com.oracle.svm.hosted.webimage.wasm.ast.Function;
import com.oracle.svm.hosted.webimage.wasm.ast.FunctionTypeDescriptor;
import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmBlockContext;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmIRWalker;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCompilationResult;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmVariableAllocation;
import com.oracle.svm.hosted.webimage.wasm.phases.WebImageWasmLMAddressLowering;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.hightiercodegen.reconstruction.ScheduleWithReconstructionResult;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.AddressLoweringByNodePhase;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public abstract class WebImageWasmBackend
extends WebImageBackend {
    protected WebImageWasmProviders wasmProviders;

    protected WebImageWasmBackend(Providers providers) {
        super(providers);
    }

    public void setWasmProviders(WebImageWasmProviders providers) {
        this.wasmProviders = providers;
    }

    public WebImageWasmProviders getWasmProviders() {
        return this.wasmProviders;
    }

    @Override
    public WebImageWasmCompilationResult newCompilationResult(CompilationIdentifier compilationIdentifier, String name) {
        return new WebImageWasmCompilationResult(compilationIdentifier, name);
    }

    @Override
    public BasePhase<CoreProviders> newAddressLoweringPhase(CodeCacheProvider codeCache) {
        return new AddressLoweringByNodePhase((AddressLoweringByNodePhase.AddressLowering)new WebImageWasmLMAddressLowering());
    }

    @Override
    public void emitBackEnd(StructuredGraph graph, Object stub, ResolvedJavaMethod installedCodeOwner, CompilationResult compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator, RegisterConfig config, LIRSuites lirSuites) {
        super.emitBackEnd(graph, stub, installedCodeOwner, compilationResult, factory, entryPointDecorator, config, lirSuites);
        WebImageWasmCompilationResult wasmCompilationResult = (WebImageWasmCompilationResult)compilationResult;
        HostedMethod hostedMethod = (HostedMethod)graph.method();
        wasmCompilationResult.setParamTypes(WebImageWasmBackend.constructParamTypes(this.wasmProviders, hostedMethod));
        wasmCompilationResult.setReturnType(WebImageWasmBackend.constructReturnType((ResolvedJavaMethod)hostedMethod));
        Function fun = this.createFunction(hostedMethod, this.wasmProviders.idFactory(), wasmCompilationResult);
        wasmCompilationResult.setFunction(fun);
        WasmBlockContext topContext = WasmBlockContext.getTopLevel(fun.getInstructions());
        ScheduleWithReconstructionResult schedule = (ScheduleWithReconstructionResult)graph.getLastSchedule();
        ControlFlowGraph cfg = schedule.getCFG();
        BlockMap blockToNodeMap = schedule.getBlockToNodesMap();
        ReconstructionData reconstructionData = schedule.reconstructionData();
        WasmCodeGenTool masm = this.createCodeGenTool(new WebImageWasmVariableAllocation(), wasmCompilationResult, topContext, graph);
        masm.prepareForMethod(graph);
        new WasmIRWalker(masm, cfg, (BlockMap<List<Node>>)blockToNodeMap, (NodeMap<HIRBlock>)cfg.getNodeToBlock(), reconstructionData).lowerFunction(graph.getDebug());
    }

    public abstract WasmCodeGenTool createCodeGenTool(WebImageWasmVariableAllocation var1, WebImageWasmCompilationResult var2, WasmBlockContext var3, StructuredGraph var4);

    protected Function createFunction(HostedMethod m, WasmIdFactory idFactory, WebImageWasmCompilationResult compilationResult) {
        TypeUse typeUse = WebImageWasmBackend.signatureToTypeUse(this.wasmProviders, (JavaType[])compilationResult.getParamTypes(), (JavaType)compilationResult.getReturnType());
        return Function.create(idFactory, idFactory.forMethod((ResolvedJavaMethod)m), this.functionIdForMethod(typeUse), typeUse, m.format("%H.%n(%P)%R"));
    }

    protected WasmId.FuncType functionIdForMethod(TypeUse typeUse) {
        return this.wasmProviders.idFactory.newFuncType(FunctionTypeDescriptor.createSimple(typeUse));
    }

    public static TypeUse signatureToTypeUse(WebImageWasmProviders wasmProviders, JavaType[] paramTypes, JavaType returnType) {
        List<WasmValType> params = Arrays.stream(paramTypes).map(type -> WebImageWasmBackend.getAccurateType(wasmProviders, type)).collect(Collectors.toList());
        List<Object> results = returnType.getJavaKind() == JavaKind.Void ? Collections.emptyList() : Collections.singletonList(WebImageWasmBackend.getAccurateType(wasmProviders, returnType));
        return new TypeUse(params, results);
    }

    public static TypeUse methodToTypeUse(WebImageWasmProviders wasmProviders, HostedMethod m) {
        return WebImageWasmBackend.signatureToTypeUse(wasmProviders, (JavaType[])WebImageWasmBackend.constructParamTypes(wasmProviders, m), (JavaType)WebImageWasmBackend.constructReturnType((ResolvedJavaMethod)m));
    }

    private static WasmValType getAccurateType(WebImageWasmProviders wasmProviders, JavaType type) {
        ResolvedJavaType inputType = type.resolve(null);
        return wasmProviders.util().typeForJavaType((JavaType)inputType);
    }

    public static ResolvedJavaType[] constructParamTypes(WebImageWasmProviders providers, HostedMethod m) {
        ResolvedSignature sig = m.getSignature();
        ArrayList<ResolvedJavaType> paramTypes = new ArrayList<ResolvedJavaType>(sig.getParameterCount(true));
        if (m.hasReceiver()) {
            paramTypes.add(providers.getReceiverType(m));
        }
        for (int i = 0; i < sig.getParameterCount(false); ++i) {
            paramTypes.add(sig.getParameterType(i, null).resolve(null));
        }
        return (ResolvedJavaType[])paramTypes.toArray(ResolvedJavaType[]::new);
    }

    public static ResolvedJavaType constructReturnType(ResolvedJavaMethod m) {
        Signature sig = m.getSignature();
        return sig.getReturnType(null).resolve(null);
    }
}

