/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.visitors.WasmVisitor;
import com.oracle.svm.hosted.webimage.wasm.codegen.AbsoluteIPConstant;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmBlockContext;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmCompilationResult;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import com.oracle.svm.hosted.webimage.wasm.nodes.WebImageWasmVMThreadLocalSTHolderNode;
import com.oracle.svm.hosted.webimage.wasm.stack.StackClearer;
import com.oracle.svm.hosted.webimage.wasm.stack.StackFrameSizeConstant;
import com.oracle.svm.hosted.webimage.wasm.stack.VirtualStackSlotConstant;
import com.oracle.svm.webimage.wasm.stack.WebImageWasmFrameMap;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.iterators.NodePredicate;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.hightiercodegen.variables.VariableAllocation;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.framemap.FrameMapBuilderTool;
import jdk.graal.compiler.lir.framemap.SimpleVirtualStackSlot;
import jdk.graal.compiler.lir.framemap.VirtualStackSlotRange;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.Proxy;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.collections.EconomicSet;

public class WasmLMCodeGenTool
extends WasmCodeGenTool {
    private final FrameMapBuilderTool frameMapBuilder;
    private int ip = 0;
    private final EconomicSet<ValueNode> spilledNodes = EconomicSet.create((int)16);

    protected WasmLMCodeGenTool(CoreProviders provider, VariableAllocation variableAllocation, WebImageWasmCompilationResult compilationResult, WebImageWasmProviders wasmProviders, WasmBlockContext topContext, FrameMapBuilderTool frameMapBuilder, StructuredGraph graph) {
        super(provider, variableAllocation, compilationResult, wasmProviders, topContext, graph);
        this.frameMapBuilder = frameMapBuilder;
    }

    @Override
    public Instruction.AbstractCall getCall(InvokeTarget target, boolean direct, Instruction.AbstractCall callInstruction) {
        int posBefore = this.getIp();
        int posAfter = this.allocateIp();
        if (direct ? !$assertionsDisabled && !(callInstruction instanceof Instruction.Call) : !$assertionsDisabled && !(callInstruction instanceof Instruction.CallIndirect)) {
            throw new AssertionError(callInstruction);
        }
        this.recordCall(posBefore, posAfter, target, direct);
        this.genIPSetter();
        return callInstruction;
    }

    public void prepareForMethod(StructuredGraph g) {
        for (ValueNode node : g.getNodes().filter(ValueNode.class).filter((NodePredicate)NodePredicates.isNotA(ConstantNode.class).nor(WebImageWasmVMThreadLocalSTHolderNode.class))) {
            if (node instanceof Proxy && node instanceof CompressionNode || !(node.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp)) continue;
            this.spilledNodes.add((Object)node);
        }
        super.prepareForMethod(g);
    }

    @Override
    public void lowerPreamble() {
        this.genInst((Instruction)this.getKnownIds().stackPointer.setter(this.getStackRelativeAddress(new StackFrameSizeConstant(), false)), "Allocate stack frame");
        if (!this.spilledNodes.isEmpty()) {
            this.genInst((Instruction)new Instruction.Relocation(StackClearer.INSTANCE), "Clear stack frame");
        }
        this.genIPSetter("Store initial pseudo instruction pointer");
        if (this.nodeLowerer().stackPointerHolder != null) {
            this.genInst((Instruction)this.nodeLowerer().stackPointerHolder.setter(this.getKnownIds().stackPointer.getter()), "Preserve stack pointer");
        }
    }

    public int getIp() {
        return this.ip;
    }

    public int allocateIp() {
        ++this.ip;
        return this.getIp();
    }

    public void genIPSetter() {
        this.genIPSetter(null);
    }

    public void genIPSetter(Object comment) {
        this.genInst((Instruction)new Instruction.Store(WasmPrimitiveType.i32, new Instruction.Relocation((Reference)new ConstantReference((VMConstant)new AbsoluteIPConstant(this.method, this.getIp()))), this.getStackRelativeAddress(Instruction.Const.forInt(WebImageWasmFrameMap.getIPSize()), false)), comment == null ? "Set pseudo instruction pointer in callee's stack frame" : comment);
    }

    public Instruction getStackRelativeAddress(Instruction addend, boolean add) {
        Instruction.Binary.Op op = add ? Instruction.Binary.Op.I32Add : Instruction.Binary.Op.I32Sub;
        return op.create(this.getKnownIds().stackPointer.getter(), addend);
    }

    public Instruction getStackRelativeAddress(VMConstant addend, boolean add) {
        return this.getStackRelativeAddress(Instruction.Relocation.forConstant(addend), add);
    }

    public Instruction getStackSlotAddress(VirtualStackSlot slot) {
        return Instruction.Relocation.forConstant(new VirtualStackSlotConstant(slot));
    }

    public Instruction getCallerStackPointer() {
        return this.getStackRelativeAddress(new StackFrameSizeConstant(), true);
    }

    public VirtualStackSlot allocateStackMemory(int sizeInBytes, int alignmentInBytes) {
        return this.frameMapBuilder.allocateStackMemory(sizeInBytes, alignmentInBytes);
    }

    public VirtualStackSlot allocateSpillSlot() {
        return this.frameMapBuilder.allocateSpillSlot((ValueKind)LIRKind.Illegal);
    }

    public boolean isSpilled(ValueNode n) {
        return this.spilledNodes.contains((Object)n);
    }

    private void stackLayout() {
        List stackSlots = this.frameMapBuilder.getStackSlots();
        final StackSlot[] slotToOffset = new StackSlot[stackSlots.size()];
        for (VirtualStackSlot slot : stackSlots) {
            int id = slot.getId();
            if (slot instanceof VirtualStackSlotRange) {
                VirtualStackSlotRange range = (VirtualStackSlotRange)slot;
                slotToOffset[id] = this.frameMapBuilder.getFrameMap().allocateStackMemory(range.getSizeInBytes(), range.getAlignmentInBytes());
                continue;
            }
            if (slot instanceof SimpleVirtualStackSlot) {
                SimpleVirtualStackSlot simpleVirtualStackSlot = (SimpleVirtualStackSlot)slot;
                slotToOffset[id] = this.frameMapBuilder.getFrameMap().allocateSpillSlot(simpleVirtualStackSlot.getValueKind());
                this.compilationResult.addLiveStackSlot(slotToOffset[id]);
                continue;
            }
            throw GraalError.shouldNotReachHere((String)slot.toString());
        }
        this.frameMapBuilder.getFrameMap().finish();
        final int frameSize = this.frameMapBuilder.getFrameMap().totalFrameSize();
        new WasmVisitor(this){
            final /* synthetic */ WasmLMCodeGenTool this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void visitRelocation(Instruction.Relocation relocation) {
                super.visitRelocation(relocation);
                Reference reference = relocation.target;
                if (reference instanceof ConstantReference) {
                    ConstantReference constantReference = (ConstantReference)reference;
                    VMConstant constant = constantReference.getConstant();
                    if (constant instanceof StackFrameSizeConstant) {
                        relocation.setValue(Instruction.Const.forInt(frameSize));
                    } else if (constant instanceof VirtualStackSlotConstant) {
                        VirtualStackSlotConstant virtualStackSlot = (VirtualStackSlotConstant)constant;
                        StackSlot stackSlot = slotToOffset[virtualStackSlot.stackSlot().getId()];
                        int offset = stackSlot.getOffset(frameSize);
                        Instruction.GlobalGet stackPointer = this.this$0.getKnownIds().stackPointer.getter();
                        Instruction.GlobalGet value = offset == 0 ? stackPointer : Instruction.Binary.Op.I32Add.create(stackPointer, Instruction.Const.forInt(offset));
                        relocation.setComment(virtualStackSlot.stackSlot());
                        relocation.setValue(value);
                    }
                } else if (relocation.target instanceof StackClearer) {
                    int sizeToClear = frameSize - WebImageWasmFrameMap.frameSetupSize();
                    ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                    if (sizeToClear == 0) {
                        instructions.add(new Instruction.Nop());
                    } else if (sizeToClear == 4) {
                        instructions.add(new Instruction.Store(WasmPrimitiveType.i32, Instruction.Const.forInt(0), this.this$0.getKnownIds().stackPointer.getter()));
                    } else if (sizeToClear == 8) {
                        instructions.add(new Instruction.Store(WasmPrimitiveType.i64, Instruction.Const.forLong(0L), this.this$0.getKnownIds().stackPointer.getter()));
                    } else if (sizeToClear == 12) {
                        instructions.add(new Instruction.Store(WasmPrimitiveType.i64, 0, Instruction.Const.forLong(0L), (Instruction)this.this$0.getKnownIds().stackPointer.getter()));
                        instructions.add(new Instruction.Store(WasmPrimitiveType.i32, 8, Instruction.Const.forInt(0), (Instruction)this.this$0.getKnownIds().stackPointer.getter()));
                    } else if (sizeToClear == 16) {
                        instructions.add(new Instruction.Store(WasmPrimitiveType.i64, Instruction.Const.forLong(0L), this.this$0.getKnownIds().stackPointer.getter()));
                        instructions.add(new Instruction.Store(WasmPrimitiveType.i64, 8, Instruction.Const.forLong(0L), (Instruction)this.this$0.getKnownIds().stackPointer.getter()));
                    } else {
                        instructions.add(new Instruction.MemoryFill(this.this$0.getKnownIds().stackPointer.getter(), Instruction.Const.forInt(0), Instruction.Const.forInt(sizeToClear)));
                    }
                    if (instructions.size() == 1) {
                        relocation.setValue((Instruction)instructions.get(0));
                    } else {
                        Instruction.Block block = new Instruction.Block(null);
                        block.instructions.addAll(instructions);
                        relocation.setValue(block);
                    }
                }
            }
        }.visitFunction(this.compilationResult.getFunction());
        this.compilationResult.setTotalFrameSize(frameSize);
    }

    @Override
    public void finish() {
        super.finish();
        this.stackLayout();
        this.compilationResult.setTargetCode(new byte[0], this.getIp() + 1);
    }
}

