/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.hosted.webimage.logging.LoggerContext;
import com.oracle.svm.hosted.webimage.metrickeys.MethodMetricKeys;
import com.oracle.svm.hosted.webimage.wasm.ast.Instruction;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.phases.WasmSwitchPhase;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.irwalk.StackifierIRWalker;
import jdk.graal.compiler.hightiercodegen.lowerer.MoveResolver;
import jdk.graal.compiler.hightiercodegen.lowerer.PhiResolveLowerer;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.hightiercodegen.reconstruction.StackifierData;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlock;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlockGeneration;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.CatchScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.IfScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.LoopScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.Scope;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.SwitchScopeContainer;
import jdk.graal.compiler.hightiercodegen.variables.ResolvedVar;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import jdk.graal.compiler.nodes.java.TypeSwitchNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.Pair;

public class WasmIRWalker
extends StackifierIRWalker {
    protected final WasmCodeGenTool masm;

    public WasmIRWalker(WasmCodeGenTool codeGenTool, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodeMap, NodeMap<HIRBlock> nodeToBlockMap, ReconstructionData reconstructionData) {
        super((CodeGenTool)codeGenTool, cfg, blockToNodeMap, nodeToBlockMap, reconstructionData);
        this.masm = codeGenTool;
    }

    protected void lower(DebugContext debugContext) {
        List<Instruction> instructions;
        LoggerContext.counter(MethodMetricKeys.NUM_BLOCKS).add(this.stackifierData.getBlocks().length);
        this.masm.lowerPreamble();
        super.lower(debugContext);
        if (this.cfg.graph.method().getSignature().getReturnKind() != JavaKind.Void && !(instructions = this.masm.getInstructions().get()).isEmpty() && !(instructions.getLast() instanceof Instruction.Return)) {
            this.masm.genInst((Instruction)new Instruction.Unreachable(), "Implicit return unreachable");
        }
        this.masm.finish();
    }

    protected void predeclareVariables(StructuredGraph graph) {
        for (AbstractMergeNode merge : graph.getNodes(AbstractMergeNode.TYPE)) {
            for (PhiNode phi : merge.phis()) {
                ResolvedVar phiVar = this.masm.getAllocatedVariable((ValueNode)phi);
                if (phiVar == null) continue;
                phiVar.setDefinitionLowered();
            }
        }
    }

    private void generateForwardJump(HIRBlock currentBlock, HIRBlock successor) {
        WasmId.Label id = this.getForwardJumpTarget(currentBlock, successor);
        if (id != null) {
            this.masm.genInst((Instruction)new Instruction.Break(id), "forward jump");
        }
    }

    private WasmId.Label getForwardJumpTarget(HIRBlock currentBlock, HIRBlock successor) {
        if (LabeledBlockGeneration.isNormalLoopExit((HIRBlock)currentBlock, (HIRBlock)successor, (StackifierData)this.stackifierData)) {
            LabeledBlock jumpTarget = this.stackifierData.labeledBlockEnd(successor);
            assert (jumpTarget != null) : "Cannot jump out of loop " + String.valueOf(currentBlock.getLoop());
            return this.getLabeledBlockId(jumpTarget);
        }
        if (this.stackifierData.getLabeledBlockGeneration().isLabeledBlockNeeded(currentBlock, successor)) {
            LabeledBlock forwardBlock = this.stackifierData.labeledBlockEnd(successor);
            return this.getLabeledBlockId(forwardBlock);
        }
        return null;
    }

    protected void lowerLoop(HIRBlock currentBlock) {
        assert (currentBlock.isLoopHeader()) : currentBlock.toString(Verbosity.Name);
        LoopScopeContainer loopScopeEntry = (LoopScopeContainer)this.stackifierData.getScopeEntry((Node)currentBlock.getBeginNode());
        Scope loopScope = loopScopeEntry.getLoopScope();
        Instruction.Loop loop = this.labeledLoop(currentBlock);
        this.lowerBlocks(loopScope.getSortedBlocks(this.stackifierData));
        this.masm.parentScope(loop.getLabel());
    }

    protected void lowerLoopEnd(LoopEndNode loopEnd) {
        this.lowerPhiSchedule((AbstractEndNode)loopEnd);
        LoopBeginNode loopBeginNode = loopEnd.loopBegin();
        LoopScopeContainer scopeEntry = (LoopScopeContainer)this.stackifierData.getScopeEntry((Node)loopBeginNode);
        HIRBlock loopHeader = scopeEntry.getLoopScope().getStartBlock();
        this.masm.genInst((Instruction)new Instruction.Break(this.getLabeledLoopId(loopHeader)), (Node)loopEnd);
    }

    protected void lowerWithException(HIRBlock currentBlock, WithExceptionNode lastNode) {
        assert (currentBlock.getEndNode() == lastNode) : currentBlock.toString(Verbosity.Name);
        Instruction.Try tryBlock = new Instruction.Try(null);
        this.masm.genInst((Instruction)tryBlock, (Node)lastNode);
        this.masm.childScope(tryBlock.instructions, tryBlock);
        this.lowerNode((Node)lastNode);
        HIRBlock normSucc = this.cfg.blockFor((Node)lastNode.next());
        this.generateForwardJump(currentBlock, normSucc);
        this.masm.parentScope(tryBlock);
        this.masm.lowerCatchBlock(tryBlock, () -> {
            CatchScopeContainer scopeEntry = (CatchScopeContainer)this.stackifierData.getScopeEntry((Node)lastNode);
            Scope catchScope = scopeEntry.getCatchScope();
            if (catchScope != null) {
                this.lowerBlocks(catchScope.getSortedBlocks(this.stackifierData));
            } else {
                HIRBlock excpSucc = this.cfg.blockFor((Node)lastNode.exceptionEdge());
                this.generateForwardJump(currentBlock, excpSucc);
            }
        });
    }

    protected void lowerIf(HIRBlock currentBlock, IfNode lastNode) {
        assert (currentBlock.getEndNode() == lastNode) : currentBlock.toString(Verbosity.Name);
        IfScopeContainer ifScopeContainer = (IfScopeContainer)this.stackifierData.getScopeEntry((Node)lastNode);
        Instruction.If ifBlock = new Instruction.If(null, this.masm.lowerExpression((ValueNode)lastNode.condition(), Requirements.defaults().setStrictLogic(false)));
        this.masm.genInst((Instruction)ifBlock, (Node)lastNode);
        Scope thenScope = ifScopeContainer.getThenScope();
        this.masm.childScope(ifBlock.thenInstructions, ifBlock);
        if (thenScope != null) {
            this.lowerBlocks(thenScope.getSortedBlocks(this.stackifierData));
        } else {
            HIRBlock trueBlock = (HIRBlock)this.nodeToBlockMap.get((Node)lastNode.trueSuccessor());
            this.generateForwardJump(currentBlock, trueBlock);
        }
        this.masm.parentScope(ifBlock);
        this.masm.childScope(ifBlock.elseInstructions, ifBlock);
        Scope elseScope = ifScopeContainer.getElseScope();
        if (elseScope != null) {
            this.lowerBlocks(elseScope.getSortedBlocks(this.stackifierData));
        } else {
            HIRBlock falseBlock = (HIRBlock)this.nodeToBlockMap.get((Node)lastNode.falseSuccessor());
            this.generateForwardJump(currentBlock, falseBlock);
        }
        this.masm.parentScope(ifBlock);
    }

    protected void lowerUnhandledBlockEnd(HIRBlock currentBlock, FixedNode lastNode) {
        if (lastNode instanceof AbstractEndNode) {
            AbstractEndNode endNode = (AbstractEndNode)lastNode;
            this.lowerPhiSchedule(endNode);
        } else if (!(lastNode instanceof LoopExitNode) && !(lastNode instanceof LoopBeginNode)) {
            this.lowerNode((Node)lastNode);
        }
        this.generateForwardJump(currentBlock, this.getSuccessorForUnhandledBlockEnd(lastNode));
    }

    protected void lowerSwitch(IntegerSwitchNode switchNode) {
        int successorIndex;
        if (!WasmSwitchPhase.isSimplified(switchNode)) {
            this.lowerDegenerateSwitch(switchNode);
            return;
        }
        assert (WasmSwitchPhase.isSimplified(switchNode));
        assert (switchNode.defaultSuccessor() != null);
        int numSuccessors = switchNode.blockSuccessorCount();
        Scope[] caseScopes = ((SwitchScopeContainer)this.stackifierData.getScopeEntry((Node)switchNode)).getCaseScopes();
        assert (caseScopes != null);
        assert (caseScopes.length == numSuccessors) : caseScopes.length + " != " + numSuccessors;
        Map<Integer, List<Integer>> successorToKeys = WasmSwitchPhase.getSuccessorToKeysMap(switchNode);
        Instruction.BreakTable brTable = new Instruction.BreakTable(this.masm.lowerExpression(switchNode.value()));
        WasmId.Label[] blockLabels = new WasmId.Label[numSuccessors];
        for (successorIndex = numSuccessors - 1; successorIndex >= 0; --successorIndex) {
            WasmId.Label id;
            boolean isDefault;
            boolean necessary = caseScopes[successorIndex] != null;
            AbstractBeginNode successor = switchNode.blockSuccessor(successorIndex);
            boolean bl = isDefault = successorIndex == switchNode.defaultSuccessorIndex();
            if (necessary) {
                id = this.masm.idFactory.newSwitchLabel();
                this.genLabeledBlockHeader(id, "Case: " + (isDefault ? "default" : Integer.toString(successorIndex)));
                blockLabels[successorIndex] = id;
            } else {
                id = this.getForwardJumpTarget(this.cfg.blockFor((Node)switchNode), this.cfg.blockFor((Node)successor));
            }
            if (isDefault) {
                brTable.setDefaultTarget(id);
                continue;
            }
            for (Integer key : successorToKeys.get(successorIndex)) {
                brTable.setTarget(key, id);
            }
        }
        this.masm.genInst((Instruction)brTable, (Node)switchNode);
        for (successorIndex = 0; successorIndex < numSuccessors; ++successorIndex) {
            WasmId.Label blockLabel = blockLabels[successorIndex];
            if (blockLabel == null) continue;
            this.masm.parentScope(blockLabel);
            this.lowerBlocks(caseScopes[successorIndex].getSortedBlocks(this.stackifierData));
        }
    }

    protected void lowerTypeSwitch(TypeSwitchNode switchNode) {
        throw GraalError.unimplementedOverride();
    }

    protected void lowerDegenerateSwitch(IntegerSwitchNode switchNode) {
        int numSuccessors = switchNode.getSuccessorCount();
        Map<Integer, List<Integer>> successorToKeys = WasmSwitchPhase.getSuccessorToKeysMap(switchNode);
        assert (numSuccessors > 1) : "Degenerate switch must have more than one successor, has " + numSuccessors;
        Scope[] caseScopes = ((SwitchScopeContainer)this.stackifierData.getScopeEntry((Node)switchNode)).getCaseScopes();
        assert (caseScopes != null);
        assert (caseScopes.length == numSuccessors) : caseScopes.length + " != " + numSuccessors;
        for (int successorIndex = 0; successorIndex < numSuccessors; ++successorIndex) {
            AbstractBeginNode successor = switchNode.blockSuccessor(successorIndex);
            if (switchNode.defaultSuccessorIndex() == successorIndex) continue;
            List<Integer> keys = successorToKeys.get(successorIndex);
            assert (!keys.isEmpty()) : "Successor " + String.valueOf(successor) + " does not have any associated keys";
            Stream<Instruction> keyChecks = keys.stream().map(Instruction.Const::forInt).map(keyInst -> Instruction.Binary.Op.I32Eq.create((Instruction)keyInst, this.masm.lowerExpression(switchNode.value())));
            Instruction anyKeyCheck = keyChecks.reduce(Instruction.Binary.Op.I32Or::create).get();
            Instruction.If ifBlock = new Instruction.If(null, anyKeyCheck);
            String comment = "Key check for " + String.valueOf(keys);
            if (successorIndex == 0) {
                comment = "Degenerate switch: " + String.valueOf(switchNode) + ", " + comment;
            }
            this.masm.genInst((Instruction)ifBlock, comment);
            this.masm.childScope(ifBlock.thenInstructions, null);
            Scope caseScope = caseScopes[successorIndex];
            if (caseScope == null) {
                WasmId.Label jumpTarget = this.getForwardJumpTarget(this.cfg.blockFor((Node)switchNode), this.cfg.blockFor((Node)successor));
                this.masm.genInst((Instruction)new Instruction.Break(jumpTarget), "forward jump out of switch");
            } else {
                this.lowerBlocks(caseScope.getSortedBlocks(this.stackifierData));
            }
            this.masm.parentScope(null);
            this.masm.childScope(ifBlock.elseInstructions, Pair.create((Object)switchNode, (Object)successorIndex));
        }
        Scope defaultScope = caseScopes[switchNode.defaultSuccessorIndex()];
        if (defaultScope == null) {
            WasmId.Label jumpTarget = this.getForwardJumpTarget(this.cfg.blockFor((Node)switchNode), this.cfg.blockFor((Node)switchNode.defaultSuccessor()));
            this.masm.genInst((Instruction)new Instruction.Break(jumpTarget), "forward jump out of switch to default case");
        } else {
            this.lowerBlocks(defaultScope.getSortedBlocks(this.stackifierData));
        }
        for (int successorIndex = numSuccessors - 1; successorIndex >= 0; --successorIndex) {
            if (successorIndex == switchNode.defaultSuccessorIndex()) continue;
            this.masm.parentScope(Pair.create((Object)switchNode, (Object)successorIndex));
        }
    }

    protected void genLabeledBlockHeader(LabeledBlock labeledBlock) {
        this.genLabeledBlockHeader(this.getLabeledBlockId(labeledBlock), labeledBlock);
    }

    protected void genLabeledBlockHeader(WasmId.Label id, Object comment) {
        Instruction.Block block = new Instruction.Block(id);
        this.masm.genInst((Instruction)block, comment);
        this.masm.childScope(block.instructions, id);
    }

    protected void genLabeledBlockEnd(LabeledBlock labeledBlock) {
        this.masm.parentScope(this.getLabeledBlockId(labeledBlock));
    }

    protected WasmId.Label getLabeledBlockId(LabeledBlock labeledBlock) {
        return this.masm.idFactory.forBlockLabel(labeledBlock);
    }

    protected Instruction.Loop labeledLoop(HIRBlock loopHeader) {
        assert (loopHeader.isLoopHeader()) : loopHeader.toString(Verbosity.Name);
        Instruction.Loop loop = new Instruction.Loop(this.getLabeledLoopId(loopHeader));
        this.masm.genInst((Instruction)loop, (Node)loopHeader.getBeginNode());
        this.masm.childScope(loop.instructions, loop.getLabel());
        return loop;
    }

    protected WasmId.Label getLabeledLoopId(HIRBlock loopHeader) {
        assert (loopHeader.isLoopHeader()) : loopHeader.toString(Verbosity.Name);
        return this.masm.idFactory.forLoopLabel(loopHeader);
    }

    protected void lowerPhiSchedule(AbstractEndNode node) {
        MoveResolver.Schedule schedule = new PhiResolveLowerer(node).scheduleMoves((CodeGenTool)this.masm);
        HashMap<WasmValType, WasmId.Local> temporaries = new HashMap<WasmValType, WasmId.Local>();
        for (MoveResolver.Schedule.Move move : schedule.moves) {
            Instruction value;
            WasmValType type = this.masm.wasmProviders.util().typeForNode((ValueNode)move.source);
            if (move.target == null) {
                assert (schedule.needsTemporary()) : "If a move to null exists, the schedule needs a temporary variable.";
                WasmId.Local target = temporaries.computeIfAbsent(type, this.masm.idFactory::newTemporaryVariable);
                Instruction value2 = this.masm.lowerExpression((ValueNode)move.source);
                this.masm.genInst(target.setter(value2));
                continue;
            }
            if (move.useTemporary) {
                assert (temporaries.containsKey(type)) : "No temporary allocated for type " + String.valueOf(type);
                value = ((WasmId.Local)temporaries.get(type)).getter();
            } else {
                value = this.masm.lowerExpression((ValueNode)move.source);
            }
            this.masm.nodeLowerer().lowerVariableStore((ValueNode)move.target, value);
        }
    }

    public static class Requirements
    implements Cloneable {
        private boolean strictLogic = true;

        public static Requirements defaults() {
            return new Requirements();
        }

        public static Requirements valueIgnored() {
            return Requirements.defaults().setStrictLogic(false);
        }

        public Requirements clone() {
            try {
                return (Requirements)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean hasStrictLogic() {
            return this.strictLogic;
        }

        public Requirements setStrictLogic(boolean strictLogic) {
            this.strictLogic = strictLogic;
            return this;
        }
    }
}

