/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.webimage.wasm.codegen;

import com.oracle.svm.hosted.webimage.wasm.ast.TypeUse;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmId;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WasmIdFactory;
import com.oracle.svm.hosted.webimage.wasm.ast.id.WebImageWasmIds;
import com.oracle.svm.hosted.webimage.wasm.codegen.WasmCodeGenTool;
import com.oracle.svm.hosted.webimage.wasm.codegen.WebImageWasmProviders;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import jdk.graal.compiler.debug.GraalError;

public abstract class WasmFunctionTemplate<T> {
    protected final WasmIdFactory idFactory;
    protected final boolean isLate;
    private final AtomicBoolean frozen = new AtomicBoolean(false);
    private final Lock lock = new Lock();
    private final Map<T, WasmId.Func> functionIds = new HashMap<T, WasmId.Func>();
    private final Map<WasmId.Func, T> notYetGenerated = new HashMap<WasmId.Func, T>();

    protected WasmFunctionTemplate(WasmIdFactory idFactory) {
        this(idFactory, false);
    }

    protected WasmFunctionTemplate(WasmIdFactory idFactory, boolean isLate) {
        this.idFactory = idFactory;
        this.isLate = isLate;
    }

    public boolean isFrozen() {
        return this.frozen.get();
    }

    private boolean assertNotFrozen() {
        assert (!this.isFrozen()) : "Attempt to modify frozen function template: " + String.valueOf(this);
        return true;
    }

    public void freeze() {
        assert (!this.isFrozen()) : "Function template is already frozen: " + String.valueOf(this);
        assert (this.allFunctionsGenerated()) : "Attempt to freeze function template before all functions were generated: " + String.valueOf(this);
        this.frozen.set(true);
    }

    protected boolean isValidParameter(T parameter) {
        return true;
    }

    protected final boolean isLateTemplate() {
        return this.isLate;
    }

    protected final void validateParameter(T parameter) {
        GraalError.guarantee((boolean)this.isValidParameter(parameter), (String)"Invalid parameter detected in %s: %s", this.getClass(), parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final WasmId.Func requestFunctionId(T parameter) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.validateParameter(parameter);
            return this.functionIds.computeIfAbsent(parameter, k -> {
                assert (this.assertNotFrozen());
                WebImageWasmIds.InternalFunction functionId = this.idFactory.newInternalFunction(this.getFunctionName(k));
                this.notYetGenerated.put(functionId, k);
                return functionId;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wasRequested(T parameter) {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.functionIds.containsKey(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allFunctionsGenerated() {
        Lock lock = this.lock;
        synchronized (lock) {
            return this.notYetGenerated.isEmpty();
        }
    }

    public com.oracle.svm.hosted.webimage.wasm.ast.Function createFunctionForId(WasmCodeGenTool codeGenTool, WasmId.Func func) {
        assert (!this.isLateTemplate()) : "This is a late template and can't be generated regularly: " + String.valueOf(this);
        return this.createFunctionForId(func, (T p) -> new Context(codeGenTool, p));
    }

    public com.oracle.svm.hosted.webimage.wasm.ast.Function createFunctionForIdLate(WebImageWasmProviders providers, WasmId.Func func) {
        assert (this.isLateTemplate()) : "This is a regular template and can't be generated late: " + String.valueOf(this);
        return this.createFunctionForId(func, (T p) -> new Context(providers, p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.oracle.svm.hosted.webimage.wasm.ast.Function createFunctionForId(WasmId.Func func, Function<T, Context> contextCreator) {
        Lock lock = this.lock;
        synchronized (lock) {
            assert (this.functionIds.containsValue(func)) : "This function ID was not produced by this template: " + String.valueOf(func);
            T param = this.notYetGenerated.remove(func);
            assert (param != null) : "A function for this ID has already been generated: " + String.valueOf(func);
            return this.createFunction(contextCreator.apply(param));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WasmId.Func> getNotYetGenerated() {
        Lock lock = this.lock;
        synchronized (lock) {
            return new ArrayList<WasmId.Func>(this.notYetGenerated.keySet());
        }
    }

    protected abstract String getFunctionName(T var1);

    protected abstract com.oracle.svm.hosted.webimage.wasm.ast.Function createFunction(Context var1);

    private static final class Lock {
        private Lock() {
        }
    }

    protected final class Context {
        private final WasmCodeGenTool codeGenTool;
        private final WebImageWasmProviders providers;
        private final T param;

        private Context(WasmCodeGenTool codeGenTool, WebImageWasmProviders providers, T param) {
            this.codeGenTool = codeGenTool;
            this.providers = providers;
            this.param = param;
        }

        public Context(WasmCodeGenTool codeGenTool, T param) {
            this(codeGenTool, codeGenTool.getWasmProviders(), param);
            assert (!this$0.isLateTemplate()) : "Created regular context for late template";
        }

        public Context(WebImageWasmProviders providers, T param) {
            this(null, providers, param);
            assert (this$0.isLateTemplate()) : "Created late context for regular template";
        }

        public WasmCodeGenTool getCodeGenTool() {
            if (WasmFunctionTemplate.this.isLateTemplate()) {
                throw GraalError.shouldNotReachHere((String)("This is a late-generating template, it does not have access to " + String.valueOf(WasmCodeGenTool.class) + ": " + String.valueOf(WasmFunctionTemplate.this)));
            }
            return this.codeGenTool;
        }

        public WebImageWasmProviders getProviders() {
            return this.providers;
        }

        public T getParameter() {
            if (WasmFunctionTemplate.this instanceof Singleton) {
                throw GraalError.shouldNotReachHere((String)("This is a singleton template, it does not have a parameter: " + String.valueOf(WasmFunctionTemplate.this)));
            }
            return this.param;
        }

        public com.oracle.svm.hosted.webimage.wasm.ast.Function createFunction(TypeUse typeUse, Object comment) {
            return com.oracle.svm.hosted.webimage.wasm.ast.Function.createSimple(WasmFunctionTemplate.this.idFactory, this.getId(), typeUse, comment);
        }

        public com.oracle.svm.hosted.webimage.wasm.ast.Function createFunction(WebImageWasmIds.DescriptorFuncType funcType, Object comment) {
            return com.oracle.svm.hosted.webimage.wasm.ast.Function.create(WasmFunctionTemplate.this.idFactory, this.getId(), funcType, funcType.getTypeUse(), comment);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WasmId.Func getId() {
            Lock lock = WasmFunctionTemplate.this.lock;
            synchronized (lock) {
                assert (WasmFunctionTemplate.this.wasRequested(this.param));
                return WasmFunctionTemplate.this.functionIds.get(this.param);
            }
        }
    }

    public static abstract class Singleton
    extends WasmFunctionTemplate<Param> {
        protected Singleton(WasmIdFactory idFactory) {
            super(idFactory);
        }

        protected Singleton(WasmIdFactory idFactory, boolean isLate) {
            super(idFactory, isLate);
        }

        @Override
        protected final boolean isValidParameter(Param parameter) {
            return parameter == Param.INSTANCE;
        }

        public WasmId.Func requestFunctionId() {
            return this.requestFunctionId(Param.INSTANCE);
        }

        @Override
        protected final String getFunctionName(Param parameter) {
            return this.getFunctionName();
        }

        protected abstract String getFunctionName();

        protected static final class Param {
            static final Param INSTANCE = new Param();

            private Param() {
            }
        }
    }
}

